/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.util;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.util.DBUtils;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.CustomTablesAdapter;

public class CustomTables
extends MedSavantServerUnicastRemoteObject
implements CustomTablesAdapter {
    private static CustomTables instance;
    private static final int MAX_TABLES = 30;
    private Map<String, Map<String, TableSchema>> dbnameToTableMap = new HashMap<String, Map<String, TableSchema>>();

    public static synchronized CustomTables getInstance() throws RemoteException {
        if (instance == null) {
            instance = new CustomTables();
        }
        return instance;
    }

    private CustomTables() throws RemoteException {
    }

    @Override
    public TableSchema getCustomTableSchema(String sid, String tablename) throws SQLException, RemoteException, SessionExpiredException {
        return this.getCustomTableSchema(sid, tablename, false);
    }

    @Override
    public synchronized TableSchema getCustomTableSchema(String sid, String tablename, boolean update) throws SQLException, RemoteException, SessionExpiredException {
        String dbName = ConnectionController.getDBName(sid);
        if (!this.dbnameToTableMap.containsKey(dbName)) {
            this.dbnameToTableMap.put(dbName, new HashMap());
        }
        if (!this.dbnameToTableMap.get(dbName).containsKey(tablename) || update) {
            if (!this.dbnameToTableMap.get(dbName).containsKey(tablename) && this.isOverLimit()) {
                this.clearMap();
            }
            this.dbnameToTableMap.get(dbName).put(tablename, DBUtils.getInstance().importTableSchema(sid, tablename));
        }
        return this.dbnameToTableMap.get(dbName).get(tablename);
    }

    private boolean isOverLimit() {
        if (this.dbnameToTableMap.size() >= 30) {
            return true;
        }
        int size = 0;
        for (String dbName : this.dbnameToTableMap.keySet()) {
            size += this.dbnameToTableMap.get(dbName).size();
        }
        return size >= 30;
    }

    private void clearMap() {
        this.dbnameToTableMap.clear();
    }
}

