/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants.annotation;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broad.tabix.TabixReader;
import org.ut.biolab.medsavant.server.db.variants.annotation.BatchVariantAnnotator;
import org.ut.biolab.medsavant.server.serverapi.AnnotationManager;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.model.Annotation;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class AnnotationCursor {
    private static final Log LOG = LogFactory.getLog(AnnotationCursor.class);
    private final TabixReader reader;
    private final boolean annotationHasAlt;
    private final boolean annotationHasRef;
    private final boolean isInterval;
    private final Annotation annotation;
    private int pos_annot_index_of_chr = 0;
    private int pos_annot_index_of_pos = 1;
    private int pos_annot_index_of_ref = 2;
    private int pos_annot_index_of_alt = 3;
    private int int_annot_index_of_chr = 0;
    private int int_annot_index_of_start = 1;
    private int int_annot_index_of_end = 2;
    BatchVariantAnnotator.SimpleVariantRecord lastVariantAnnotated;
    SimpleAnnotationRecord lastAnnotationConsidered;
    String[] lastResult;
    public static final int MAX_BASEPAIR_DISTANCE_IN_WINDOW = 20000;
    private final AnnotationFormat annotationFormat;

    public AnnotationCursor(String sid, Annotation annotation) throws IOException, SQLException, SessionExpiredException, IllegalArgumentException {
        TabixReader headerReader = new TabixReader(annotation.getDataPath());
        String header = headerReader.readLine().trim();
        headerReader.cleanup();
        this.reader = new TabixReader(annotation.getDataPath());
        if (header.startsWith(String.valueOf(this.reader.getCommentChar()))) {
            String[] parts = header.split("\t");
            this.int_annot_index_of_chr = -1;
            this.pos_annot_index_of_chr = -1;
            this.int_annot_index_of_start = -1;
            this.int_annot_index_of_end = -1;
            this.pos_annot_index_of_ref = -1;
            this.pos_annot_index_of_alt = -1;
            this.pos_annot_index_of_pos = -1;
            for (int i = parts.length - 1; i >= 0; --i) {
                parts[i] = parts[i].replace("#", "").trim().toUpperCase();
                if (parts[i].equalsIgnoreCase("CHR") || parts[i].equalsIgnoreCase("CHROM")) {
                    this.pos_annot_index_of_chr = this.int_annot_index_of_chr = i;
                    continue;
                }
                if (parts[i].equalsIgnoreCase("START")) {
                    this.int_annot_index_of_start = i;
                    this.pos_annot_index_of_pos = i;
                    continue;
                }
                if (parts[i].equalsIgnoreCase("END")) {
                    this.int_annot_index_of_end = i;
                    continue;
                }
                if (parts[i].equalsIgnoreCase("REF")) {
                    this.pos_annot_index_of_ref = i;
                    continue;
                }
                if (parts[i].equalsIgnoreCase("ALT")) {
                    this.pos_annot_index_of_alt = i;
                    continue;
                }
                if (!parts[i].equalsIgnoreCase("POSITION")) continue;
                this.pos_annot_index_of_pos = i;
            }
            String missingCol = null;
            if (annotation.isInterval()) {
                if (this.int_annot_index_of_chr == -1) {
                    missingCol = "Chromosome";
                } else if (this.int_annot_index_of_start == -1) {
                    missingCol = "Start";
                } else if (this.int_annot_index_of_end == -1) {
                    missingCol = "End";
                }
            } else if (this.pos_annot_index_of_chr == -1) {
                missingCol = "Chromosome";
            } else if (this.pos_annot_index_of_ref == -1) {
                missingCol = "Ref";
            } else if (this.pos_annot_index_of_alt == -1) {
                missingCol = "Alt";
            } else if (this.pos_annot_index_of_pos == -1) {
                missingCol = "Position";
            }
            if (missingCol != null) {
                throw new IllegalArgumentException("Couldn't locate column " + missingCol + " in annotation " + annotation.getProgram() + " (ref=" + annotation.getReferenceName() + ")");
            }
        }
        this.annotation = annotation;
        this.annotationFormat = AnnotationManager.getInstance().getAnnotationFormat(sid, annotation.getID());
        this.annotationHasRef = this.annotationFormat.hasRef();
        this.annotationHasAlt = this.annotationFormat.hasAlt();
        this.isInterval = annotation.isInterval();
    }

    private String[] getVariantAnnotationString(String[] annotationLine) {
        String prefix = "";
        String[] result = new String[this.getNumNonDefaultFields()];
        int numNonDefaultFields = this.annotationFormat.getNumNonDefaultFields();
        int numDefaultFields = 2;
        if (this.annotationFormat.hasRef()) {
            ++numDefaultFields;
        }
        if (this.annotationFormat.hasAlt()) {
            ++numDefaultFields;
        }
        if (this.int_annot_index_of_end != -1) {
            ++numDefaultFields;
        }
        for (int i = 0; i < numNonDefaultFields; ++i) {
            result[i] = prefix;
            if (numDefaultFields + i >= annotationLine.length) continue;
            int n = i;
            result[n] = result[n] + annotationLine[numDefaultFields + i];
        }
        return result;
    }

    boolean annotateVariants(List<BatchVariantAnnotator.SimpleVariantRecord> variantWindow, long minStart, long maxEnd, int annotationIndex, boolean isLowDensity) throws Exception {
        if (!this.canAnnotateThisChromosome(variantWindow.get((int)0).chrom)) {
            return false;
        }
        if (isLowDensity) {
            for (BatchVariantAnnotator.SimpleVariantRecord svr : variantWindow) {
                TabixReader.Iterator annotationIt = this.reader.query(this.reader.chr2tid(variantWindow.get((int)0).chrom), (int)svr.start - 1, (int)svr.end);
                if (annotationIt == null) continue;
                while (annotationIt.hasNext()) {
                    String annotationLineStr = annotationIt.next();
                    String[] annotationLine = AnnotationCursor.removeNewLinesAndCarriageReturns(annotationLineStr).split("\t", -1);
                    SimpleAnnotationRecord annotationRecord = new SimpleAnnotationRecord(annotationLine);
                    if (!annotationRecord.matchesVariant(svr)) continue;
                    svr.annotate(annotationIndex, this.getVariantAnnotationString(annotationLine));
                }
            }
            return true;
        }
        TabixReader.Iterator annotationIt = this.reader.query(this.reader.chr2tid(variantWindow.get((int)0).chrom), (int)Math.max(0L, minStart - 1L), (int)maxEnd);
        if (annotationIt == null) {
            return true;
        }
        int variantWindowIndex = 0;
        block2: while (annotationIt.hasNext()) {
            String annotationLineStr = annotationIt.next();
            String[] annotationLine = AnnotationCursor.removeNewLinesAndCarriageReturns(annotationLineStr).split("\t", -1);
            SimpleAnnotationRecord annotationRecord = new SimpleAnnotationRecord(annotationLine);
            ListIterator<BatchVariantAnnotator.SimpleVariantRecord> variantWindowIt = variantWindow.listIterator(variantWindowIndex);
            while (variantWindowIt.hasNext()) {
                BatchVariantAnnotator.SimpleVariantRecord variantRecord = variantWindowIt.next();
                if (annotationRecord.matchesVariant(variantRecord)) {
                    variantRecord.annotate(annotationIndex, this.getVariantAnnotationString(annotationLine));
                    continue;
                }
                if (variantRecord.start <= annotationRecord.end) continue;
                variantWindowIndex = variantWindowIt.previousIndex();
                continue block2;
            }
        }
        return true;
    }

    public int getNumNonDefaultFields() {
        return this.annotationFormat.getNumNonDefaultFields();
    }

    private boolean canAnnotateThisChromosome(String chrom) {
        return this.reader.chr2tid(chrom) != -1;
    }

    private static String removeNewLinesAndCarriageReturns(String next) {
        next = next.replaceAll("\n", "");
        next = next.replaceAll("\r", "");
        return next;
    }

    private boolean checkIfHomogenizationIsNeeded(TabixReader reader) {
        for (String s : reader.getReferenceNames()) {
            if (!s.contains("chr") && !s.contains("contig")) continue;
            return true;
        }
        return false;
    }

    Annotation getAnnotation() {
        return this.annotation;
    }

    public void cleanup() throws IOException {
        this.reader.cleanup();
    }

    private class SimpleAnnotationRecord {
        public String chrom;
        public int position;
        public long start;
        public long end;
        public String ref;
        public String alt;

        public SimpleAnnotationRecord(String[] line) {
            this.setFromLine(line);
        }

        private void setFromLine(String[] line) {
            if (AnnotationCursor.this.isInterval) {
                this.setFromLineInterval(line);
            } else {
                this.setFromLinePosition(line);
            }
        }

        private void setFromLinePosition(String[] line) {
            this.chrom = line[AnnotationCursor.this.pos_annot_index_of_chr];
            if (!this.chrom.toLowerCase().startsWith("chr")) {
                this.chrom = "chr" + MiscUtils.homogenizeSequence(this.chrom);
            }
            this.position = Integer.parseInt(line[AnnotationCursor.this.pos_annot_index_of_pos]);
            this.start = this.end = (long)this.position;
            this.ref = AnnotationCursor.this.annotationHasRef ? line[AnnotationCursor.this.pos_annot_index_of_ref] : null;
            this.alt = AnnotationCursor.this.annotationHasAlt ? line[AnnotationCursor.this.pos_annot_index_of_alt] : null;
        }

        private void setFromLineInterval(String[] line) {
            this.chrom = line[AnnotationCursor.this.int_annot_index_of_chr];
            if (!this.chrom.toLowerCase().startsWith("chr")) {
                this.chrom = "chr" + MiscUtils.homogenizeSequence(this.chrom);
            }
            this.start = Integer.parseInt(line[AnnotationCursor.this.int_annot_index_of_start]);
            this.end = Integer.parseInt(line[AnnotationCursor.this.int_annot_index_of_end]);
            this.ref = null;
            this.alt = null;
        }

        public String toString() {
            if (AnnotationCursor.this.isInterval) {
                return "SimpleAnnotationRecord{chrom=" + this.chrom + ", start=" + this.start + ", end=" + this.end + '}';
            }
            return "SimpleAnnotationRecord{chrom=" + this.chrom + ", position=" + this.position + ", ref=" + this.ref + ", alt=" + this.alt + '}';
        }

        private boolean matchesRef(String ref) {
            return true;
        }

        private boolean matchesAlt(String alt) {
            return this.alt == null || this.alt != null && this.alt.equals(alt);
        }

        private boolean intersectsPosition(String chrom, long start, long end) {
            if (this.chrom.equals(chrom)) {
                if (this.start < start) {
                    return this.end >= start;
                }
                if (start < this.start) {
                    return end >= this.end;
                }
                return true;
            }
            return false;
        }

        private boolean matchesVariant(BatchVariantAnnotator.SimpleVariantRecord r) {
            return this.chrom.equals(r.chrom) && this.start == r.start && this.end == r.end && this.matchesAlt(r.alt);
        }
    }
}

