/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.ut.biolab.medsavant.server.mail.Mail;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;

public class EmailLogger
extends AppenderSkeleton {
    private static final Log LOG = LogFactory.getLog(EmailLogger.class);
    private static final String LOG_PATH = new File(DirectorySettings.getTmpDirectory(), "server.log").getAbsolutePath();
    private static String emailAddress;
    private BufferedWriter writer;

    public synchronized void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writer = null;
    }

    protected synchronized void append(LoggingEvent le) {
        try {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new FileWriter(LOG_PATH));
            }
            this.writer.write(this.layout.format(le));
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public static void setMailRecipient(String address) {
        emailAddress = address;
    }

    public static void logByEmail(String subject, String message) {
        EmailLogger.logByEmail(subject, message, null);
    }

    public static void logByEmail(String subject, String message, String cc) {
        long time = System.currentTimeMillis();
        if (emailAddress != null && !emailAddress.isEmpty()) {
            Mail.sendEmail(emailAddress, subject, message);
        } else {
            LOG.warn((Object)"Cannot send email, no email recipient configured");
        }
        if (cc != null) {
            Mail.sendEmail(cc, subject, message);
        }
    }
}

