/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.shared.model.AnnotationLog;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.SQLUtils;

public class AnnotationLogManager {
    private static AnnotationLogManager instance;

    public static synchronized AnnotationLogManager getInstance() {
        if (instance == null) {
            instance = new AnnotationLogManager();
        }
        return instance;
    }

    public int addAnnotationLogEntry(String sid, int projectId, int referenceId, AnnotationLog.Action action) throws SQLException, RemoteException, SessionExpiredException {
        return this.addAnnotationLogEntry(sid, projectId, referenceId, action, AnnotationLog.Status.STARTED);
    }

    public int addAnnotationLogEntry(String sid, int projectId, int referenceId, AnnotationLog.Action action, AnnotationLog.Status status) throws SQLException, RemoteException, SessionExpiredException {
        String user = SessionManager.getInstance().getUserForSession(sid);
        Timestamp sqlDate = SQLUtils.getCurrentTimestamp();
        MedSavantDatabase.VariantPendingUpdateTableSchema table = MedSavantDatabase.VariantpendingupdateTableSchema;
        InsertQuery query = new InsertQuery(table.getTable());
        query.addColumn(table.getDBColumn("project_id"), projectId);
        query.addColumn(table.getDBColumn("reference_id"), referenceId);
        query.addColumn(table.getDBColumn("action"), AnnotationLog.actionToInt(action));
        query.addColumn(table.getDBColumn("status"), AnnotationLog.statusToInt(status));
        query.addColumn(table.getDBColumn("timestamp"), sqlDate);
        query.addColumn(table.getDBColumn("user"), user);
        PooledConnection c = ConnectionController.connectPooled(sid);
        PreparedStatement stmt = c.prepareStatement(query.toString(), 1);
        stmt.execute();
        ResultSet rs = stmt.getGeneratedKeys();
        rs.next();
        c.close();
        return rs.getInt(1);
    }

    public void removeAnnotationLogEntry(String sid, int updateId) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantPendingUpdateTableSchema table = MedSavantDatabase.VariantpendingupdateTableSchema;
        DeleteQuery query = new DeleteQuery(table.getTable());
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("upload_id"), updateId));
        ConnectionController.executeUpdate(sid, query.toString());
    }

    public void setAnnotationLogStatus(String sid, int updateId, AnnotationLog.Status status) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantPendingUpdateTableSchema table = MedSavantDatabase.VariantpendingupdateTableSchema;
        UpdateQuery query = new UpdateQuery(table.getTable());
        query.addSetClause(table.getDBColumn("status"), AnnotationLog.statusToInt(status));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("upload_id"), updateId));
        ConnectionController.executeUpdate(sid, query.toString());
    }

    public void setAnnotationLogStatus(String sid, int updateId, AnnotationLog.Status status, Timestamp sqlDate) throws SQLException, SessionExpiredException {
        MedSavantDatabase.VariantPendingUpdateTableSchema table = MedSavantDatabase.VariantpendingupdateTableSchema;
        UpdateQuery query = new UpdateQuery(table.getTable());
        query.addSetClause(table.getDBColumn("status"), AnnotationLog.statusToInt(status));
        query.addSetClause(table.getDBColumn("timestamp"), sqlDate);
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("upload_id"), updateId));
        ConnectionController.executeUpdate(sid, query.toString());
    }
}

