/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.db.util.CustomTables;
import org.ut.biolab.medsavant.server.serverapi.PatientManager;
import org.ut.biolab.medsavant.server.serverapi.VariantManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.SimplePatient;
import org.ut.biolab.medsavant.shared.serverapi.CohortManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;

public class CohortManager
extends MedSavantServerUnicastRemoteObject
implements CohortManagerAdapter,
BasicPatientColumns {
    private static CohortManager instance;

    private CohortManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized CohortManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new CohortManager();
        }
        return instance;
    }

    @Override
    public List<SimplePatient> getIndividualsInCohort(String sid, int projectId, int cohortId) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = PatientManager.getInstance().getPatientTableName(sid, projectId);
        MedSavantDatabase.CohortMembershipTableSchema cohortTable = MedSavantDatabase.CohortmembershipTableSchema;
        TableSchema patientTable = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        SelectQuery query = new SelectQuery();
        query.addFromTable(cohortTable.getTable());
        query.addFromTable(patientTable.getTable());
        query.addColumns(cohortTable.getDBColumn("patient_id"), patientTable.getDBColumn(HOSPITAL_ID), patientTable.getDBColumn(DNA_IDS));
        query.addCondition(BinaryConditionMS.equalTo(cohortTable.getDBColumn("cohort_id"), cohortId));
        query.addCondition(BinaryConditionMS.equalTo(cohortTable.getDBColumn("patient_id"), patientTable.getDBColumn(PATIENT_ID)));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<SimplePatient> result = new ArrayList<SimplePatient>();
        while (rs.next()) {
            result.add(new SimplePatient(rs.getInt(1), rs.getString(2), PatientManager.getInstance().parseDNAIDs(rs.getString(3))));
        }
        return result;
    }

    @Override
    public List<String> getDNAIDsForCohort(String sessID, int cohortId) throws SQLException, RemoteException, SessionExpiredException {
        List<String> list = this.getIndividualFieldFromCohort(sessID, cohortId, DNA_IDS.getColumnName());
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            String[] dnaIDs;
            if (s == null) continue;
            for (String id : dnaIDs = s.split(",")) {
                if (result.contains(id)) continue;
                result.add(id);
            }
        }
        return result;
    }

    @Override
    public List<String> getDNAIDsForCohorts(String sessID, int projID, Collection<String> cohNames) throws SQLException, RemoteException, SessionExpiredException {
        String selQuery = String.format("SELECT %s FROM %s WHERE %s = ANY (SELECT %s FROM %s JOIN %s USING (%s) WHERE %s IN ('%s'))", DNA_IDS.getColumnName(), PatientManager.getInstance().getPatientTableName(sessID, projID), PATIENT_ID.getColumnName(), "patient_id", "cohort_membership", "cohort", "cohort_id", "name", StringUtils.join(cohNames, (String)"','"));
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = ConnectionController.executeQuery(sessID, selQuery);
        while (rs.next()) {
            String[] dnaIDs;
            String s = rs.getString(1);
            if (s == null) continue;
            for (String id : dnaIDs = s.split(",")) {
                if (result.contains(id)) continue;
                result.add(id);
            }
        }
        return result;
    }

    @Override
    public List<String> getIndividualFieldFromCohort(String sessID, int cohortId, String columnName) throws SQLException, RemoteException, SessionExpiredException {
        MedSavantDatabase.PatientTablemapTableSchema patientMapTable = MedSavantDatabase.PatienttablemapTableSchema;
        MedSavantDatabase.CohortTableSchema cohortTable = MedSavantDatabase.CohortTableSchema;
        MedSavantDatabase.CohortMembershipTableSchema cohortMembershipTable = MedSavantDatabase.CohortmembershipTableSchema;
        SelectQuery query1 = new SelectQuery();
        query1.addFromTable(patientMapTable.getTable());
        query1.addFromTable(cohortTable.getTable());
        query1.addColumns(patientMapTable.getDBColumn("patient_tablename"));
        query1.addCondition(BinaryConditionMS.equalTo(cohortTable.getDBColumn("cohort_id"), cohortId));
        query1.addCondition(BinaryConditionMS.equalTo(cohortTable.getDBColumn("project_id"), patientMapTable.getDBColumn("project_id")));
        ResultSet rs = ConnectionController.executeQuery(sessID, query1.toString());
        rs.next();
        String patientTablename = rs.getString(1);
        TableSchema patientTable = CustomTables.getInstance().getCustomTableSchema(sessID, patientTablename);
        SelectQuery query2 = new SelectQuery();
        query2.addFromTable(cohortMembershipTable.getTable());
        query2.addFromTable(patientTable.getTable());
        query2.addColumns(patientTable.getDBColumn(columnName));
        query2.addCondition(BinaryConditionMS.equalTo(cohortMembershipTable.getDBColumn("cohort_id"), cohortId));
        query2.addCondition(BinaryConditionMS.equalTo(cohortMembershipTable.getDBColumn("patient_id"), patientTable.getDBColumn(PATIENT_ID)));
        rs = ConnectionController.executeQuery(sessID, query2.toString());
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        return result;
    }

    @Override
    public void addPatientsToCohort(String sessID, int[] patientIDs, int cohortID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.CohortMembershipTableSchema table = MedSavantDatabase.CohortmembershipTableSchema;
        PooledConnection c = ConnectionController.connectPooled(sessID);
        c.setAutoCommit(false);
        for (int id : patientIDs) {
            try {
                InsertQuery query = new InsertQuery(table.getTable());
                query.addColumn(table.getDBColumn("cohort_id"), cohortID);
                query.addColumn(table.getDBColumn("patient_id"), id);
                c.createStatement().executeUpdate(query.toString());
            }
            catch (MySQLIntegrityConstraintViolationException e) {
                // empty catch block
            }
        }
        c.commit();
        c.setAutoCommit(true);
        c.close();
    }

    @Override
    public void removePatientsFromCohort(String sessID, int[] patIDs, int cohID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.CohortMembershipTableSchema table = MedSavantDatabase.CohortmembershipTableSchema;
        PooledConnection c = ConnectionController.connectPooled(sessID);
        c.setAutoCommit(false);
        for (int id : patIDs) {
            DeleteQuery query = new DeleteQuery(table.getTable());
            query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("cohort_id"), cohID));
            query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("patient_id"), id));
            c.createStatement().executeUpdate(query.toString());
        }
        c.commit();
        c.setAutoCommit(true);
        c.close();
    }

    @Override
    public Cohort[] getCohorts(String sessID, int projID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.CohortTableSchema table = MedSavantDatabase.CohortTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID));
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<Cohort> result = new ArrayList<Cohort>();
        while (rs.next()) {
            result.add(new Cohort(rs.getInt("cohort_id"), rs.getString("name")));
        }
        return result.toArray(new Cohort[0]);
    }

    @Override
    public void addCohort(String sid, int projectId, String name) throws SQLException, SessionExpiredException {
        MedSavantDatabase.CohortTableSchema table = MedSavantDatabase.CohortTableSchema;
        InsertQuery query = new InsertQuery(table.getTable());
        query.addColumn(table.getDBColumn("project_id"), projectId);
        query.addColumn(table.getDBColumn("name"), name);
        ConnectionController.executeUpdate(sid, query.toString());
    }

    @Override
    public void removeCohort(String sid, int cohortId) throws SQLException, SessionExpiredException {
        MedSavantDatabase.CohortMembershipTableSchema cohortMembershipTable = MedSavantDatabase.CohortmembershipTableSchema;
        MedSavantDatabase.CohortTableSchema cohortTable = MedSavantDatabase.CohortTableSchema;
        PooledConnection c = ConnectionController.connectPooled(sid);
        DeleteQuery query1 = new DeleteQuery(cohortMembershipTable.getTable());
        query1.addCondition(BinaryConditionMS.equalTo(cohortMembershipTable.getDBColumn("cohort_id"), cohortId));
        c.createStatement().execute(query1.toString());
        DeleteQuery query2 = new DeleteQuery(cohortTable.getTable());
        query2.addCondition(BinaryConditionMS.equalTo(cohortTable.getDBColumn("cohort_id"), cohortId));
        c.createStatement().execute(query2.toString());
        c.close();
    }

    @Override
    public void removeCohorts(String sid, Cohort[] cohorts) throws SQLException, SessionExpiredException {
        for (Cohort c : cohorts) {
            this.removeCohort(sid, c.getId());
        }
    }

    @Override
    public int[] getCohortIDs(String sid, int projectId) throws SQLException, SessionExpiredException {
        MedSavantDatabase.CohortTableSchema table = MedSavantDatabase.CohortTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("cohort_id"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectId));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        return ArrayUtils.toPrimitive((Integer[])result.toArray(new Integer[0]));
    }

    @Override
    public void removePatientReferences(String sessID, int projID, int patID) throws SQLException, SessionExpiredException {
        int[] cohIDs = this.getCohortIDs(sessID, projID);
        MedSavantDatabase.CohortMembershipTableSchema table = MedSavantDatabase.CohortmembershipTableSchema;
        for (int id : cohIDs) {
            DeleteQuery query = new DeleteQuery(table.getTable());
            query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("cohort_id"), id));
            query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("patient_id"), patID));
            ConnectionController.executeUpdate(sessID, query.toString());
        }
    }

    @Override
    public int getNumVariantsInCohort(String sessID, int projID, int refID, int cohortID, Condition[][] conditions) throws SQLException, InterruptedException, RemoteException, SessionExpiredException {
        List<String> dnaIDs = this.getDNAIDsForCohort(sessID, cohortID);
        return VariantManager.getInstance().getVariantCountForDNAIDs(sessID, projID, refID, conditions, dnaIDs);
    }
}

