/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.db.util.CustomTables;
import org.ut.biolab.medsavant.server.db.util.DBSettings;
import org.ut.biolab.medsavant.server.db.util.DBUtils;
import org.ut.biolab.medsavant.server.serverapi.CohortManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.PatientManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;

public class PatientManager
extends MedSavantServerUnicastRemoteObject
implements PatientManagerAdapter,
BasicPatientColumns {
    Log LOG = LogFactory.getLog(PatientManager.class);
    private static PatientManager instance;

    @Override
    public void test(CustomField[] c) throws RemoteException {
        System.out.println("Got custom field " + c[0]);
        System.out.println("Alias: " + c[0].getAlias());
        System.out.println("Col Name: " + c[0].getColumnName());
        System.out.println("Col Length: " + c[0].getColumnLength());
    }

    private PatientManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized PatientManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new PatientManager();
        }
        return instance;
    }

    @Override
    public List<Object[]> getBasicPatientInfo(String sid, int projectId, int limit) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sid, projectId);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn(PATIENT_ID), table.getDBColumn(FAMILY_ID), table.getDBColumn(HOSPITAL_ID), table.getDBColumn(IDBIOMOM), table.getDBColumn(IDBIODAD), table.getDBColumn(GENDER), table.getDBColumn(AFFECTED), table.getDBColumn(DNA_IDS), table.getDBColumn(PHENOTYPES));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        while (rs.next()) {
            result.add(new Object[]{rs.getInt(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getInt(6), rs.getInt(7), rs.getString(8), rs.getString(9)});
        }
        return result;
    }

    @Override
    public List<Object[]> getPatients(String sid, int projectId) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sid, projectId);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] o = new Object[rs.getMetaData().getColumnCount()];
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                try {
                    o[i] = rs.getObject(i + 1);
                    continue;
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            result.add(o);
        }
        return result;
    }

    @Override
    public Object[] getPatientRecord(String sid, int projectId, int patientId) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sid, projectId);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn(PATIENT_ID), patientId));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        rs.next();
        Object[] v = new Object[rs.getMetaData().getColumnCount()];
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            try {
                v[i - 1] = rs.getObject(i);
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return v;
    }

    @Override
    public List<String> getPatientFieldAliases(String sid, int projectId) throws SQLException, SessionExpiredException {
        MedSavantDatabase.PatientFormatTableSchema table = MedSavantDatabase.PatientformatTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("alias"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectId));
        query.addOrdering(table.getDBColumn("position"), OrderObject.Dir.ASCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<String> result = new ArrayList<String>();
        for (CustomField af : REQUIRED_PATIENT_FIELDS) {
            result.add(af.getAlias());
        }
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        return result;
    }

    @Override
    public CustomField[] getPatientFields(String sessID, int projID) throws SQLException, SessionExpiredException {
        CustomField[] defaultFields = REQUIRED_PATIENT_FIELDS;
        CustomField[] customFields = this.getCustomPatientFields(sessID, projID);
        CustomField[] result = new CustomField[defaultFields.length + customFields.length];
        System.arraycopy(defaultFields, 0, result, 0, defaultFields.length);
        System.arraycopy(customFields, 0, result, defaultFields.length, customFields.length);
        return result;
    }

    @Override
    public CustomField[] getCustomPatientFields(String sessID, int projID) throws SQLException, SessionExpiredException {
        MedSavantDatabase.PatientFormatTableSchema table = MedSavantDatabase.PatientformatTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("column_name"), table.getDBColumn("column_type"), table.getDBColumn("filterable"), table.getDBColumn("alias"), table.getDBColumn("description"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projID));
        query.addOrdering(table.getDBColumn("position"), OrderObject.Dir.ASCENDING);
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<CustomField> result = new ArrayList<CustomField>();
        while (rs.next()) {
            result.add(new CustomField(rs.getString("column_name"), rs.getString("column_type"), rs.getBoolean("filterable"), rs.getString("alias"), rs.getString("description")));
        }
        return result.toArray(new CustomField[0]);
    }

    @Override
    public String getPatientTableName(String sid, int projectId) throws SQLException, SessionExpiredException {
        MedSavantDatabase.PatientTablemapTableSchema table = MedSavantDatabase.PatienttablemapTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("patient_tablename"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("project_id"), projectId));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        rs.next();
        return rs.getString(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPatientTable(String sessID, int projID, CustomField[] fields) throws SQLException, SessionExpiredException {
        String tableName = DBSettings.createPatientTableName(projID);
        TableSchema patientSchema = new TableSchema(MedSavantDatabase.schema, tableName, BasicPatientColumns.class);
        for (CustomField field : fields) {
            patientSchema.addColumn(field.getColumnName(), field.getColumnType(), field.getColumnLength(), field.getColumnScale());
        }
        patientSchema.getDBColumn(BasicPatientColumns.HOSPITAL_ID).unique();
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.executeUpdate(patientSchema.getCreateQuery() + " ENGINE=MyISAM;");
            MedSavantDatabase.PatientTablemapTableSchema patientMapTable = MedSavantDatabase.PatienttablemapTableSchema;
            InsertQuery query1 = new InsertQuery(patientMapTable.getTable());
            query1.addColumn(patientMapTable.getDBColumn("project_id"), projID);
            query1.addColumn(patientMapTable.getDBColumn("patient_tablename"), tableName);
            conn.executeUpdate(query1.toString());
            MedSavantDatabase.PatientFormatTableSchema patientFormatTable = MedSavantDatabase.PatientformatTableSchema;
            conn.setAutoCommit(false);
            for (int i = 0; i < fields.length; ++i) {
                CustomField a = fields[i];
                InsertQuery query2 = new InsertQuery(patientFormatTable.getTable());
                query2.addColumn(patientFormatTable.getDBColumn("project_id"), projID);
                query2.addColumn(patientFormatTable.getDBColumn("position"), i);
                query2.addColumn(patientFormatTable.getDBColumn("column_name"), a.getColumnName());
                query2.addColumn(patientFormatTable.getDBColumn("column_type"), a.getTypeString());
                query2.addColumn(patientFormatTable.getDBColumn("filterable"), a.isFilterable() ? "1" : "0");
                query2.addColumn(patientFormatTable.getDBColumn("alias"), a.getAlias());
                query2.addColumn(patientFormatTable.getDBColumn("description"), a.getDescription());
                conn.createStatement().executeUpdate(query2.toString());
            }
            conn.commit();
        }
        finally {
            conn.setAutoCommit(true);
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePatient(String sid, int projectId, int[] patientIds) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sid, projectId);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        PooledConnection conn = ConnectionController.connectPooled(sid);
        try {
            conn.setAutoCommit(false);
            for (int id : patientIds) {
                CohortManager.getInstance().removePatientReferences(sid, projectId, id);
                DeleteQuery query = new DeleteQuery(table.getTable());
                query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn(PATIENT_ID), id));
                conn.createStatement().executeUpdate(query.toString());
            }
            conn.commit();
        }
        finally {
            conn.setAutoCommit(true);
            conn.close();
        }
    }

    @Override
    public void addPatient(String sid, int projectId, List<CustomField> cols, List<String> values) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sid, projectId);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        InsertQuery query = new InsertQuery(table.getTable());
        for (int i = 0; i < Math.min(cols.size(), values.size()); ++i) {
            query.addColumn(new DbColumn(table.getTable(), cols.get(i).getColumnName(), cols.get(i).getTypeString(), 100, 0), values.get(i));
        }
        ConnectionController.executeUpdate(sid, query.toString());
    }

    @Override
    public void updatePatient(String sid, int projectId, int patientID, List<CustomField> cols, List<String> values) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sid, projectId);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        UpdateQuery query = new UpdateQuery(table.getTable());
        query.addCondition(BinaryCondition.equalTo(table.getDBColumn(PATIENT_ID), patientID));
        for (int i = 0; i < Math.min(cols.size(), values.size()); ++i) {
            query.addSetClause(table.getDBColumn(cols.get(i).getColumnName()), values.get(i));
        }
        ConnectionController.executeUpdate(sid, query.toString());
    }

    @Override
    public Map<Object, List<String>> getDNAIDsForValues(String sessID, int projID, String columnName) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
        DbColumn currentDNAID = table.getDBColumn(DNA_IDS);
        DbColumn testColumn = table.getDBColumn(columnName);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.setIsDistinct(true);
        q.addColumns(currentDNAID, testColumn);
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        HashMap<Object, List<String>> map = new HashMap<Object, List<String>>();
        while (rs.next()) {
            String[] dnaIds;
            String dnaIdsString;
            Object o = rs.getObject(columnName);
            if (o == null) {
                o = "";
            }
            if (map.get(o) == null) {
                map.put(o, new ArrayList());
            }
            if ((dnaIdsString = rs.getString(DNA_IDS.getColumnName())) == null) continue;
            for (String id : dnaIds = dnaIdsString.split(",")) {
                if (((List)map.get(o)).contains(id)) continue;
                ((List)map.get(o)).add(id);
            }
        }
        return map;
    }

    @Override
    public List<String> getDNAIDsWithValuesInRange(String sessID, int projID, String columnName, Range r) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
        DbColumn currentDNAID = table.getDBColumn(DNA_IDS);
        DbColumn testColumn = table.getDBColumn(columnName);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.setIsDistinct(true);
        q.addColumns(currentDNAID);
        q.addCondition(BinaryCondition.greaterThan(testColumn, r.getMin(), true));
        q.addCondition(BinaryCondition.lessThan(testColumn, r.getMax(), true));
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            String s = rs.getString(1);
            String[] dnaIDs = s == null ? new String[]{"null"} : s.split(",");
            for (String id : dnaIDs) {
                if (result.contains(id)) continue;
                result.add(id);
            }
        }
        return result;
    }

    @Override
    public List<String> getDNAIDsForStringList(String sessID, TableSchema table, List<String> list, String columnName, boolean allowInexactMatch) throws SQLException, SessionExpiredException {
        DbColumn currentDNAID = table.getDBColumn(DNA_IDS);
        DbColumn testColumn = table.getDBColumn(columnName);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.setIsDistinct(true);
        q.addColumns(currentDNAID);
        Condition[] conditions = new Condition[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String val = list.get(i);
            conditions[i] = val.length() == 0 ? ComboCondition.or(BinaryCondition.equalTo(testColumn, ""), UnaryCondition.isNull(testColumn)) : (allowInexactMatch ? BinaryConditionMS.like(testColumn, "%" + val + "%") : BinaryConditionMS.equalTo(testColumn, val));
        }
        q.addCondition(ComboCondition.or(conditions));
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            String[] dnaIDs;
            String current = rs.getString(1);
            if (current == null) continue;
            for (String id : dnaIDs = current.split(",")) {
                if (result.contains(id)) continue;
                result.add(id);
            }
        }
        return result;
    }

    @Override
    public void updateFields(String sessID, int projID, CustomField[] newFields) throws SQLException, RemoteException, SessionExpiredException {
        List<CustomField> currentFields = Arrays.asList(this.getCustomPatientFields(sessID, projID));
        List<CustomField> fields = Arrays.asList(newFields);
        String tablename = this.getPatientTableName(sessID, projID);
        MedSavantDatabase.PatientFormatTableSchema patientFormatTable = MedSavantDatabase.PatientformatTableSchema;
        PooledConnection c = ConnectionController.connectPooled(sessID);
        c.setAutoCommit(false);
        for (CustomField f : currentFields) {
            if (fields.contains(f)) continue;
            DeleteQuery q = new DeleteQuery(patientFormatTable.getTable());
            q.addCondition(BinaryConditionMS.equalTo(patientFormatTable.getDBColumn("project_id"), projID));
            q.addCondition(BinaryConditionMS.equalTo(patientFormatTable.getDBColumn("column_name"), f.getColumnName()));
            c.createStatement().execute(q.toString());
            String q1 = "ALTER TABLE `" + tablename + "` DROP COLUMN `" + f.getColumnName() + "`";
            c.createStatement().execute(q1);
        }
        int tempPos = 5002;
        for (CustomField f : fields) {
            Query q;
            if (currentFields.contains(f)) {
                q = new UpdateQuery(patientFormatTable.getTable());
                ((UpdateQuery)q).addSetClause(patientFormatTable.getDBColumn("alias"), f.getAlias());
                ((UpdateQuery)q).addSetClause(patientFormatTable.getDBColumn("description"), f.getDescription());
                ((UpdateQuery)q).addSetClause(patientFormatTable.getDBColumn("filterable"), f.isFilterable() ? "1" : "0");
                ((UpdateQuery)q).addCondition(BinaryConditionMS.equalTo(patientFormatTable.getDBColumn("project_id"), projID));
                ((UpdateQuery)q).addCondition(BinaryConditionMS.equalTo(patientFormatTable.getDBColumn("column_name"), f.getColumnName()));
                c.createStatement().executeUpdate(q.toString());
                continue;
            }
            q = new InsertQuery(patientFormatTable.getTable());
            ((InsertQuery)q).addColumn(patientFormatTable.getDBColumn("project_id"), projID);
            ((InsertQuery)q).addColumn(patientFormatTable.getDBColumn("position"), tempPos++);
            ((InsertQuery)q).addColumn(patientFormatTable.getDBColumn("column_name"), f.getColumnName());
            ((InsertQuery)q).addColumn(patientFormatTable.getDBColumn("column_type"), f.getTypeString());
            ((InsertQuery)q).addColumn(patientFormatTable.getDBColumn("filterable"), f.isFilterable() ? "1" : "0");
            ((InsertQuery)q).addColumn(patientFormatTable.getDBColumn("alias"), f.getAlias());
            ((InsertQuery)q).addColumn(patientFormatTable.getDBColumn("description"), f.getDescription());
            c.createStatement().executeUpdate(q.toString());
            String q1 = "ALTER TABLE `" + tablename + "` ADD " + f.generateSchema().replaceAll(",", "");
            c.createStatement().execute(q1);
        }
        c.commit();
        c.setAutoCommit(true);
        TableSchema patientTable = CustomTables.getInstance().getCustomTableSchema(sessID, tablename, true);
        List<DbColumn> columns = patientTable.getColumns();
        c.setAutoCommit(false);
        int i = 0;
        for (DbColumn col : columns) {
            boolean isDefault = false;
            for (CustomField a : BasicPatientColumns.REQUIRED_PATIENT_FIELDS) {
                if (!col.getColumnNameSQL().equals(a.getColumnName())) continue;
                isDefault = true;
            }
            if (isDefault) continue;
            UpdateQuery q = new UpdateQuery(patientFormatTable.getTable());
            q.addSetClause(patientFormatTable.getDBColumn("position"), i++);
            q.addCondition(BinaryConditionMS.equalTo(patientFormatTable.getDBColumn("project_id"), projID));
            q.addCondition(BinaryConditionMS.equalTo(patientFormatTable.getDBColumn("column_name"), col.getColumnNameSQL()));
            c.createStatement().executeUpdate(q.toString());
        }
        c.commit();
        c.setAutoCommit(true);
        c.close();
    }

    @Override
    public List<Object> getValuesFromField(String sid, int projectId, String columnNameA, String columnNameB, List<Object> values) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sid, projectId);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sid, tablename);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn(columnNameB));
        Condition[] conditions = new Condition[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            conditions[i] = BinaryConditionMS.equalTo(table.getDBColumn(columnNameA), values.get(i));
        }
        query.addCondition(ComboCondition.or(conditions));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        ArrayList<Object> result = new ArrayList<Object>();
        while (rs.next()) {
            result.add(rs.getObject(1));
        }
        return result;
    }

    @Override
    public List<String> getDNAIDsFromField(String sessID, int projID, String columnNameA, List<Object> values) throws SQLException, RemoteException, SessionExpiredException {
        List<Object> l1 = this.getValuesFromField(sessID, projID, columnNameA, DNA_IDS.getColumnName(), values);
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : l1) {
            String[] dnaIds;
            for (String id : dnaIds = ((String)o).split(",")) {
                if (result.contains(id)) continue;
                result.add(id);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getValuesFromDNAIDs(String sessID, int projID, String columnNameB, List<String> ids) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn(DNA_IDS));
        query.addColumns(table.getDBColumn(columnNameB));
        Condition[] conditions = new Condition[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            conditions[i] = BinaryCondition.like(table.getDBColumn(DNA_IDS), "%" + ids.get(i) + "%");
        }
        query.addCondition(ComboCondition.or(conditions));
        String s = query.toString();
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        HashMap<String, String> result = new HashMap<String, String>();
        while (rs.next()) {
            result.put(rs.getString(1), rs.getString(2));
        }
        return result;
    }

    @Override
    public List<Object[]> getFamily(String sessID, int projID, String famID) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn(HOSPITAL_ID));
        query.addColumns(table.getDBColumn(IDBIOMOM));
        query.addColumns(table.getDBColumn(IDBIODAD));
        query.addColumns(table.getDBColumn(PATIENT_ID));
        query.addColumns(table.getDBColumn(GENDER));
        query.addColumns(table.getDBColumn(AFFECTED));
        query.addColumns(table.getDBColumn(DNA_IDS));
        query.addCondition(BinaryCondition.equalTo(table.getDBColumn(FAMILY_ID), famID));
        String s = query.toString();
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] r = new Object[]{rs.getString(1), rs.getString(2), rs.getString(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getString(7)};
            result.add(r);
        }
        return result;
    }

    @Override
    public List<Object[]> getFamilyOfPatient(String sessID, int projID, int patID) throws SQLException, RemoteException, SessionExpiredException {
        String famID = this.getFamilyIDOfPatient(sessID, projID, patID);
        if (famID == null) {
            return new ArrayList<Object[]>();
        }
        return this.getFamily(sessID, projID, famID);
    }

    @Override
    public String getFamilyIDOfPatient(String sessID, int projID, int patID) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
        SelectQuery q1 = new SelectQuery();
        q1.addFromTable(table.getTable());
        q1.addColumns(table.getDBColumn(FAMILY_ID));
        q1.addCondition(BinaryCondition.equalTo(table.getDBColumn(PATIENT_ID), patID));
        ResultSet rs1 = ConnectionController.executeQuery(sessID, q1.toString());
        if (!rs1.next()) {
            return null;
        }
        return rs1.getString(1);
    }

    @Override
    public List<String> getFamilyIDs(String sessID, int projID) throws SQLException, RemoteException, SessionExpiredException {
        String tableName = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tableName);
        SelectQuery q1 = new SelectQuery();
        q1.addFromTable(table.getTable());
        q1.addColumns(table.getDBColumn(FAMILY_ID));
        q1.setIsDistinct(true);
        ResultSet rs1 = ConnectionController.executeQuery(sessID, q1.toString());
        ArrayList<String> ids = new ArrayList<String>();
        while (rs1.next()) {
            ids.add(rs1.getString(1));
        }
        ids.remove(null);
        return ids;
    }

    @Override
    public Map<String, String> getDNAIDsForFamily(String sessID, int projID, String famID) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
        SelectQuery q1 = new SelectQuery();
        q1.addFromTable(table.getTable());
        q1.addColumns(table.getDBColumn(HOSPITAL_ID));
        q1.addColumns(table.getDBColumn(DNA_IDS));
        q1.addCondition(BinaryCondition.equalTo(table.getDBColumn(FAMILY_ID), famID));
        ResultSet rs1 = ConnectionController.executeQuery(sessID, q1.toString());
        HashMap<String, String> patientIDToDNAIDMap = new HashMap<String, String>();
        while (rs1.next()) {
            String patientID = rs1.getString(1);
            String DNAIDString = rs1.getString(2);
            if (DNAIDString == null || DNAIDString.isEmpty()) continue;
            patientIDToDNAIDMap.put(patientID, DNAIDString);
        }
        return patientIDToDNAIDMap;
    }

    @Override
    public void clearPatients(String sessID, int projID) throws SQLException, RemoteException, SessionExpiredException {
        String tableName = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tableName);
        DeleteQuery query = new DeleteQuery(table.getTable());
        ConnectionController.executeUpdate(sessID, query.toString());
    }

    @Override
    public List<String> parseDNAIDs(String s) {
        String[] dnaIDs;
        ArrayList<String> result = new ArrayList<String>();
        if (s == null) {
            return result;
        }
        for (String id : dnaIDs = s.split(",")) {
            if (result.contains(id)) continue;
            result.add(id);
        }
        return result;
    }

    @Override
    public List<String> getDNAIDsForHPOID(String sessID, int projID, String id) throws SQLException, RemoteException, SessionExpiredException {
        String query = "SELECT dna_ids FROM " + this.getPatientTableName(sessID, projID) + " WHERE " + "hpo" + "='" + id + "';";
        ResultSet rs = ConnectionController.executeQuery(sessID, query);
        ArrayList<String> results = new ArrayList<String>();
        while (rs.next()) {
            results.add(rs.getString(1));
        }
        return results;
    }

    @Override
    public boolean hasOptionalField(String sessID, int pid, String fieldName) throws SQLException, SessionExpiredException {
        String tableName = this.getPatientTableName(sessID, pid);
        return DBUtils.fieldExists(sessID, tableName, "hpo");
    }

    @Override
    public String getReadAlignmentPathForDNAID(String sessID, int projID, String dnaID) throws SQLException, RemoteException, SessionExpiredException {
        String tablename = this.getPatientTableName(sessID, projID);
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessID, tablename);
        SelectQuery q = new SelectQuery();
        q.addFromTable(table.getTable());
        q.addColumns(table.getDBColumn(BAM_URL));
        q.addCondition(BinaryCondition.like(table.getDBColumn(DNA_IDS), dnaID));
        ResultSet rs = ConnectionController.executeQuery(sessID, q.toString());
        String bamURL = null;
        while (rs.next()) {
            bamURL = rs.getString(1);
            if (!"".equals(bamURL)) continue;
            bamURL = null;
        }
        return bamURL;
    }

    @Override
    public List<Cohort> getCohortsForPatient(String sessID, int projectID, int patientID) throws SQLException, RemoteException, SessionExpiredException {
        MedSavantDatabase.CohortTableSchema cohortTable = MedSavantDatabase.CohortTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(cohortTable.getTable());
        MedSavantDatabase.CohortMembershipTableSchema cohortMembershipTable = MedSavantDatabase.CohortmembershipTableSchema;
        query.addAllColumns();
        BinaryCondition joinCondition = BinaryCondition.equalTo(cohortMembershipTable.getDBColumn("cohort_id"), cohortTable.getDBColumn("cohort_id"));
        query.addCustomJoin(SelectQuery.JoinType.INNER, cohortTable.getTable(), cohortMembershipTable.getTable(), joinCondition);
        query.addCondition(BinaryConditionMS.equalTo(cohortTable.getDBColumn("project_id"), projectID));
        query.addCondition(BinaryConditionMS.equalTo(cohortMembershipTable.getDBColumn("patient_id"), patientID));
        System.out.println(query);
        ResultSet rs = ConnectionController.executeQuery(sessID, query.toString());
        ArrayList<Cohort> result = new ArrayList<Cohort>();
        while (rs.next()) {
            result.add(new Cohort(rs.getInt("cohort_id"), rs.getString("name")));
        }
        return result;
    }
}

