/*
 * Decompiled with CFR 0.152.
 */
package jannovar.gff;

import jannovar.common.ChromosomeMap;
import jannovar.common.FeatureType;
import jannovar.exception.FeatureFormatException;
import jannovar.exception.InvalidAttributException;
import jannovar.gff.Feature;
import jannovar.gff.RNA2GeneIDMapper;
import jannovar.reference.TranscriptModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;

public class TranscriptModelBuilder
implements ChromosomeMap {
    private static final Logger logger = Logger.getLogger(TranscriptModelBuilder.class.getSimpleName());
    private int gff_version = 2;
    private int subregion_Index = 0;
    private String curGeneName;
    private String curGeneID;
    private String curRnaID;
    private String curID;
    private HashMap<String, Gene> genes = new HashMap();
    private HashMap<String, String> rna2gene = new HashMap();
    private Gene curGene;
    private Transcript curRna;
    private GFFstruct curGFF;
    private String[] fields;
    private String[] subfields;

    public int getNtranscripts() {
        return this.rna2gene.size();
    }

    public int getNgenes() {
        return this.genes.size();
    }

    public ArrayList<TranscriptModel> buildTranscriptModels() throws InvalidAttributException {
        logger.info("building transcript models");
        ArrayList<TranscriptModel> models = new ArrayList<TranscriptModel>();
        for (Gene gene : this.genes.values()) {
            if (gene.id == null) continue;
            for (Transcript rna : gene.rnas.values()) {
                TranscriptModel model = TranscriptModel.createTranscriptModel();
                model.setAccessionNumber(rna.name);
                model.setChromosome(rna.chromosom);
                model.setGeneSymbol(gene.name);
                model.setStrand(rna.strand ? (char)'+' : '-');
                model.setTranscriptionStart(rna.getTxStart());
                model.setTranscriptionEnd(rna.getTxEnd());
                model.setCdsStart(rna.getCdsStart());
                model.setCdsEnd(rna.getCdsEnd());
                model.setExonCount((byte)rna.exons.size());
                model.setExonStartsAndEnds(rna.getExonStarts(), rna.getExonEnds());
                if (this.gff_version == 3) {
                    model.setGeneID(Integer.parseInt(gene.id.substring(4)));
                } else {
                    int curid = RNA2GeneIDMapper.getGeneID(gene.id);
                    if (curid > 0) {
                        model.setGeneID(curid);
                    } else {
                        throw new InvalidAttributException("Found no valid geneID mapping for accession: " + gene.id);
                    }
                }
                models.add(model);
            }
        }
        return models;
    }

    public void addFeature(Feature feature) throws InvalidAttributException, FeatureFormatException {
        if (identifier2chromosom.get(feature.sequence_id) == null) {
            return;
        }
        switch (feature.getType()) {
            case GENE: {
                this.processGene(feature);
                break;
            }
            case NCRNA: 
            case MRNA: 
            case TRANSCRIPT: {
                this.processRNA(feature);
                break;
            }
            case CDS: 
            case EXON: {
                this.processSubregion(feature);
                break;
            }
        }
    }

    private void processRNA(Feature feature) throws InvalidAttributException {
        this.curGeneID = feature.getAttribute("Parent");
        this.curRnaID = feature.getAttribute("ID");
        this.rna2gene.put(this.curRnaID, this.curGeneID);
        this.curGene = this.genes.get(this.curGeneID);
        if (this.curGene.rnas == null) {
            this.curGene.rnas = new HashMap();
        }
        this.curRna = new Transcript();
        this.curRna.start = feature.getStart();
        this.curRna.end = feature.getEnd();
        this.curRna.id = this.curRnaID;
        this.curRna.name = feature.getAttribute("Name");
        this.curRna.chromosom = (Byte)identifier2chromosom.get(feature.getSequence_id());
        if (this.curGene.chromosom != this.curRna.chromosom) {
            return;
        }
        this.curRna.strand = feature.getStrand();
        if (this.curGene.strand != feature.getStrand()) {
            return;
        }
        this.curGene.rnas.put(this.curRnaID, this.curRna);
    }

    private void processSubregion(Feature feature) {
        if (this.gff_version == 3) {
            this.curID = feature.getAttribute("ID");
            this.curRnaID = feature.getAttribute("Parent");
            this.curGeneID = this.rna2gene.get(this.curRnaID);
        } else {
            this.curID = "sub" + this.subregion_Index++;
            this.curRnaID = feature.getAttribute("transcript_id");
            this.curGeneID = feature.getAttribute("gene_id");
            this.curGeneName = feature.getAttribute("gene_name");
            if (this.curGeneName == null) {
                this.curGeneName = this.curGeneID;
            }
        }
        if (this.curRnaID.contains(",")) {
            logger.severe("More than one Parent. Will only link to the first.");
            this.curRnaID = this.curRnaID.substring(0, this.curRnaID.indexOf(","));
        }
        if (!this.genes.containsKey(this.curGeneID)) {
            this.genes.put(this.curGeneID, new Gene(this.curGeneID, this.curGeneName, (Byte)identifier2chromosom.get(feature.sequence_id), feature.strand));
        }
        this.curGene = this.genes.get(this.curGeneID);
        if (!this.rna2gene.containsKey(this.curRnaID)) {
            this.rna2gene.put(this.curRnaID, this.curGeneID);
            this.curGene.rnas.put(this.curRnaID, new Transcript(this.curRnaID, this.curRnaID, (Byte)identifier2chromosom.get(feature.sequence_id), feature.strand));
        }
        this.curRna = this.curGene.rnas.get(this.curRnaID);
        if (this.curRna == null || this.curGene.id == null) {
            return;
        }
        this.curGFF = new GFFstruct();
        this.curGFF.chromosom = (Byte)identifier2chromosom.get(feature.sequence_id);
        this.curGFF.start = feature.getStart();
        this.curGFF.end = feature.getEnd();
        this.curGFF.strand = feature.getStrand();
        this.curGFF.id = this.curID;
        if (feature.getType() == FeatureType.CDS) {
            this.curGFF.frame = feature.phase;
            if (!this.curRna.cdss.contains(this.curGFF)) {
                this.curRna.cdss.add(this.curGFF);
            }
        }
        if (feature.getType() == FeatureType.EXON) {
            int index = this.curGene.exons.indexOf(this.curGFF);
            if (index >= 0) {
                this.curGFF = this.curGene.exons.get(index);
                if (!this.curRna.exons.contains(this.curGFF)) {
                    this.curRna.exons.add(this.curGFF);
                }
            } else {
                this.curGene.exons.add(this.curGFF);
                this.curRna.exons.add(this.curGFF);
            }
        }
        this.curGFF.parents.add(this.curRna);
    }

    private void processGene(Feature feature) {
        this.curGeneID = feature.getAttribute("ID");
        if (!this.genes.containsKey(this.curGeneID)) {
            this.genes.put(this.curGeneID, new Gene());
        }
        this.curGene = this.genes.get(this.curGeneID);
        this.curGene.strand = feature.getStrand();
        this.curGene.start = feature.getStart();
        this.curGene.end = feature.getEnd();
        this.curGene.chromosom = (Byte)identifier2chromosom.get(feature.sequence_id);
        if (feature.getAttribute("Name") != null) {
            this.curGene.name = feature.getAttribute("Name");
        }
        this.curGene.id = this.curGeneID;
    }

    private void extractXreferences(String xrefs) {
        for (String xref : this.fields = xrefs.split(",")) {
            this.subfields = xref.split(":");
            if (this.subfields.length < 2 || !this.subfields[0].equals("GeneID")) continue;
            this.curGene.id = this.subfields[1];
        }
    }

    public void setGffversion(int gff_version) {
        this.gff_version = gff_version;
    }

    private class Gene
    extends GFFstruct {
        boolean strand;
        ArrayList<GFFstruct> exons;
        HashMap<String, Transcript> rnas;

        public Gene(String id, String name, byte chr, boolean strand) {
            this.id = id;
            this.name = name;
            this.chromosom = chr;
            this.strand = strand;
            this.exons = new ArrayList();
            this.rnas = new HashMap();
        }

        public Gene() {
            this.exons = new ArrayList();
            this.rnas = new HashMap();
        }

        public String toString() {
            return String.format("id: %s\tname: %s\tchr: %s\tstrand: %b\tnexons: %d\tnrna: %d", this.id, this.name, this.chromosom, this.strand, this.exons.size(), this.rnas.size());
        }
    }

    private class Transcript
    extends GFFstruct {
        int cdsStart;
        int cdsEnd;
        ArrayList<GFFstruct> exons;
        ArrayList<GFFstruct> cdss;

        public Transcript(String id, String name, byte chr, boolean strand) {
            this.cdsStart = Integer.MAX_VALUE;
            this.cdsEnd = Integer.MIN_VALUE;
            this.id = id;
            this.name = name;
            this.chromosom = chr;
            this.strand = strand;
            this.exons = new ArrayList();
            this.cdss = new ArrayList();
        }

        public Transcript() {
            this.cdsStart = Integer.MAX_VALUE;
            this.cdsEnd = Integer.MIN_VALUE;
            this.exons = new ArrayList();
            this.cdss = new ArrayList();
        }

        public int[] getExonStarts() {
            int i = 0;
            int[] starts = new int[this.exons.size()];
            Collections.sort(this.exons);
            for (GFFstruct exon : this.exons) {
                starts[i++] = exon.start;
            }
            return starts;
        }

        public int[] getExonEnds() {
            int i = 0;
            int[] ends = new int[this.exons.size()];
            Collections.sort(this.exons);
            for (GFFstruct exon : this.exons) {
                ends[i++] = exon.end;
            }
            return ends;
        }

        int getTxStart() {
            if (this.start == Integer.MAX_VALUE) {
                for (GFFstruct exon : this.exons) {
                    if (this.start <= exon.start) continue;
                    this.start = exon.start;
                }
            }
            return this.start;
        }

        int getTxEnd() {
            if (this.end == Integer.MIN_VALUE) {
                for (GFFstruct exon : this.exons) {
                    if (this.end >= exon.end) continue;
                    this.end = exon.end;
                }
            }
            return this.end;
        }

        int getCdsStart() {
            if (this.cdsStart == Integer.MAX_VALUE) {
                for (GFFstruct cds : this.cdss) {
                    if (this.cdsStart <= cds.start) continue;
                    this.cdsStart = cds.start;
                    if (!cds.strand) continue;
                    this.cdsStart -= (3 - cds.frame) % 3;
                }
            }
            if (this.cdsStart == Integer.MAX_VALUE) {
                this.cdsStart = this.getTxStart() + 1;
            }
            return this.cdsStart;
        }

        int getCdsEnd() {
            if (this.cdsEnd == Integer.MIN_VALUE) {
                for (GFFstruct cds : this.cdss) {
                    if (this.cdsEnd >= cds.end) continue;
                    this.cdsEnd = cds.end;
                    if (cds.strand) continue;
                    this.cdsEnd += (3 - cds.frame) % 3;
                }
            }
            if (this.cdsEnd == Integer.MIN_VALUE) {
                this.cdsEnd = this.getTxStart();
            }
            return this.cdsEnd;
        }
    }

    private class GFFstruct
    implements Comparable<GFFstruct> {
        ArrayList<GFFstruct> parents;
        byte chromosom;
        byte frame;
        String name;
        String id;
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        boolean strand;

        public GFFstruct() {
            this.parents = new ArrayList();
        }

        @Override
        public int compareTo(GFFstruct o) {
            if (this.chromosom == o.chromosom) {
                if (this.start == o.start) {
                    if (this.end == o.end) {
                        return 0;
                    }
                    if (this.end < o.end) {
                        return -1;
                    }
                    return 1;
                }
                if (this.start < o.start) {
                    return -1;
                }
                return 1;
            }
            if (this.chromosom < o.chromosom) {
                return -1;
            }
            return 1;
        }
    }
}

