/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import jannovar.reference.TranscriptModel;
import jannovar.reference.Translator;

public class DuplicationAnnotation {
    public static Annotation getAnnotation(TranscriptModel trmdl, int frame_s, String wtnt3, String var, int startpos, int endpos, int exonNumber) throws AnnotationException {
        Annotation ann;
        int cdsEndPos;
        int cdsStartPos;
        Translator translator = Translator.getTranslator();
        int refcdsstart = trmdl.getRefCDSStart();
        int newpos = DuplicationAnnotation.shiftToThreePrime(trmdl, var, startpos, endpos);
        if (newpos != startpos) {
            startpos = newpos;
            endpos = startpos + var.length() - 1;
        }
        int aaVarStartPos = (cdsStartPos = (cdsEndPos = endpos - refcdsstart + 1) - var.length() + 1) % 3 == 0 ? (int)Math.floor(cdsStartPos / 3) : (int)Math.floor(cdsStartPos / 3) + 1;
        String canno = var.length() == 1 ? String.format("c.%ddup%s", cdsStartPos, var) : String.format("c.%d_%ddup%s", cdsStartPos, cdsEndPos, var);
        if (trmdl.isMinusStrand()) {
            wtnt3 = trmdl.getWTCodonNucleotides(startpos - 1 + (3 - var.length() % 3) % 3, frame_s);
        }
        String varnt3 = DuplicationAnnotation.getVarNt3(trmdl, wtnt3, var, frame_s);
        String wtaa = translator.translateDNA(wtnt3);
        String varaa = translator.translateDNA(varnt3);
        if (var.length() % 3 == 0) {
            if ((cdsStartPos - 1) % 3 == 0) {
                String annot;
                String wtaaDupStart = translator.translateDNA(var.substring(0, 3));
                String wtaaDupEnd = translator.translateDNA(var.substring(var.length() - 3));
                if (var.length() == 3) {
                    annot = DuplicationAnnotation.singleAminoAcidInframeDuplication(trmdl.getName(), exonNumber, canno, wtaaDupStart, aaVarStartPos);
                } else {
                    int aaEndPos = aaVarStartPos + var.length() / 3 - 1;
                    annot = DuplicationAnnotation.multipleAminoAcidInframeDuplication(trmdl.getName(), exonNumber, canno, wtaaDupStart, aaVarStartPos, wtaaDupEnd, aaEndPos);
                }
                ann = new Annotation(trmdl, annot, VariantType.NON_FS_DUPLICATION, cdsStartPos);
            } else {
                int idx;
                String annot = wtaa.equals("*") ? ((idx = varaa.indexOf("*")) < 0 ? String.format("%s:exon%d:%s:p.*%d%sext*?", trmdl.getName(), exonNumber, canno, aaVarStartPos, varaa) : String.format("%s:exon%d:%s:p.*%ddelins%s", trmdl.getName(), exonNumber, canno, aaVarStartPos, varaa.substring(0, idx + 1))) : DuplicationAnnotation.shiftedInFrameDuplication(trmdl, exonNumber, canno, var, endpos, aaVarStartPos, frame_s);
                ann = new Annotation(trmdl, annot, VariantType.NON_FS_DUPLICATION, cdsStartPos);
            }
        } else {
            String annot = String.format("%s:exon%d:%s:p.%s%dfs", trmdl.getName(), exonNumber, canno, wtaa, aaVarStartPos);
            ann = new Annotation(trmdl, annot, VariantType.FS_DUPLICATION, cdsStartPos);
        }
        return ann;
    }

    private static int shiftToThreePrime(TranscriptModel trmdl, String var, int startpos, int endpos) throws AnnotationException {
        String cdna = trmdl.getCdnaSequence();
        int len = var.length();
        if (endpos - startpos != len) {
            String s = String.format("[DuplicationAnnotation.java] shiftToThreePrime: Error in sequence length; gene=%s, var=%s, len=%d, end=%d,start=%d", trmdl.getGeneSymbol(), var, len, endpos, startpos);
            throw new AnnotationException(s);
        }
        String dup = cdna.substring(startpos, endpos);
        while (endpos + len < cdna.length() && dup.equals(cdna.substring(startpos + len, endpos + len))) {
            startpos += len;
            endpos += len;
        }
        return ++startpos;
    }

    private static String getVarNt3(TranscriptModel trmdl, String wtnt3, String var, int frame_s) {
        String varnt3 = trmdl.isPlusStrand() ? ((frame_s = 2 - frame_s) == 0 ? String.format("%c%c%s%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(1)), var, Character.valueOf(wtnt3.charAt(2))) : (frame_s == 2 ? String.format("%s%s", var, wtnt3) : String.format("%c%s%c%c", Character.valueOf(wtnt3.charAt(0)), var, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3.charAt(2))))) : ((frame_s = 2 - frame_s) == 2 ? String.format("%c%s%c%c", Character.valueOf(wtnt3.charAt(0)), var, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3.charAt(2))) : (frame_s == 1 ? String.format("%c%c%s%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(1)), var, Character.valueOf(wtnt3.charAt(2))) : String.format("%s%s", wtnt3, var)));
        return varnt3;
    }

    private static String singleAminoAcidInframeDuplication(String transcriptID, int exonNumber, String cDNAannot, String wtAA, int aavarpos) {
        String a = String.format("%s:exon%d:%s:p.%s%ddup", transcriptID, exonNumber, cDNAannot, wtAA, aavarpos);
        return a;
    }

    private static String shiftedInFrameDuplication(TranscriptModel trmdl, int exonNumber, String cDNAanno, String var, int endpos, int aaVarStartPos, int frame_s) throws AnnotationException {
        Translator translator = Translator.getTranslator();
        int len = var.length();
        if (len % 3 != 0) {
            String s = String.format("[ERROR] DuplicationAnnotation:shiftedInFrameDuplication - variant length not a multiple of 3: %s (len=%d)", var, len);
            throw new AnnotationException(s);
        }
        int aalen = len / 3;
        String dna = trmdl.getCdnaSequence();
        int start = endpos - var.length();
        String prefix = dna.substring(start - frame_s, start);
        String rest = dna.substring(start, start + len);
        String wt = prefix + rest;
        String mut = prefix + var + rest;
        String wtaa = translator.translateDNA(wt);
        String mutaa = translator.translateDNA(mut);
        String annot = mutaa.startsWith(wtaa) && mutaa.indexOf(wtaa, aalen) > 0 ? String.format("%s:exon%d:%s:p.%s%ddup", trmdl.getName(), exonNumber, cDNAanno, wtaa, aaVarStartPos) : String.format("%s:exon%d:%s:p.%s%ddelins%s", trmdl.getName(), exonNumber, cDNAanno, wtaa, aaVarStartPos, mutaa);
        return annot;
    }

    private static String multipleAminoAcidInframeDuplication(String transcriptID, int exonNumber, String cDNAannot, String firstWtAA, int firstaavarpos, String lastWtAA, int lastaavarpos) {
        String a = String.format("%s:exon%d:%s:p.%s%d_%s%ddup", transcriptID, exonNumber, cDNAannot, firstWtAA, firstaavarpos, lastWtAA, lastaavarpos);
        return a;
    }

    private static void debugDuplication(TranscriptModel trmdl, int frame_s, String wtnt3, String var, int refvarstart, int exonNumber, int aavarpos) {
        System.err.println("#--------------- DuplicationAnnotation.java: DEBUG --------------------#");
        int cdsEndPos = refvarstart - trmdl.getRefCDSStart() + 1;
        int cdsStartPos = cdsEndPos - var.length() + 1;
        System.out.println("cdsStartPos=" + cdsStartPos);
        System.out.println("cdsEndPos=" + cdsEndPos);
        System.out.println("refvarstart=" + refvarstart);
        System.out.println("var.length()=" + var.length());
        System.out.println("wtnt3=" + wtnt3);
        System.out.println("frame_s=" + frame_s);
        System.out.println("exonNumber=" + exonNumber);
        System.out.println("aavarpos=" + aavarpos);
        trmdl.debugPrint();
        trmdl.debugPrintCDS();
    }
}

