/*
 * Decompiled with CFR 0.152.
 */
package jannovar.common;

public enum VariantType {
    DOWNSTREAM,
    FS_DELETION,
    FS_INSERTION,
    NON_FS_SUBSTITUTION,
    FS_SUBSTITUTION,
    INTERGENIC,
    INTRONIC,
    MISSENSE,
    ncRNA_EXONIC,
    ncRNA_INTRONIC,
    ncRNA_SPLICING,
    NON_FS_DELETION,
    NON_FS_INSERTION,
    SPLICING,
    STOPGAIN,
    STOPLOSS,
    SYNONYMOUS,
    UPSTREAM,
    UTR3,
    UTR5,
    ERROR,
    NON_FS_DUPLICATION,
    FS_DUPLICATION,
    START_LOSS;

    private static final int size;

    public static int priorityLevel(VariantType vt) {
        switch (vt) {
            case FS_DELETION: 
            case FS_INSERTION: 
            case NON_FS_SUBSTITUTION: 
            case FS_SUBSTITUTION: 
            case MISSENSE: 
            case NON_FS_DELETION: 
            case NON_FS_INSERTION: 
            case SPLICING: 
            case STOPGAIN: 
            case STOPLOSS: 
            case FS_DUPLICATION: 
            case NON_FS_DUPLICATION: 
            case START_LOSS: {
                return 1;
            }
            case ncRNA_EXONIC: 
            case ncRNA_SPLICING: {
                return 2;
            }
            case UTR3: {
                return 3;
            }
            case UTR5: {
                return 4;
            }
            case SYNONYMOUS: {
                return 5;
            }
            case INTRONIC: {
                return 6;
            }
            case ncRNA_INTRONIC: {
                return 7;
            }
            case UPSTREAM: 
            case DOWNSTREAM: {
                return 8;
            }
            case INTERGENIC: {
                return 9;
            }
            case ERROR: {
                return 10;
            }
        }
        return 10;
    }

    public boolean isTopPriorityVariant() {
        return VariantType.priorityLevel(this) == 1;
    }

    public static VariantType[] getPrioritySortedList() {
        VariantType[] vta = new VariantType[]{MISSENSE, STOPGAIN, SPLICING, FS_DELETION, FS_INSERTION, FS_SUBSTITUTION, NON_FS_DELETION, NON_FS_INSERTION, NON_FS_SUBSTITUTION, STOPLOSS, FS_DUPLICATION, NON_FS_DUPLICATION, START_LOSS, ncRNA_EXONIC, ncRNA_SPLICING, UTR3, UTR5, SYNONYMOUS, INTRONIC, ncRNA_INTRONIC, UPSTREAM, DOWNSTREAM, INTERGENIC, ERROR};
        return vta;
    }

    public String toDisplayString() {
        switch (this) {
            case FS_DELETION: {
                return "frameshift truncation";
            }
            case FS_INSERTION: {
                return "frameshift elongation";
            }
            case NON_FS_SUBSTITUTION: {
                return "inframe substitution";
            }
            case FS_SUBSTITUTION: {
                return "frameshift substitution";
            }
            case MISSENSE: {
                return "missense";
            }
            case NON_FS_DELETION: {
                return "inframe deletion";
            }
            case NON_FS_INSERTION: {
                return "inframe insertion";
            }
            case SPLICING: {
                return "splicing";
            }
            case STOPGAIN: {
                return "stopgain";
            }
            case STOPLOSS: {
                return "stoploss";
            }
            case NON_FS_DUPLICATION: {
                return "inframe duplication";
            }
            case FS_DUPLICATION: {
                return "frameshift duplication";
            }
            case START_LOSS: {
                return "startloss";
            }
            case ncRNA_EXONIC: {
                return "ncRNA exonic";
            }
            case ncRNA_INTRONIC: {
                return "ncRNA intronic";
            }
            case ncRNA_SPLICING: {
                return "ncRNA splicing";
            }
            case UTR3: {
                return "UTR3";
            }
            case UTR5: {
                return "UTR5";
            }
            case SYNONYMOUS: {
                return "synonymous";
            }
            case INTRONIC: {
                return "intronic";
            }
            case UPSTREAM: {
                return "upstream";
            }
            case DOWNSTREAM: {
                return "downstream";
            }
            case INTERGENIC: {
                return "intergenic";
            }
            case ERROR: {
                return "error";
            }
        }
        return "unknown variant type (error)";
    }

    public String toSequenceOntologyTerm() {
        switch (this) {
            case FS_DELETION: {
                return "frameshift_truncation";
            }
            case FS_INSERTION: {
                return "frameshift_elongation";
            }
            case NON_FS_SUBSTITUTION: {
                return "inframe_substitution";
            }
            case FS_SUBSTITUTION: {
                return "frameshift_substitution";
            }
            case MISSENSE: {
                return "missense_variant";
            }
            case NON_FS_DELETION: {
                return "inframe_deletion";
            }
            case NON_FS_INSERTION: {
                return "inframe_insertion";
            }
            case SPLICING: {
                return "splice_region_variant";
            }
            case STOPGAIN: {
                return "stop_gained";
            }
            case STOPLOSS: {
                return "stop_lost";
            }
            case NON_FS_DUPLICATION: {
                return "inframe_duplication";
            }
            case FS_DUPLICATION: {
                return "frameshift_duplication";
            }
            case START_LOSS: {
                return "start_lost";
            }
            case ncRNA_EXONIC: {
                return "non_coding_exon_variant";
            }
            case ncRNA_INTRONIC: {
                return "non_coding_intron_variant";
            }
            case ncRNA_SPLICING: {
                return "non_coding_splice_region_variant";
            }
            case UTR3: {
                return "3_prime_UTR_variant";
            }
            case UTR5: {
                return "5_prime_UTR_variant";
            }
            case SYNONYMOUS: {
                return "synonymous_variant";
            }
            case INTRONIC: {
                return "intron_variant";
            }
            case UPSTREAM: {
                return "upstream_gene_variant";
            }
            case DOWNSTREAM: {
                return "downstream_gene_variant";
            }
            case INTERGENIC: {
                return "intergenic_variant";
            }
            case ERROR: {
                return "error";
            }
        }
        return "unknown variant type (error)";
    }

    public String toSequenceOntologyID() {
        switch (this) {
            case FS_DELETION: {
                return "SO:0001910";
            }
            case FS_INSERTION: {
                return "SO:0001909";
            }
            case NON_FS_SUBSTITUTION: {
                return "nonframeshift substitution";
            }
            case FS_SUBSTITUTION: {
                return "frameshift substitution";
            }
            case MISSENSE: {
                return "SO:0001583";
            }
            case NON_FS_DELETION: {
                return "SO:0001822";
            }
            case NON_FS_INSERTION: {
                return "SO:0001821";
            }
            case SPLICING: {
                return "SO:0001630";
            }
            case STOPGAIN: {
                return "SO:0001587";
            }
            case STOPLOSS: {
                return "SO:0001578";
            }
            case NON_FS_DUPLICATION: {
                return "nonframeshift duplication";
            }
            case FS_DUPLICATION: {
                return "frameshift duplication";
            }
            case START_LOSS: {
                return "start loss";
            }
            case ncRNA_EXONIC: {
                return "SO:0001792";
            }
            case ncRNA_INTRONIC: {
                return "noncoding RNA intronic";
            }
            case ncRNA_SPLICING: {
                return "noncoding RNA splicing";
            }
            case UTR3: {
                return "SO:0001624";
            }
            case UTR5: {
                return "SO:0001623";
            }
            case SYNONYMOUS: {
                return "SO:0001819";
            }
            case INTRONIC: {
                return "SO:0001627";
            }
            case UPSTREAM: {
                return "SO:0001631";
            }
            case DOWNSTREAM: {
                return "SO:0001632";
            }
            case INTERGENIC: {
                return "SO:0001628";
            }
            case ERROR: {
                return "error";
            }
        }
        return "unknown variant type (error)";
    }

    public static int size() {
        return size;
    }

    static {
        size = VariantType.values().length;
    }
}

