/*
 * Decompiled with CFR 0.152.
 */
package jannovar.genotype;

import jannovar.common.Genotype;
import jannovar.exception.VCFParseException;
import jannovar.genotype.GenotypeCall;
import jannovar.genotype.GenotypeFactoryA;

public class SingleGenotypeFactory
extends GenotypeFactoryA {
    private static int UNINITIALIZED_INT = -10;

    @Override
    public GenotypeCall createGenotype(String[] A) throws VCFParseException {
        GenotypeCall gt = this.parse_genotype(A[7], A[8], A[9]);
        return gt;
    }

    private GenotypeCall parse_genotype(String info, String format, String sample) throws VCFParseException {
        Genotype call = Genotype.UNINITIALIZED;
        int genotype_quality = UNINITIALIZED_INT;
        int genotype_depth = UNINITIALIZED_INT;
        String[] A = format.split(":");
        int gt_idx = UNINITIALIZED_INT;
        int qual_idx = UNINITIALIZED_INT;
        int depth_idx = UNINITIALIZED_INT;
        for (int i = 0; i < A.length; ++i) {
            if (A[i].equals("GT")) {
                gt_idx = i;
            }
            if (A[i].equals("GQ")) {
                qual_idx = i;
            }
            if (!A[i].equals("DP")) continue;
            depth_idx = i;
        }
        if (gt_idx == UNINITIALIZED_INT) {
            String s = String.format("Could not find genotype field in FORMAT field: \"%s\"", format);
            throw new VCFParseException(s);
        }
        String[] B = sample.split(":");
        String genot = B[gt_idx];
        call = this.parseGenotypeString(genot);
        if (call == Genotype.NOT_OBSERVED) {
            qual_idx = UNINITIALIZED_INT;
            depth_idx = UNINITIALIZED_INT;
        }
        if (qual_idx != UNINITIALIZED_INT) {
            try {
                genotype_quality = this.parseGenotypeQuality(B[qual_idx]);
            }
            catch (NumberFormatException e) {
                String err = "Could not parse genotype quality field \"" + B[qual_idx] + "\" due to a Number Format Exception:" + e.toString();
                throw new VCFParseException(err);
            }
            catch (Exception e) {
                String err = "Could not parse genotype quality field: " + format + ": Exception:\n\t" + e.toString();
                throw new VCFParseException(err);
            }
        }
        if (depth_idx != UNINITIALIZED_INT) {
            try {
                genotype_depth = this.parseGenotypeDepth(B[depth_idx]);
            }
            catch (NumberFormatException e) {
                String err = "Could not parse genotype depth field \"" + B[depth_idx] + "\" due to a Number Format Exception:" + e.toString();
                throw new VCFParseException(err);
            }
            catch (Exception e) {
                String err = "Could not parse genotype depth field: " + format + ": Exception:\n\t" + e.toString();
                throw new VCFParseException(err);
            }
        } else {
            genotype_depth = this.parseDepthFromInfo(info);
        }
        if (genotype_depth != UNINITIALIZED_INT) {
            return new GenotypeCall(call, genotype_quality, genotype_depth);
        }
        return new GenotypeCall(call, genotype_quality);
    }

    private int parseDepthFromInfo(String info) {
        int i = info.indexOf("DP=");
        if (i < 0) {
            return UNINITIALIZED_INT;
        }
        int j = info.indexOf(";", i += 3);
        Integer dp = null;
        try {
            dp = j < 0 ? Integer.valueOf(Integer.parseInt(info.substring(i))) : Integer.valueOf(Integer.parseInt(info.substring(i, j)));
        }
        catch (NumberFormatException e) {
            System.err.println("INOF=" + info);
            System.err.println("i=" + i);
            return UNINITIALIZED_INT;
        }
        return dp;
    }
}

