/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.reference.TranscriptModel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public abstract class FastaParser {
    protected String filename;
    protected String accession;
    protected StringBuilder sequence;
    protected ArrayList<TranscriptModel> transcriptmodels;
    protected ArrayList<TranscriptModel> transcriptmodelsProcessed;
    protected HashMap<String, Integer> transcript2index;

    public FastaParser(String filename, ArrayList<TranscriptModel> models) {
        this.filename = filename;
        this.transcriptmodels = models;
        this.transcriptmodelsProcessed = new ArrayList();
        this.transcript2index = new HashMap(this.transcriptmodels.size());
        for (int i = 0; i < this.transcriptmodels.size(); ++i) {
            this.transcript2index.put(this.transcriptmodels.get(i).getAccessionNumber(), i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TranscriptModel> parse() {
        BufferedReader in = null;
        try {
            String str;
            in = this.filename.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.filename)))) : new BufferedReader(new FileReader(this.filename));
            while ((str = in.readLine()) != null) {
                if (str.startsWith(">")) {
                    if (this.sequence != null) {
                        this.addSequenceToModel();
                    }
                    this.accession = this.processHeader(str);
                    this.sequence = new StringBuilder();
                    continue;
                }
                this.sequence.append(str);
            }
        }
        catch (IOException e) {
            System.err.println("[WARNING] failed to read the FastA file:\n" + e.toString());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                System.err.println("[WARNING] failed to close the FastA file reader:\n" + e.toString());
            }
        }
        return this.transcriptmodelsProcessed;
    }

    private void addSequenceToModel() {
        Integer idx = this.transcript2index.get(this.accession);
        if (idx != null) {
            this.transcriptmodels.get(idx).setSequence(this.sequence.toString());
            this.transcriptmodels.get(idx).initialize();
            this.transcriptmodelsProcessed.add(this.transcriptmodels.get(idx));
        }
    }

    protected abstract String processHeader(String var1);
}

