/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.exception.PedParseException;
import jannovar.pedigree.Pedigree;
import jannovar.pedigree.Person;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PedFileParser {
    private String pedfile_path = null;
    private String base_filename = null;
    private Pedigree pedigree = null;

    public Pedigree parseFile(String PEDfilePath) throws PedParseException {
        this.pedfile_path = PEDfilePath;
        File file = new File(this.pedfile_path);
        this.base_filename = file.getName();
        try {
            FileInputStream fstream = new FileInputStream(this.pedfile_path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.inputPedFileStream(br);
            br.close();
        }
        catch (IOException e) {
            String err = String.format("[PedFileParser:parseFile]: %s", e.toString());
            throw new PedParseException(err);
        }
        return this.pedigree;
    }

    public Pedigree parseStream(BufferedReader PEDfileContents) throws PedParseException {
        try {
            this.inputPedFileStream(PEDfileContents);
        }
        catch (IOException e) {
            String err = String.format("[PedFileParser:parseStringStream]: %s", e.toString());
            throw new PedParseException(err);
        }
        return this.pedigree;
    }

    private void inputPedFileStream(BufferedReader br) throws IOException, PedParseException {
        String line;
        boolean linecount = false;
        boolean firstline = true;
        ArrayList<Person> personList = new ArrayList<Person>();
        String famID = null;
        while ((line = br.readLine()) != null) {
            if (line.isEmpty()) continue;
            String[] A = line.split("\\s+");
            if (A.length < 6) {
                throw new PedParseException("Error: ped file line with less than 6 fields: " + line);
            }
            Person per = this.parsePerson(A);
            if (firstline) {
                famID = per.getFamilyID();
            }
            personList.add(per);
        }
        this.pedigree = new Pedigree(personList, famID);
    }

    public Person parsePerson(String[] A) throws PedParseException {
        String famID = A[0];
        String individualID = A[1];
        String fatherID = A[2].equals("0") ? null : A[2];
        String motherID = A[3].equals("0") ? null : A[3];
        String sex = A[4];
        String disease = A[5];
        return new Person(famID, individualID, fatherID, motherID, sex, disease);
    }
}

