/*
 * Decompiled with CFR 0.152.
 */
package jannovar.pedigree;

import jannovar.common.Disease;
import jannovar.exception.PedParseException;
import java.util.ArrayList;

public class Person {
    private String familyID = null;
    private String individualID = null;
    private String fatherID = null;
    private Person father = null;
    private String motherID = null;
    private Person mother = null;
    private Sex sex;
    private Disease disease;
    private boolean isFounder = false;
    private int index;

    public Person(String famID, String indID, String fathID, String mothID, String sx, String dse) throws PedParseException {
        this.familyID = famID;
        this.individualID = indID;
        this.fatherID = fathID;
        this.motherID = mothID;
        if (fathID == null && mothID == null) {
            this.isFounder = true;
        }
        if (sx.equals("1")) {
            this.sex = Sex.MALE;
        } else if (sx.equals("2")) {
            this.sex = Sex.FEMALE;
        } else {
            String s = String.format("Malformed sex identifier (%s) in pedfile", sx);
            throw new PedParseException(s);
        }
        if (dse.equals("2")) {
            this.disease = Disease.AFFECTED;
        } else if (dse.equals("1")) {
            this.disease = Disease.UNAFFECTED;
        } else if (dse.equals("0")) {
            this.disease = Disease.UNKNOWN;
        } else {
            String s = String.format("Malformed disease identifier (%s) in pedfile", dse);
            throw new PedParseException(s);
        }
    }

    public String getFamilyID() {
        return this.familyID;
    }

    public String getIndividualID() {
        return this.individualID;
    }

    public String getFatherID() {
        return this.fatherID;
    }

    public void setFather(Person f) {
        this.father = f;
    }

    public Person getFather() {
        return this.father;
    }

    public Person getMother() {
        return this.mother;
    }

    public void setMother(Person m) {
        this.mother = m;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public String getMotherID() {
        return this.motherID;
    }

    public Disease getDiseaseStatus() {
        return this.disease;
    }

    public boolean isAffected() {
        return this.disease == Disease.AFFECTED;
    }

    public boolean isUnaffected() {
        return this.disease == Disease.UNAFFECTED;
    }

    public boolean isMale() {
        return this.sex == Sex.MALE;
    }

    public boolean isFemale() {
        return this.sex == Sex.FEMALE;
    }

    public ArrayList<String> getPEDFileData() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(this.getFamilyID());
        lst.add(this.getIndividualID());
        String f = this.getFatherID();
        if (f == null) {
            lst.add("-");
        } else {
            lst.add(this.getFatherID());
        }
        String m = this.getMotherID();
        if (m == null) {
            lst.add("-");
        } else {
            lst.add(this.getMotherID());
        }
        if (this.isMale()) {
            lst.add("Male");
        } else if (this.isFemale()) {
            lst.add("Female");
        } else {
            lst.add("Gender unknown");
        }
        if (this.isAffected()) {
            lst.add("Affected");
        } else if (this.isUnaffected()) {
            lst.add("Unaffected");
        } else {
            lst.add("Disease status unknown");
        }
        return lst;
    }

    public String toString() {
        String s = String.format("%s\t%s\t%s\t%s\t%s\t%s\t", new Object[]{this.familyID, this.individualID, this.fatherID, this.motherID, this.sex, this.disease});
        return s;
    }

    private static enum Sex {
        MALE,
        FEMALE;

    }
}

