/*
 * Decompiled with CFR 0.152.
 */
package jannovar.reference;

import jannovar.exception.AnnotationException;
import java.util.HashMap;

public class Translator {
    private HashMap<String, String> codon1 = null;
    private HashMap<String, String> codon3 = null;
    private HashMap<String, String> iupac = null;
    private static Translator translator = null;

    private Translator() {
        this.initializeMaps();
    }

    public static Translator getTranslator() {
        if (translator == null) {
            translator = new Translator();
        }
        return translator;
    }

    public String translateDNA(String dnaseq) throws AnnotationException {
        String nt3;
        String aa;
        StringBuilder aminoAcidSeq = new StringBuilder();
        int len = dnaseq.length();
        if (len % 3 != 0) {
            len -= len % 3;
        }
        for (int i = 0; i < len && (aa = this.codon1.get(nt3 = dnaseq.substring(i, i + 3))) != null; i += 3) {
            aminoAcidSeq.append(aa);
        }
        return aminoAcidSeq.toString();
    }

    private void initializeMaps() {
        this.codon1 = new HashMap();
        this.codon3 = new HashMap();
        this.iupac = new HashMap();
        this.codon1.put("AAA", "K");
        this.codon1.put("AAC", "N");
        this.codon1.put("AAG", "K");
        this.codon1.put("AAT", "N");
        this.codon1.put("ACA", "T");
        this.codon1.put("ACC", "T");
        this.codon1.put("ACG", "T");
        this.codon1.put("ACT", "T");
        this.codon1.put("AGA", "R");
        this.codon1.put("AGC", "S");
        this.codon1.put("AGG", "R");
        this.codon1.put("AGT", "S");
        this.codon1.put("ATA", "I");
        this.codon1.put("ATC", "I");
        this.codon1.put("ATG", "M");
        this.codon1.put("ATT", "I");
        this.codon1.put("CAA", "Q");
        this.codon1.put("CAC", "H");
        this.codon1.put("CAG", "Q");
        this.codon1.put("CAT", "H");
        this.codon1.put("CCA", "P");
        this.codon1.put("CCC", "P");
        this.codon1.put("CCG", "P");
        this.codon1.put("CCT", "P");
        this.codon1.put("CGA", "R");
        this.codon1.put("CGC", "R");
        this.codon1.put("CGG", "R");
        this.codon1.put("CGT", "R");
        this.codon1.put("CTA", "L");
        this.codon1.put("CTC", "L");
        this.codon1.put("CTG", "L");
        this.codon1.put("CTT", "L");
        this.codon1.put("GAA", "E");
        this.codon1.put("GAC", "D");
        this.codon1.put("GAG", "E");
        this.codon1.put("GAT", "D");
        this.codon1.put("GCA", "A");
        this.codon1.put("GCC", "A");
        this.codon1.put("GCG", "A");
        this.codon1.put("GCT", "A");
        this.codon1.put("GGA", "G");
        this.codon1.put("GGC", "G");
        this.codon1.put("GGG", "G");
        this.codon1.put("GGT", "G");
        this.codon1.put("GTA", "V");
        this.codon1.put("GTC", "V");
        this.codon1.put("GTG", "V");
        this.codon1.put("GTT", "V");
        this.codon1.put("TAA", "*");
        this.codon1.put("TAC", "Y");
        this.codon1.put("TAG", "*");
        this.codon1.put("TAT", "Y");
        this.codon1.put("TCA", "S");
        this.codon1.put("TCC", "S");
        this.codon1.put("TCG", "S");
        this.codon1.put("TCT", "S");
        this.codon1.put("TGA", "*");
        this.codon1.put("TGC", "C");
        this.codon1.put("TGG", "W");
        this.codon1.put("TGT", "C");
        this.codon1.put("TTA", "L");
        this.codon1.put("TTC", "F");
        this.codon1.put("TTG", "L");
        this.codon1.put("TTT", "F");
        this.codon3.put("AAA", "Lys");
        this.codon3.put("AAC", "Asn");
        this.codon3.put("AAG", "Lys");
        this.codon3.put("AAT", "Asn");
        this.codon3.put("ACA", "Thr");
        this.codon3.put("ACC", "Thr");
        this.codon3.put("ACG", "Thr");
        this.codon3.put("ACT", "Thr");
        this.codon3.put("AGA", "Arg");
        this.codon3.put("AGC", "Ser");
        this.codon3.put("AGG", "Arg");
        this.codon3.put("AGT", "Ser");
        this.codon3.put("ATA", "Ile");
        this.codon3.put("ATC", "Ile");
        this.codon3.put("ATG", "Met");
        this.codon3.put("ATT", "Ile");
        this.codon3.put("CAA", "Gln");
        this.codon3.put("CAC", "His");
        this.codon3.put("CAG", "Gln");
        this.codon3.put("CAT", "His");
        this.codon3.put("CCA", "Pro");
        this.codon3.put("CCC", "Pro");
        this.codon3.put("CCG", "Pro");
        this.codon3.put("CCT", "Pro");
        this.codon3.put("CGA", "Arg");
        this.codon3.put("CGC", "Arg");
        this.codon3.put("CGG", "Arg");
        this.codon3.put("CGT", "Arg");
        this.codon3.put("CTA", "Leu");
        this.codon3.put("CTC", "Leu");
        this.codon3.put("CTG", "Leu");
        this.codon3.put("CTT", "Leu");
        this.codon3.put("GAA", "Glu");
        this.codon3.put("GAC", "Asp");
        this.codon3.put("GAG", "Glu");
        this.codon3.put("GAT", "Asp");
        this.codon3.put("GCA", "Ala");
        this.codon3.put("GCC", "Ala");
        this.codon3.put("GCG", "Ala");
        this.codon3.put("GCT", "Ala");
        this.codon3.put("GGA", "Gly");
        this.codon3.put("GGC", "Gly");
        this.codon3.put("GGG", "Gly");
        this.codon3.put("GGT", "Gly");
        this.codon3.put("GTA", "Val");
        this.codon3.put("GTC", "Val");
        this.codon3.put("GTG", "Val");
        this.codon3.put("GTT", "Val");
        this.codon3.put("TAA", "*");
        this.codon3.put("TAC", "Tyr");
        this.codon3.put("TAG", "*");
        this.codon3.put("TAT", "Tyr");
        this.codon3.put("TCA", "Ser");
        this.codon3.put("TCC", "Ser");
        this.codon3.put("TCG", "Ser");
        this.codon3.put("TCT", "Ser");
        this.codon3.put("TGA", "*");
        this.codon3.put("TGC", "Cys");
        this.codon3.put("TGG", "Trp");
        this.codon3.put("TGT", "Cys");
        this.codon3.put("TTA", "Leu");
        this.codon3.put("TTC", "Phe");
        this.codon3.put("TTG", "Leu");
        this.codon3.put("TTT", "Phe");
        this.iupac.put("-", "-");
        this.iupac.put(".", "-");
        this.iupac.put("A", "AA");
        this.iupac.put("B", "CGT");
        this.iupac.put("C", "CC");
        this.iupac.put("D", "AGT");
        this.iupac.put("G", "GG");
        this.iupac.put("H", "ACT");
        this.iupac.put("K", "GT");
        this.iupac.put("M", "AC");
        this.iupac.put("N", "ACGT");
        this.iupac.put("R", "AG");
        this.iupac.put("S", "GC");
        this.iupac.put("T", "TT");
        this.iupac.put("V", "ACG");
        this.iupac.put("W", "AT");
        this.iupac.put("Y", "CT");
    }
}

