/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.annotation.DuplicationAnnotation;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import jannovar.reference.TranscriptModel;
import jannovar.reference.Translator;

public class InsertionAnnotation {
    public static Annotation getAnnotation(TranscriptModel trmdl, int frame_s, String wtnt3, String wtnt3_after, String ref, String var, int refvarstart, int exonNumber) throws AnnotationException {
        int potentialDuplicationEndPos;
        int potentialDuplicationStartPos;
        if (trmdl.isMinusStrand()) {
            --refvarstart;
        }
        if (trmdl.isPlusStrand()) {
            potentialDuplicationStartPos = refvarstart - var.length();
            potentialDuplicationEndPos = refvarstart;
            if (trmdl.getCdnaSequence().substring(potentialDuplicationStartPos, potentialDuplicationEndPos).equals(var)) {
                Annotation ann = DuplicationAnnotation.getAnnotation(trmdl, frame_s, wtnt3, var, potentialDuplicationStartPos, potentialDuplicationEndPos, exonNumber);
                return ann;
            }
        } else {
            potentialDuplicationStartPos = refvarstart;
            potentialDuplicationEndPos = refvarstart + var.length();
            if (potentialDuplicationStartPos >= var.length() && potentialDuplicationEndPos < trmdl.getMRNALength() && trmdl.getCdnaSequence().substring(potentialDuplicationStartPos, potentialDuplicationEndPos).equals(var)) {
                Annotation ann = DuplicationAnnotation.getAnnotation(trmdl, frame_s, wtnt3, var, potentialDuplicationStartPos, potentialDuplicationEndPos, exonNumber);
                return ann;
            }
        }
        int refcdsstart = trmdl.getRefCDSStart();
        int startPosMutationInCDS = refvarstart - refcdsstart + 1;
        int aavarpos = (int)Math.floor(startPosMutationInCDS / 3) + 1;
        Translator translator = Translator.getTranslator();
        String varnt3 = null;
        if (trmdl.isPlusStrand()) {
            varnt3 = frame_s == 1 ? String.format("%c%c%s%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(1)), var, Character.valueOf(wtnt3.charAt(2))) : (frame_s == 2 ? String.format("%s%s", wtnt3, var) : String.format("%c%s%c%c", Character.valueOf(wtnt3.charAt(0)), var, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3.charAt(2))));
        } else if (trmdl.isMinusStrand()) {
            varnt3 = frame_s == 1 ? String.format("%c%s%c%c", Character.valueOf(wtnt3.charAt(0)), var, Character.valueOf(wtnt3.charAt(1)), Character.valueOf(wtnt3.charAt(2))) : (frame_s == 2 ? String.format("%c%c%s%c", Character.valueOf(wtnt3.charAt(0)), Character.valueOf(wtnt3.charAt(1)), var, Character.valueOf(wtnt3.charAt(2))) : String.format("%s%s", var, wtnt3));
        }
        String wtaa = translator.translateDNA(wtnt3);
        String wtaa_after = null;
        if (wtnt3_after != null && wtnt3_after.length() > 0) {
            wtaa_after = translator.translateDNA(wtnt3_after);
        }
        String varaa = translator.translateDNA(varnt3);
        String canno = String.format("c.%d_%dins%s", startPosMutationInCDS, refvarstart - refcdsstart + 2, var);
        if (var.length() % 3 == 0) {
            if (wtaa.equals("*")) {
                int idx = varaa.indexOf("*");
                if (idx >= 0) {
                    varaa = String.format("%s*", varaa.substring(0, idx + 1));
                    String annot = String.format("%s:exon:%d:%s:p.X%ddelins%s", trmdl.getName(), exonNumber, canno, aavarpos, varaa);
                    Annotation ann = new Annotation(trmdl, annot, VariantType.NON_FS_INSERTION, startPosMutationInCDS);
                    return ann;
                }
                String annot = String.format("%s:exon%d:%s:p.X%ddelins%s", trmdl.getName(), exonNumber, canno, aavarpos, varaa);
                Annotation ann = new Annotation(trmdl, annot, VariantType.STOPLOSS, startPosMutationInCDS);
                return ann;
            }
            int idx = varaa.indexOf("*");
            if (idx >= 0) {
                varaa = String.format("%s*", varaa.substring(0, idx + 1));
                String annot = String.format("%s:exon%d:%s:p.%s%ddelins%s", trmdl.getName(), exonNumber, canno, wtaa, aavarpos, varaa);
                Annotation ann = new Annotation(trmdl, annot, VariantType.STOPGAIN, startPosMutationInCDS);
                return ann;
            }
            String annot = String.format("%s:exon%d:%s:p.%s%ddelins%s", trmdl.getName(), exonNumber, canno, wtaa, aavarpos, varaa);
            Annotation ann = new Annotation(trmdl, annot, VariantType.NON_FS_INSERTION, startPosMutationInCDS);
            return ann;
        }
        if (wtaa.equals("*")) {
            int idx = varaa.indexOf("*");
            if (idx >= 0) {
                varaa = String.format("%sX", varaa.substring(0, idx + 1));
                String annot = String.format("%s:exon%d:%s:p.X%ddelins%s", trmdl.getName(), exonNumber, canno, aavarpos, varaa);
                Annotation ann = new Annotation(trmdl, annot, VariantType.FS_INSERTION, startPosMutationInCDS);
                return ann;
            }
            String annot = String.format("%s:exon%d:%s:p.X%ddelins%s", trmdl.getName(), exonNumber, canno, aavarpos, varaa);
            Annotation ann = new Annotation(trmdl, annot, VariantType.STOPLOSS, startPosMutationInCDS);
            return ann;
        }
        int idx = varaa.indexOf("*");
        if (idx >= 0) {
            varaa = String.format("%s*", varaa.substring(0, idx + 1));
            String annot = String.format("%s:exon%d:%s:p.%s%d_%s%ddelins%s", trmdl.getName(), exonNumber, canno, wtaa, aavarpos, wtaa_after, aavarpos + 1, varaa);
            Annotation ann = new Annotation(trmdl, annot, VariantType.STOPGAIN, startPosMutationInCDS);
            return ann;
        }
        if (aavarpos == 1) {
            String annot = String.format("%s:exon%d:%s:p.%s%d?", trmdl.getName(), exonNumber, canno, wtaa, aavarpos);
            Annotation ann = new Annotation(trmdl, annot, VariantType.START_LOSS, startPosMutationInCDS);
            return ann;
        }
        String annot = String.format("%s:exon%d:%s:p.%s%dfs", trmdl.getName(), exonNumber, canno, wtaa, aavarpos);
        Annotation ann = new Annotation(trmdl, annot, VariantType.FS_INSERTION, startPosMutationInCDS);
        return ann;
    }
}

