/*
 * Decompiled with CFR 0.152.
 */
package jannovar.genotype;

import jannovar.common.Genotype;
import java.util.ArrayList;
import java.util.Iterator;

public class GenotypeCall {
    private ArrayList<Genotype> callList = null;
    private ArrayList<Integer> qualityList = null;
    private ArrayList<Integer> depthList = null;

    public GenotypeCall(ArrayList<Genotype> calls, ArrayList<Integer> qualities) {
        this.callList = calls;
        this.qualityList = qualities;
    }

    public GenotypeCall(ArrayList<Genotype> calls, ArrayList<Integer> qualities, ArrayList<Integer> depths) {
        this.callList = calls;
        this.qualityList = qualities;
        this.depthList = depths;
    }

    public GenotypeCall(Genotype gt, Integer qual) {
        this.callList = new ArrayList();
        this.callList.add(gt);
        this.qualityList = new ArrayList();
        this.qualityList.add(qual);
    }

    public GenotypeCall(Genotype gt, Integer qual, Integer depth) {
        this.callList = new ArrayList();
        this.callList.add(gt);
        this.qualityList = new ArrayList();
        this.qualityList.add(qual);
        this.depthList = new ArrayList();
        this.depthList.add(depth);
    }

    public ArrayList<String> getGenotypeList() {
        ArrayList<String> lst = new ArrayList<String>();
        for (Genotype call : this.callList) {
            switch (call) {
                case HOMOZYGOUS_REF: {
                    lst.add("0/0");
                    break;
                }
                case HOMOZYGOUS_ALT: {
                    lst.add("1/1");
                    break;
                }
                case HETEROZYGOUS: {
                    lst.add("0/1");
                    break;
                }
                case NOT_OBSERVED: {
                    lst.add("./.");
                    break;
                }
                case ERROR: {
                    lst.add("?");
                    break;
                }
                case UNINITIALIZED: {
                    lst.add("-");
                }
            }
        }
        return lst;
    }

    public String get_genotype_as_string() {
        StringBuffer sb = new StringBuffer();
        Iterator<Genotype> it = this.callList.iterator();
        int c = 0;
        while (it.hasNext()) {
            Genotype call = it.next();
            if (c++ > 0) {
                sb.append(":");
            }
            switch (call) {
                case HOMOZYGOUS_REF: {
                    sb.append("0/0");
                    break;
                }
                case HOMOZYGOUS_ALT: {
                    sb.append("1/1");
                    break;
                }
                case HETEROZYGOUS: {
                    sb.append("0/1");
                    break;
                }
                case NOT_OBSERVED: {
                    sb.append("./.");
                    break;
                }
                case ERROR: {
                    sb.append("?");
                    break;
                }
                case UNINITIALIZED: {
                    sb.append("-");
                }
            }
        }
        return sb.toString();
    }

    public Genotype getGenotypeInIndividualN(int n) {
        if (n < 0 || n >= this.callList.size()) {
            throw new IllegalArgumentException();
        }
        return this.callList.get(n);
    }

    public int getReadDepthInIndividualN(int n) {
        if (this.depthList == null) {
            return 0;
        }
        if (n < 0 || n >= this.depthList.size()) {
            throw new IllegalArgumentException();
        }
        return this.depthList.get(n);
    }

    public int getQualityInIndividualN(int n) {
        if (this.qualityList == null) {
            return 0;
        }
        if (n < 0 || n >= this.callList.size()) {
            throw new IllegalArgumentException();
        }
        return this.qualityList.get(n);
    }

    public boolean isHomozygousAltInIndividualN(int n) {
        if (n < 0 || n >= this.callList.size()) {
            throw new IllegalArgumentException();
        }
        Genotype gt = this.callList.get(n);
        return gt == Genotype.HOMOZYGOUS_ALT;
    }

    public boolean isHeterozygousInIndividualN(int n) {
        if (n < 0 || n >= this.callList.size()) {
            throw new IllegalArgumentException();
        }
        Genotype gt = this.callList.get(n);
        return gt == Genotype.HETEROZYGOUS;
    }

    public boolean isALTInIndividualN(int n) {
        if (n < 0 || n >= this.callList.size()) {
            throw new IllegalArgumentException();
        }
        Genotype gt = this.callList.get(n);
        if (gt == Genotype.HETEROZYGOUS) {
            return true;
        }
        return gt == Genotype.HOMOZYGOUS_ALT;
    }

    public boolean isMissingInIndividualN(int n) {
        if (n < 0 || n >= this.callList.size()) {
            throw new IllegalArgumentException();
        }
        Genotype gt = this.callList.get(n);
        return gt == Genotype.NOT_OBSERVED;
    }

    public int getNumberOfIndividuals() {
        return this.callList.size();
    }
}

