/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.exception.JannovarException;
import jannovar.reference.TranscriptModel;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class SerializationManager {
    public void serializeKnownGeneList(String filename, ArrayList<TranscriptModel> kgList) throws JannovarException {
        if (kgList == null || kgList.isEmpty()) {
            throw new JannovarException("Error: attempt to serialize empty knownGene list");
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(kgList);
            oos.close();
        }
        catch (IOException i) {
            String error = String.format("Could not serialize knownGene list: %s", i.toString());
            throw new JannovarException(error);
        }
    }

    public ArrayList<TranscriptModel> deserializeKnownGeneList(String filename) throws JannovarException {
        ArrayList kgList = null;
        try {
            FileInputStream fileIn = new FileInputStream(filename);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            kgList = (ArrayList)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException i) {
            String error = String.format("[SerializationManager] i/o error: Could not deserialize knownGene list: %s", i.toString());
            throw new JannovarException(error);
        }
        catch (ClassNotFoundException c) {
            String error = String.format("[SerializationManager] Could not serialized class definition: %s", c.toString());
            throw new JannovarException(error);
        }
        return kgList;
    }
}

