/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.db.ConnectionPool;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.serverapi.SettingsManager;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.VersionSettings;

public class ConnectionController {
    private static final Log LOG = LogFactory.getLog(ConnectionController.class);
    private static final String DRIVER = "com.mysql.jdbc.Driver";
    private static final String PROPS = "enableQueryTimeouts=false&autoReconnect=true";
    private static final Map<String, ConnectionPool> sessionPoolMap = new ConcurrentHashMap<String, ConnectionPool>();
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static String dbHost;
    private static int dbPort;

    public static void setHost(String value) {
        dbHost = value;
    }

    public static void setPort(int value) {
        dbPort = value;
    }

    private static String getHost() {
        return dbHost;
    }

    private static int getPort() {
        return dbPort;
    }

    static String getConnectionString(String host, int port, String db) {
        return String.format("jdbc:mysql://%s:%d/%s?%s", host, port, db, PROPS);
    }

    static String getConnectionString(String db) {
        return ConnectionController.getConnectionString(dbHost, dbPort, db);
    }

    public static void revalidate(String user, String pass, String sessionID) throws SQLException {
        ConnectionController.connectOnce(dbHost, dbPort, ConnectionController.getDBName(sessionID), user, pass);
    }

    public static Connection connectOnce(String host, int port, String db, String user, String pass) throws SQLException {
        block2: {
            try {
                Class.forName(DRIVER).newInstance();
            }
            catch (Exception ex) {
                if (!(ex instanceof ClassNotFoundException) && !(ex instanceof InstantiationException)) break block2;
                throw new SQLException("Unable to load MySQL driver.");
            }
        }
        return DriverManager.getConnection(ConnectionController.getConnectionString(host, port, db), user, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PooledConnection connectPooled(String sessID) throws SQLException, SessionExpiredException {
        Map<String, ConnectionPool> map = sessionPoolMap;
        synchronized (map) {
            if (!sessionPoolMap.containsKey(sessID)) {
                throw new SessionExpiredException();
            }
            ConnectionPool pool = sessionPoolMap.get(sessID);
            if (pool != null) {
                return pool.getConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet executeQuery(String sessID, String query) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            ResultSet resultSet = conn.executeQuery(query);
            return resultSet;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet executePreparedQuery(String sessID, String query, Object ... args) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            ResultSet resultSet = conn.executePreparedQuery(query, args);
            return resultSet;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUpdate(String sessID, String query) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.executeUpdate(query);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePreparedUpdate(String sessID, String query, Object ... args) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.executePreparedUpdate(query, args);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCredentials(String sessID, String user, String pass, String db) throws SQLException, RemoteException, Exception {
        ConnectionPool pool = new ConnectionPool(db, user, pass);
        LOG.debug((Object)String.format("sc=%s", pool));
        Map<String, ConnectionPool> map = sessionPoolMap;
        synchronized (map) {
            block10: {
                sessionPoolMap.put(sessID, pool);
                PooledConnection c = null;
                try {
                    c = pool.getConnection();
                    if (db == null || db.equals("")) break block10;
                    String dbVersion = SettingsManager.getInstance().getServerVersionWhenDatabaseCreated(sessID);
                    String serverVersion = VersionSettings.getVersionString();
                    LOG.info((Object)("Checking compatibility of database " + dbVersion + " to server " + serverVersion));
                    try {
                        if (!VersionSettings.isDatabaseCompatibleWithServer(dbVersion, serverVersion)) {
                            LOG.info((Object)("Database " + dbVersion + " and server " + serverVersion + " are NOT compatible"));
                            throw new Exception("Database (" + dbVersion + ") is not compatible with server (" + serverVersion + ")");
                        }
                        LOG.info((Object)("Database " + dbVersion + " and server " + serverVersion + " are compatible"));
                    }
                    catch (ParserConfigurationException e) {
                        throw new Exception("Problem checking compatibility between server and database");
                    }
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void switchDatabases(String sessID, String db) {
        Map<String, ConnectionPool> map = sessionPoolMap;
        synchronized (map) {
            sessionPoolMap.get(sessID).setDBName(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDBName(String sessID) {
        Map<String, ConnectionPool> map = sessionPoolMap;
        synchronized (map) {
            if (sessionPoolMap.get(sessID) == null) {
                throw new IllegalArgumentException("Can't fetch database name -- session expired or unregistered.");
            }
            return sessionPoolMap.get(sessID).getDBName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserForSession(String sessID) {
        Map<String, ConnectionPool> map = sessionPoolMap;
        synchronized (map) {
            return sessionPoolMap.get(sessID).getUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sessionExists(String sessID) {
        Map<String, ConnectionPool> map = sessionPoolMap;
        synchronized (map) {
            return sessionPoolMap.containsKey(sessID);
        }
    }

    public static synchronized void removeSession(String sessID) throws SQLException {
        executor.submit(new CloseConnectionWhenDone(sessID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getSessionIDs() {
        Map<String, ConnectionPool> map = sessionPoolMap;
        synchronized (map) {
            return sessionPoolMap.keySet();
        }
    }

    public static Collection<String> getDBNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ConnectionPool pool : sessionPoolMap.values()) {
            if (result.contains(pool.getDBName())) continue;
            result.add(pool.getDBName());
        }
        return result;
    }

    public static void registerAdditionalSessionForSession(String fromSessionID, String toSessionID) {
        ConnectionPool pool = sessionPoolMap.get(fromSessionID);
        sessionPoolMap.put(toSessionID, pool);
    }

    static {
        dbPort = -1;
    }

    private static class CloseConnectionWhenDone
    implements Callable<Boolean> {
        private final String sessionId;

        CloseConnectionWhenDone(String sessionId) {
            this.sessionId = sessionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            Map map = sessionPoolMap;
            synchronized (map) {
                if (sessionPoolMap.containsKey(this.sessionId)) {
                    ConnectionPool pool = (ConnectionPool)sessionPoolMap.remove(this.sessionId);
                    LOG.info((Object)("Unregistered session " + this.sessionId));
                    if (!sessionPoolMap.containsValue(pool)) {
                        pool.close();
                        LOG.info((Object)("Reaped connections for " + this.sessionId));
                    } else {
                        LOG.info((Object)("Connection pool still in use for " + this.sessionId + ", not reaping connections"));
                    }
                    LOG.info((Object)(sessionPoolMap.keySet().size() + " active sessions:"));
                    for (String id : sessionPoolMap.keySet()) {
                        LOG.info((Object)("\t" + id));
                    }
                }
            }
            return Boolean.TRUE;
        }
    }
}

