/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.db.variants.VariantManagerUtils;
import org.ut.biolab.medsavant.server.db.variants.annotation.BatchVariantAnnotator;
import org.ut.biolab.medsavant.server.log.EmailLogger;
import org.ut.biolab.medsavant.server.serverapi.LogManager;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Annotation;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;

public class VariantAnnotator
extends MedSavantServerJob
implements BasicVariantColumns {
    private static final Log LOG = LogFactory.getLog(VariantAnnotator.class);
    private final File inFile;
    private File outFile;
    private final String sessID;
    private final Annotation[] annotations;
    private final String baseDir;
    private final CustomField[] customFields;
    private Exception exception;
    private boolean success;
    private int numVariantsWritten = 0;

    public VariantAnnotator(String sessID, MedSavantServerJob parentJob, File inputFile, File outFile, Annotation[] annotations, CustomField[] customFields) throws FileNotFoundException, IOException {
        super(SessionManager.getInstance().getUserForSession(sessID), "VariantAnnotator", parentJob);
        this.inFile = inputFile;
        this.outFile = outFile;
        this.customFields = customFields;
        this.annotations = annotations;
        this.sessID = sessID;
        this.baseDir = outFile.getParentFile().getAbsolutePath();
    }

    public String getOutputFilePath() {
        return this.outFile.getAbsolutePath();
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean didSucceed() {
        return this.success;
    }

    public int getNumVariantsWritten() {
        return this.numVariantsWritten;
    }

    @Override
    public boolean run() {
        ArrayList<String> filesUsed = new ArrayList<String>();
        try {
            String inputFilePath = this.inFile.getAbsolutePath();
            filesUsed.add(inputFilePath);
            String workingFilePath = inputFilePath;
            try {
                LogManager.getInstance().addServerLog(this.sessID, LogManagerAdapter.LogType.INFO, "Annotating " + inputFilePath);
            }
            catch (RemoteException ex) {
            }
            catch (SessionExpiredException ex) {
                // empty catch block
            }
            this.getJobProgress().setMessage("Making room for annotations...");
            if (this.customFields.length > 0) {
                String customFieldFilename = workingFilePath + "_plusfields";
                filesUsed.add(customFieldFilename);
                VariantManagerUtils.addCustomVCFFields(workingFilePath, customFieldFilename, this.customFields, 16);
                File oldFile = new File(workingFilePath);
                oldFile.delete();
                workingFilePath = customFieldFilename;
            }
            this.getJobProgress().setMessage("Annotating...");
            if (this.annotations.length > 0) {
                String annotatedFilename = workingFilePath + "_annotated";
                filesUsed.add(annotatedFilename);
                long startTime = System.currentTimeMillis();
                BatchVariantAnnotator bva = new BatchVariantAnnotator(this.getJobProgress(), new File(workingFilePath), new File(annotatedFilename), this.annotations, this.sessID);
                bva.performBatchAnnotationInParallel();
                long endTime = System.currentTimeMillis();
                long duration = (endTime - startTime) / 1000L / 60L;
                LogManager.getInstance().addServerLog(this.sessID, LogManagerAdapter.LogType.INFO, "Completed annotation, taking " + duration + " minutes");
                LOG.info((Object)("Completed annotation, taking " + duration + " minutes"));
                VariantManagerUtils.logFileSize(annotatedFilename);
                workingFilePath = annotatedFilename;
                this.numVariantsWritten = bva.getTotalVariantsWritten();
            }
            this.outFile = new File(workingFilePath);
            this.success = true;
        }
        catch (Exception e) {
            try {
                LogManager.getInstance().addServerLog(this.sessID, LogManagerAdapter.LogType.ERROR, "Error running annotator on " + this.inFile.getAbsolutePath() + "." + ExceptionUtils.getStackTrace((Throwable)e));
            }
            catch (Exception exception) {
                // empty catch block
            }
            EmailLogger.logByEmail("Error running annotator on " + this.inFile.getAbsolutePath(), "Here is the object: " + this.toString() + ". Here is the message: " + ExceptionUtils.getStackTrace((Throwable)e));
            LOG.error((Object)e);
            e.printStackTrace();
            this.success = false;
            this.exception = e;
        }
        System.gc();
        return this.success;
    }
}

