/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.log.EmailLogger;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.server.vcf.VCFParser;
import org.ut.biolab.medsavant.shared.util.IOUtils;

public class VariantParser
extends MedSavantServerJob {
    private static final Log LOG = LogFactory.getLog(VariantParser.class);
    private final boolean includeHomoRef;
    private final int updateID;
    private final File vcfFile;
    private final BufferedReader reader;
    private final File outFile;
    private final int fileID;
    private boolean success = false;
    private Exception exception;
    private String sessID;
    private int numVariants;

    public VariantParser(String sessID, MedSavantServerJob parentJob, File vcfFile, File outFile, int updateID, int fileID, boolean includeHomoRef) throws FileNotFoundException, IOException {
        super(SessionManager.getInstance().getUserForSession(sessID), "VariantLoader", parentJob);
        this.vcfFile = vcfFile;
        this.outFile = outFile;
        this.fileID = fileID;
        this.updateID = updateID;
        this.includeHomoRef = includeHomoRef;
        this.sessID = sessID;
        this.reader = IOUtils.isGZipped(vcfFile) ? new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(vcfFile))) : new BufferedReader(new FileReader(vcfFile));
    }

    public File getVCF() {
        return this.vcfFile;
    }

    public String getOutputFilePath() {
        return this.outFile.getAbsolutePath();
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean didSucceed() {
        return this.success;
    }

    public int getNumVariants() {
        return this.numVariants;
    }

    public String toString() {
        return "VariantParser{includeHomoRef=" + this.includeHomoRef + ", updateID=" + this.updateID + ", vcfFile=" + this.vcfFile + ", reader=" + this.reader + ", outFile=" + this.outFile + ", fileID=" + this.fileID + ", success=" + this.success + ", exception=" + this.exception + '}';
    }

    @Override
    public boolean run() {
        try {
            VCFParser vcfParser = new VCFParser(this.sessID, this.vcfFile, this.getJobProgress());
            this.numVariants = vcfParser.parseVariantsFromReader(this.reader, this.outFile, this.updateID, this.fileID, this.includeHomoRef);
            this.success = true;
            LOG.info((Object)("VCF file " + this.vcfFile + " was successfully imported."));
            return true;
        }
        catch (Exception e) {
            EmailLogger.logByEmail("Error running parser on " + this.vcfFile.getAbsolutePath(), "Here is the object: " + this.toString() + ". Here is the message: " + ExceptionUtils.getStackTrace((Throwable)e));
            LOG.error((Object)e);
            this.success = false;
            this.exception = e;
            return false;
        }
    }
}

