/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants.annotation;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.IOJob;
import org.ut.biolab.medsavant.server.MedSavantIOController;
import org.ut.biolab.medsavant.server.db.variants.annotation.AnnotationCursor;
import org.ut.biolab.medsavant.server.serverapi.LogManager;
import org.ut.biolab.medsavant.shared.model.Annotation;
import org.ut.biolab.medsavant.shared.model.MedSavantServerJobProgress;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;
import org.ut.biolab.medsavant.shared.util.IOUtils;

public class BatchVariantAnnotator {
    private static final Log LOG = LogFactory.getLog(BatchVariantAnnotator.class);
    private File inputTDFFile;
    private File outputTDFFile;
    private final Annotation[] annotations;
    private final String sid;
    private int totalNumLinesRead;
    private int totalNumVariantsWritten = 0;
    private int totalNumWarnings;
    private MedSavantServerJobProgress jobProgress;
    private int PROGRESS_STEP_SIZE = 10;

    public int getTotalVariantsWritten() {
        return this.totalNumVariantsWritten;
    }

    public BatchVariantAnnotator(MedSavantServerJobProgress jobProgress, File inputFile, File outputFile, Annotation[] annotations, String sid) throws RemoteException, SQLException {
        this.inputTDFFile = inputFile;
        this.outputTDFFile = outputFile;
        this.sid = sid;
        this.annotations = annotations;
        this.jobProgress = jobProgress;
    }

    private int logProgress(int totalNumLinesRead, int numLines, int oldp) {
        int x = Math.round((float)totalNumLinesRead / (float)numLines * 100.0f);
        if (x - oldp >= this.PROGRESS_STEP_SIZE) {
            oldp = x;
            LOG.info((Object)("\t" + oldp + "% (" + totalNumLinesRead + " of " + numLines + " lines)"));
        }
        return oldp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBatchAnnotationInParallel() throws IOException, SQLException, SessionExpiredException, IllegalArgumentException {
        LogManager.getInstance().addServerLog(this.sid, LogManagerAdapter.LogType.INFO, "Annotation of " + this.inputTDFFile.getAbsolutePath() + " was started. " + this.annotations.length + " annotation(s) will be performed.");
        LOG.info((Object)("Annotation of " + this.inputTDFFile.getAbsolutePath() + " was started. " + this.annotations.length + " annotation(s) will be performed."));
        CSVReader recordReader = null;
        CSVWriter recordWriter = null;
        AnnotationCursor[] cursors = null;
        try {
            if (this.annotations.length == 0) {
                this.jobProgress.setMessage("No annotations to perform, processing intermediate files");
                MedSavantIOController.requestIO(new IOJob("Copy File"){

                    @Override
                    protected void doIO() throws IOException {
                        IOUtils.copyFile(BatchVariantAnnotator.this.inputTDFFile, BatchVariantAnnotator.this.outputTDFFile);
                    }
                });
                return;
            }
            this.jobProgress.setMessage("Performing " + this.annotations.length + " annotations");
            LOG.info((Object)("Performing " + this.annotations.length + " annotations"));
            int numFieldsInInputFile = BatchVariantAnnotator.getNumFieldsInTDF(this.inputTDFFile);
            if (numFieldsInInputFile == 0) {
                LogManager.getInstance().addServerLog(this.sid, LogManagerAdapter.LogType.ERROR, "Error parsing input file " + this.inputTDFFile.getAbsolutePath() + " . Is it tab delimited?");
                throw new IOException("Error parsing input file. Is it tab delimited?");
            }
            int numFieldsInOutputFile = numFieldsInInputFile;
            cursors = new AnnotationCursor[this.annotations.length];
            for (int i = 0; i < this.annotations.length; ++i) {
                AnnotationCursor ac = new AnnotationCursor(this.sid, this.annotations[i]);
                numFieldsInOutputFile += ac.getNumNonDefaultFields();
                cursors[i] = ac;
            }
            final int[] numlines = new int[1];
            MedSavantIOController.requestIO(new IOJob("Line counter"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doIO() throws IOException {
                    BatchVariantAnnotator.this.jobProgress.setMessage("Counting number of variants to annotate");
                    int numLines = 0;
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new FileReader(BatchVariantAnnotator.this.inputTDFFile));
                        while (reader.readLine() != null) {
                            ++numLines;
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    numlines[0] = numLines;
                }
            });
            recordReader = new CSVReader((Reader)new FileReader(this.inputTDFFile), "\t".charAt(0), '\"', '\\');
            recordWriter = new CSVWriter((Writer)new FileWriter(this.outputTDFFile), "\t".charAt(0), '\"', "\r\n");
            MedSavantIOController.requestIO(new VariantAnnotatorIOJob(cursors, recordReader, recordWriter, numlines[0], numFieldsInOutputFile));
            LogManager.getInstance().addServerLog(this.sid, LogManagerAdapter.LogType.INFO, "Annotation of " + this.inputTDFFile.getAbsolutePath() + " completed. " + this.annotations.length + " annotations were performed.");
            LOG.info((Object)("Annotation of " + this.inputTDFFile.getAbsolutePath() + " completed. " + this.annotations.length + " annotations were performed."));
        }
        catch (InterruptedException ie) {
            LogManager.getInstance().addServerLog(this.sid, LogManagerAdapter.LogType.ERROR, "Error performing annotation(s). " + ie.getLocalizedMessage());
            LOG.error((Object)("performBatchAnnotationInParallell interrupted: " + ie));
        }
        finally {
            try {
                if (recordReader != null) {
                    recordReader.close();
                }
                if (recordWriter != null) {
                    recordWriter.close();
                }
                this.inputTDFFile.delete();
            }
            catch (NullPointerException nex) {
                LOG.error((Object)"Caught nullpointerexception ");
                nex.printStackTrace();
            }
        }
    }

    private static String[] readNext(CSVReader recordReader) throws IOException {
        String[] line = recordReader.readNext();
        if (line == null) {
            return null;
        }
        line[line.length - 1] = BatchVariantAnnotator.removeNewLinesAndCarriageReturns(line[line.length - 1]);
        return line;
    }

    private static String removeNewLinesAndCarriageReturns(String line) {
        line = line.replaceAll("\n", "");
        line = line.replaceAll("\r", "");
        return line;
    }

    private static int getNumFieldsInTDF(File file) throws FileNotFoundException, IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(file), "\t".charAt(0), '\"', '\\');
        String[] next = reader.readNext();
        if (next == null) {
            throw new IOException("Error determining number of columns in the annotation file.");
        }
        int result = next.length;
        reader.close();
        return result;
    }

    private boolean isAStandardSingleNucleotide(String base) {
        return base.equals("A") || base.equals("C") || base.equals("G") || base.equals("T");
    }

    class VariantAnnotatorIOJob
    extends IOJob {
        private final int NUM_VARIANTS_BEFORE_MSG = 10000;
        private String[] inputLine;
        private String[][] outputAnnotations;
        private final AnnotationCursor[] cursors;
        private final CSVReader recordReader;
        private final CSVWriter recordWriter;
        private List<SimpleVariantRecord> variantWindow;
        private long minStart;
        private long maxStart;
        private int numFieldsInOutputFile;
        private final int numLines;
        private long variantsAnnotated;
        private long prevVariantsAnnotated;
        private int vps;
        private long startTime;
        private String vstr;
        private int numLd;
        private int numHd;
        private static final double DENSITY_THRESHOLD = (double)5.0E-4f;

        public VariantAnnotatorIOJob(AnnotationCursor[] cursors, CSVReader recordReader, CSVWriter recordWriter, int numLines, int numFieldsInOutputFile) {
            super("Variant annotator");
            this.NUM_VARIANTS_BEFORE_MSG = 10000;
            this.minStart = Long.MAX_VALUE;
            this.maxStart = Long.MIN_VALUE;
            this.numFieldsInOutputFile = 0;
            this.variantsAnnotated = 0L;
            this.prevVariantsAnnotated = 0L;
            this.vps = -1;
            this.startTime = 0L;
            this.vstr = "";
            this.numLd = 0;
            this.numHd = 0;
            LOG.info((Object)"Annotation started...");
            BatchVariantAnnotator.this.jobProgress.setMessage("Starting annotation...");
            this.cursors = cursors;
            this.recordReader = recordReader;
            this.recordWriter = recordWriter;
            this.numLines = numLines;
            this.numFieldsInOutputFile = numFieldsInOutputFile;
            this.variantWindow = new LinkedList<SimpleVariantRecord>();
            this.startTime = System.currentTimeMillis();
        }

        boolean isLowDensity(List<SimpleVariantRecord> variantWindow) {
            return (double)variantWindow.size() / 20000.0 <= (double)5.0E-4f;
        }

        @Override
        protected boolean continueIO() throws IOException {
            this.inputLine = BatchVariantAnnotator.readNext(this.recordReader);
            return this.inputLine != null;
        }

        private void annotateWindow() throws IllegalArgumentException {
            try {
                if (this.variantWindow.isEmpty()) {
                    return;
                }
                boolean ofs = false;
                boolean ld = this.isLowDensity(this.variantWindow);
                if (ld) {
                    ++this.numLd;
                } else {
                    ++this.numHd;
                }
                for (int annotationIndex = 0; annotationIndex < BatchVariantAnnotator.this.annotations.length; ++annotationIndex) {
                    if (this.cursors[annotationIndex].annotateVariants(this.variantWindow, this.minStart, this.maxStart, annotationIndex, ld)) continue;
                    LogManager.getInstance().addServerLog(BatchVariantAnnotator.this.sid, LogManagerAdapter.LogType.WARNING, BatchVariantAnnotator.this.inputTDFFile.getName() + "Cannot annotate chromosome " + this.variantWindow.get((int)0).chrom + " with annotation " + BatchVariantAnnotator.this.annotations[annotationIndex]);
                }
                for (SimpleVariantRecord svr : this.variantWindow) {
                    this.recordWriter.writeNext(svr.getLineWithAnnotations(this.cursors));
                    BatchVariantAnnotator.this.totalNumVariantsWritten++;
                }
                long previous = this.variantsAnnotated;
                this.variantsAnnotated += (long)this.variantWindow.size();
                SimpleVariantRecord lv = this.variantWindow.get(this.variantWindow.size() - 1);
                String s = BatchVariantAnnotator.this.inputTDFFile.getName() + ": Annotated " + this.variantsAnnotated + " variants so far (#sparse/dense regions=" + this.numLd + "/" + this.numHd + ").  Chrom=" + lv.chrom + " Position=" + lv.start;
                if (Math.floor((double)this.variantsAnnotated / 10000.0) - Math.floor((double)previous / 10000.0) >= 1.0) {
                    if (this.prevVariantsAnnotated > 0L) {
                        this.vps = (int)Math.round((double)(this.variantsAnnotated - this.prevVariantsAnnotated) / ((double)(System.currentTimeMillis() - this.startTime) / 1000.0));
                    }
                    if (this.vps > 0) {
                        this.vstr = " (" + this.vps + " variants/sec)";
                    }
                    this.prevVariantsAnnotated = this.variantsAnnotated;
                    this.startTime = System.currentTimeMillis();
                    LogManager.getInstance().addServerLog(BatchVariantAnnotator.this.sid, LogManagerAdapter.LogType.INFO, s + this.vstr);
                }
                BatchVariantAnnotator.this.jobProgress.setMessage(s + this.vstr);
            }
            catch (Exception ex) {
                LOG.error((Object)("Couldn't communicate progress message to user: " + ex));
                ex.printStackTrace();
            }
        }

        @Override
        protected void finish() throws IOException {
            this.annotateWindow();
            for (AnnotationCursor cursor : this.cursors) {
                cursor.cleanup();
            }
            BatchVariantAnnotator.this.jobProgress.setMessage("Finished.");
        }

        @Override
        protected void doIO() throws IOException {
            try {
                boolean chromMismatch = false;
                SimpleVariantRecord nextInputRecord = new SimpleVariantRecord(this.inputLine, this.cursors.length);
                if (!this.variantWindow.isEmpty()) {
                    SimpleVariantRecord firstInWindow = this.variantWindow.get(0);
                    if (nextInputRecord.start - firstInWindow.start > 20000L || !nextInputRecord.chrom.equals(firstInWindow.chrom)) {
                        this.annotateWindow();
                        this.variantWindow.clear();
                        this.minStart = Long.MAX_VALUE;
                        this.maxStart = Long.MIN_VALUE;
                    }
                }
                this.variantWindow.add(nextInputRecord);
                this.minStart = Math.min(nextInputRecord.start, this.minStart);
                this.maxStart = Math.max(nextInputRecord.start, this.maxStart);
            }
            catch (IllegalArgumentException iex) {
                LOG.error((Object)iex);
            }
        }
    }

    static class SimpleVariantRecord {
        public static final String NULL_VALUE = "\\N";
        public static final int INITIAL_NUMBER_OF_ANNOTATIONS = 10;
        public static final int VARIANT_INDEX_OF_CHR = 4;
        public static final int VARIANT_INDEX_OF_START = 5;
        public static final int VARIANT_INDEX_OF_END = 6;
        public static final int VARIANT_INDEX_OF_REF = 8;
        public static final int VARIANT_INDEX_OF_ALT = 9;
        public String chrom;
        public long start;
        public long end;
        public String ref;
        public String alt;
        public final String[] line;
        public String[][] annotations = null;

        public String[] getLineWithAnnotations(AnnotationCursor[] cursors) {
            int ndf = 0;
            for (int i = 0; i < this.annotations.length; ++i) {
                ndf += cursors[i].getNumNonDefaultFields();
            }
            Object[] flattenedAnnotations = new String[ndf];
            int k = 0;
            for (int i = 0; i < this.annotations.length; ++i) {
                int j;
                if (this.annotations[i] != null) {
                    for (j = 0; j < cursors[i].getNumNonDefaultFields(); ++j) {
                        flattenedAnnotations[k++] = this.annotations[i][j].trim().length() > 0 ? this.annotations[i][j] : NULL_VALUE;
                    }
                    continue;
                }
                for (j = 0; j < cursors[i].getNumNonDefaultFields(); ++j) {
                    flattenedAnnotations[k++] = NULL_VALUE;
                }
            }
            return (String[])ArrayUtils.addAll((Object[])this.line, (Object[])flattenedAnnotations);
        }

        public void annotate(int annotationIndex, String[] annotation) {
            this.annotations[annotationIndex] = annotation;
        }

        public SimpleVariantRecord(String[] line, int numAnnotations) throws IllegalArgumentException {
            this.line = line;
            this.annotations = new String[numAnnotations][];
            this.setFromLine(line);
        }

        private void setFromLine(String[] line) throws IllegalArgumentException {
            this.chrom = line[4];
            String startString = line[5];
            String endString = line[6];
            try {
                this.start = Long.parseLong(startString);
                this.end = Long.parseLong(endString);
            }
            catch (NumberFormatException nex) {
                throw new NumberFormatException("Start or End Position is not an integer. Strings were '" + line[5] + "', '" + line[6] + "' Message: " + nex.getMessage() + "\n");
            }
            this.ref = line[8];
            this.alt = line[9];
            if (this.start == this.end && this.ref.equals("-")) {
                this.alt = "0" + this.alt;
            } else if (this.alt.equals("-")) {
                this.alt = Long.toString(this.end - this.start + 1L);
            } else if (this.end > this.start || this.start == this.end && this.alt.length() > 1) {
                this.alt = Long.toString(this.end - this.start + 1L) + this.alt;
            }
        }

        public String toString() {
            return "SimpleVariantRecord{chrom=" + this.chrom + ", start=" + this.start + ", ref=" + this.ref + ", alt=" + this.alt + '}';
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleVariantRecord other = (SimpleVariantRecord)obj;
            if (this.chrom == null ? other.chrom != null : !this.chrom.equals(other.chrom)) {
                return false;
            }
            if (this.start != other.start) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
                return false;
            }
            return !(this.alt == null ? other.alt != null : !this.alt.equals(other.alt));
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + (this.chrom != null ? this.chrom.hashCode() : 0);
            int low = (int)(this.start & 0xFFFFFFFFL);
            hash = 79 * hash + (int)(this.start & 0xFFFFFFFFL) + (int)(this.start >> 32 & 0xFFFFFFFFL);
            hash = 79 * hash + (int)(this.end & 0xFFFFFFFFL) + (int)(this.end >> 32 & 0xFFFFFFFFL);
            hash = 79 * hash + (this.ref != null ? this.ref.hashCode() : 0);
            hash = 79 * hash + (this.alt != null ? this.alt.hashCode() : 0);
            return hash;
        }
    }
}

