/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.model.GeneralLog;
import org.ut.biolab.medsavant.shared.model.MedSavantServerJobProgress;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;

public class LogManager
extends MedSavantServerUnicastRemoteObject
implements LogManagerAdapter {
    private static final Log LOG = LogFactory.getLog(LogManager.class);
    private static LogManager instance;

    private LogManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized LogManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new LogManager();
        }
        return instance;
    }

    @Override
    public List<GeneralLog> getServerLog(String sid, int start, int limit) throws SQLException, SessionExpiredException {
        return this.getServerLogForUser(sid, null, start, limit);
    }

    @Override
    public int getServerLogSize(String sid) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ServerLogTableSchema table = MedSavantDatabase.ServerlogTableSchema;
        return LogManager.getLogSize(sid, table, BinaryConditionMS.equalTo(table.getDBColumn("user"), "server"));
    }

    private static int getLogSize(String sid, TableSchema table, Condition c) throws SQLException, SessionExpiredException {
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addCustomColumns(FunctionCall.countAll());
        if (c != null) {
            query.addCondition(c);
        }
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        rs.next();
        return rs.getInt(1);
    }

    public void addServerLog(String sid, LogManagerAdapter.LogType t, String description) throws SessionExpiredException, RemoteException {
        this.addLog(sid, t, description);
    }

    public void addLog(String sessID, LogManagerAdapter.LogType type, String desc) throws SessionExpiredException, RemoteException {
        try {
            Timestamp sqlDate = new Timestamp(new java.util.Date().getTime());
            MedSavantDatabase.ServerLogTableSchema table = MedSavantDatabase.ServerlogTableSchema;
            InsertQuery query = new InsertQuery(table.getTable());
            query.addColumn(table.getDBColumn("user"), SessionManager.getInstance().getUserForSession(sessID));
            query.addColumn(table.getDBColumn("event"), type.toString());
            query.addColumn(table.getDBColumn("description"), desc);
            query.addColumn(table.getDBColumn("timestamp"), sqlDate);
            ConnectionController.executeUpdate(sessID, query.toString());
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error writing to server log.", (Throwable)ex);
        }
    }

    @Override
    public Date getDateOfLastServerLog(String sid) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ServerLogTableSchema table = MedSavantDatabase.ServerlogTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("timestamp"));
        query.addCondition(BinaryCondition.equalTo(table.getDBColumn("user"), "server"));
        query.addOrdering(table.getDBColumn("timestamp"), OrderObject.Dir.DESCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString() + " LIMIT 1");
        if (rs.next()) {
            Date d = new Date(rs.getTimestamp(1).getTime());
            return d;
        }
        return null;
    }

    @Override
    public List<GeneralLog> getServerLogForUserWithSessionID(String sid, int start, int limit) throws SQLException, RemoteException, SessionExpiredException {
        return this.getServerLogForUser(sid, SessionManager.getInstance().getUserForSession(sid), start, limit);
    }

    private List<GeneralLog> getServerLogForUser(String sid, String userForSession, int start, int limit) throws SQLException, SessionExpiredException {
        MedSavantDatabase.ServerLogTableSchema table = MedSavantDatabase.ServerlogTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addAllColumns();
        if (userForSession != null) {
            query.addCondition(BinaryCondition.equalTo(table.getDBColumn("user"), userForSession));
        }
        query.addOrdering(table.getDBColumn("timestamp"), OrderObject.Dir.DESCENDING);
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString() + " LIMIT " + start + "," + limit);
        ArrayList<GeneralLog> result = new ArrayList<GeneralLog>();
        while (rs.next()) {
            result.add(new GeneralLog(rs.getString("user"), rs.getString("event"), rs.getString("description"), rs.getTimestamp("timestamp")));
        }
        return result;
    }

    @Override
    public List<MedSavantServerJobProgress> getJobProgressForUserWithSessionID(String sid) throws SQLException, RemoteException, SessionExpiredException {
        String userId = SessionManager.getInstance().getUserForSession(sid);
        return MedSavantServerJob.getJobProgressesForUser(userId);
    }
}

