/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.server.serverapi.SettingsManager;
import org.ut.biolab.medsavant.shared.format.UserRole;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.UserLevel;
import org.ut.biolab.medsavant.shared.model.exception.UnauthorizedException;
import org.ut.biolab.medsavant.shared.serverapi.UserManagerAdapter;

public class UserManager
extends MedSavantServerUnicastRemoteObject
implements UserManagerAdapter {
    private static final Log LOG = LogFactory.getLog(UserManager.class);
    private static final String DATABASE_USER_KEY_PREFIX = "_dbuser_";
    private static UserManager instance;

    public static synchronized UserManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new UserManager();
        }
        return instance;
    }

    private UserManager() throws RemoteException, SessionExpiredException {
    }

    private boolean checkAdmin(String sessID) throws SecurityException, RemoteException, SessionExpiredException, SQLException {
        String thisUser = SessionManager.getInstance().getUserForSession(sessID);
        String thisDatabase = SessionManager.getInstance().getDatabaseForSession(sessID);
        if (!this.isAdmin(sessID)) {
            String err = "Cannot add role to user.  This requires " + thisUser + " to have administrative privileges";
            LOG.error((Object)err);
            throw new SecurityException(err);
        }
        if (!this.isUserOfThisDatabase(sessID)) {
            String err = "Cannot add role to user.  The current user " + thisUser + " is not a user of " + thisDatabase;
            LOG.error((Object)err);
            throw new SecurityException(err);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<UserRole> getRolesForUser(String sessID, String user) throws RemoteException, SQLException, SessionExpiredException {
        String database = SessionManager.getInstance().getDatabaseForSession(sessID);
        MedSavantDatabase.UserRoleTableSchema roleTable = MedSavantDatabase.UserRoleTableSchema;
        MedSavantDatabase.UserRoleAssignmentTableSchema roleATable = MedSavantDatabase.UserRoleAssignmentTableSchema;
        SelectQuery sq = new SelectQuery();
        Column[] columnArray = new Column[3];
        columnArray[0] = roleTable.getDBColumn("user_role_id");
        columnArray[1] = roleTable.getDBColumn("role_name");
        columnArray[2] = roleTable.getDBColumn("role_description");
        sq.addColumns(columnArray);
        BinaryCondition joinCondition = BinaryCondition.equalTo(roleTable.getDBColumn("user_role_id"), roleATable.getDBColumn("fk_user_role_id"));
        sq.addJoin(SelectQuery.JoinType.INNER, roleTable.getTable(), roleATable.getTable(), joinCondition);
        sq.addCondition(BinaryCondition.equalTo(roleATable.getDBColumn("user"), user));
        ResultSet rs = null;
        try {
            rs = ConnectionController.executeQuery(sessID, sq.toString());
            HashSet<UserRole> roleSet = new HashSet<UserRole>();
            while (rs.next()) {
                int roleId = rs.getInt(1);
                String roleName = rs.getString(2);
                String roleDescription = rs.getString(3);
                roleSet.add(new UserRole(roleId, roleName, roleDescription, database));
            }
            HashSet<UserRole> hashSet = roleSet;
            return hashSet;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public boolean checkRole(String sessID, UserRole role) throws RemoteException, SQLException, SessionExpiredException {
        Set<UserRole> assignedRoles = this.getRolesForUser(sessID, SessionManager.getInstance().getUserForSession(sessID));
        return assignedRoles.contains(role);
    }

    public boolean checkAllRoles(String sessID, Set<UserRole> roles) throws RemoteException, SQLException, SessionExpiredException {
        if (roles.isEmpty()) {
            throw new IllegalArgumentException("Can't check empty role");
        }
        Set<UserRole> assignedRoles = this.getRolesForUser(sessID, SessionManager.getInstance().getUserForSession(sessID));
        return !assignedRoles.isEmpty() && assignedRoles.containsAll(roles);
    }

    public boolean checkAnyRole(String sessID, Set<UserRole> roles) throws RemoteException, SQLException, SessionExpiredException {
        if (roles.isEmpty()) {
            throw new IllegalArgumentException("Can't check empty role");
        }
        Set<UserRole> assignedRoles = this.getRolesForUser(sessID, SessionManager.getInstance().getUserForSession(sessID));
        if (!assignedRoles.isEmpty()) {
            for (UserRole role : roles) {
                if (!assignedRoles.contains(role)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UserRole> getAllRoles(String sessID) throws RemoteException, SQLException, SecurityException, SessionExpiredException {
        String thisDatabase = SessionManager.getInstance().getDatabaseForSession(sessID);
        MedSavantDatabase.UserRoleTableSchema roleTable = MedSavantDatabase.UserRoleTableSchema;
        SelectQuery sq = new SelectQuery();
        sq.addFromTable(roleTable.getTable());
        Column[] columnArray = new Column[3];
        columnArray[0] = roleTable.getDBColumn("user_role_id");
        columnArray[1] = roleTable.getDBColumn("role_name");
        columnArray[2] = roleTable.getDBColumn("role_description");
        sq.addColumns(columnArray);
        sq.setIsDistinct(true);
        ResultSet rs = null;
        try {
            rs = ConnectionController.executeQuery(sessID, sq.toString());
            TreeSet<UserRole> roleSet = new TreeSet<UserRole>();
            while (rs.next()) {
                int roleId = rs.getInt(1);
                String roleName = rs.getString(2);
                String roleDescription = rs.getString(3);
                roleSet.add(new UserRole(roleId, roleName, roleDescription, thisDatabase));
            }
            TreeSet<UserRole> treeSet = roleSet;
            return treeSet;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserRole getRoleByName(String sessID, String roleName) throws RemoteException, SessionExpiredException, SQLException {
        String thisDatabase = SessionManager.getInstance().getDatabaseForSession(sessID);
        MedSavantDatabase.UserRoleTableSchema roleTable = MedSavantDatabase.UserRoleTableSchema;
        SelectQuery sq = new SelectQuery();
        sq.addFromTable(roleTable.getTable());
        sq.addAllColumns();
        sq.addCondition(BinaryCondition.equalTo(roleTable.getDBColumn("role_name"), roleName));
        ResultSet rs = null;
        try {
            rs = ConnectionController.executeQuery(sessID, sq.toString());
            if (rs.next()) {
                int roleId = rs.getInt(1);
                String name = rs.getString(2);
                String roleDescription = rs.getString(3);
                UserRole userRole = new UserRole(roleId, name, roleDescription, thisDatabase);
                return userRole;
            }
            UserRole userRole = null;
            return userRole;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserRole addRole(String sessID, String roleName, String roleDescription) throws RemoteException, SessionExpiredException, SQLException, SecurityException {
        String thisDatabase = SessionManager.getInstance().getDatabaseForSession(sessID);
        this.checkAdmin(sessID);
        Set<UserRole> roles = this.getAllRoles(sessID);
        for (UserRole r : roles) {
            if (!r.getDatabase().equals(thisDatabase) || !r.getRoleName().equals(roleName)) continue;
            return r;
        }
        MedSavantDatabase.UserRoleTableSchema roleTable = MedSavantDatabase.UserRoleTableSchema;
        InsertQuery iq = new InsertQuery(roleTable.getTableName());
        iq.addColumn(roleTable.getDBColumn("role_name"), roleName);
        iq.addColumn(roleTable.getDBColumn("role_description"), roleDescription);
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        PreparedStatement stmt = null;
        ResultSet res = null;
        int roleId = -1;
        try {
            stmt = conn.prepareStatement(iq.toString(), 1);
            stmt.execute();
            res = stmt.getGeneratedKeys();
            res.next();
            roleId = res.getInt(1);
            UserRole userRole = new UserRole(roleId, roleName, roleDescription, thisDatabase);
            return userRole;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (res != null) {
                res.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public void dropRolesForUser(String sessID, String user, Set<UserRole> roles) throws RemoteException, SessionExpiredException, SQLException, SecurityException {
        this.checkAdmin(sessID);
        Set<UserRole> assignedRoles = this.getRolesForUser(sessID, user);
        if (assignedRoles.containsAll(roles)) {
            return;
        }
        if (assignedRoles.size() > 0) {
            roles.removeAll(assignedRoles);
        }
        MedSavantDatabase.UserRoleAssignmentTableSchema raTable = MedSavantDatabase.UserRoleAssignmentTableSchema;
        for (UserRole role : roles) {
            DeleteQuery dq = new DeleteQuery(raTable.getTableName());
            dq.addCondition(BinaryCondition.equalTo(raTable.getDBColumn("user"), user));
            dq.addCondition(BinaryCondition.equalTo(raTable.getDBColumn("fk_user_role_id"), role.getRoleId()));
            ConnectionController.executeUpdate(sessID, dq.toString());
        }
    }

    @Override
    public void registerRoleForUser(String sessID, String user, Set<UserRole> roles) throws RemoteException, SessionExpiredException, SQLException, SecurityException {
        this.checkAdmin(sessID);
        Set<UserRole> assignedRoles = this.getRolesForUser(sessID, user);
        if (assignedRoles.containsAll(roles)) {
            return;
        }
        if (assignedRoles.size() > 0) {
            roles.removeAll(assignedRoles);
        }
        MedSavantDatabase.UserRoleAssignmentTableSchema raTable = MedSavantDatabase.UserRoleAssignmentTableSchema;
        for (UserRole role : roles) {
            InsertQuery iq = new InsertQuery(raTable.getTableName());
            iq.addColumn(raTable.getDBColumn("fk_user_role_id"), role.getRoleId());
            iq.addColumn(raTable.getDBColumn("user"), user);
            ConnectionController.executeUpdate(sessID, iq.toString());
        }
    }

    @Override
    public Set<UserRole> getUserRoles(String sessID, String user) throws RemoteException, SessionExpiredException, SQLException, SecurityException {
        String thisUser = SessionManager.getInstance().getUserForSession(sessID);
        String thisDatabase = SessionManager.getInstance().getDatabaseForSession(sessID);
        if (!this.isUserOfThisDatabase(sessID)) {
            LOG.error((Object)("User " + thisUser + " is not a member of the database " + thisDatabase + ", and can't query roles for user " + user));
            throw new SecurityException("Can't get roles for user " + user + " on this database.  User making request is not a user of this database.");
        }
        if (user.equals(thisUser) || this.isAdmin(sessID)) {
            return this.getRolesForUser(sessID, user);
        }
        String err = "User " + user + " does not have administrative permission to request roles available for user " + user;
        LOG.error((Object)err);
        throw new SecurityException(err);
    }

    @Override
    public Set<UserRole> getRolesForUser(String sessID) throws SQLException, SessionExpiredException, RemoteException {
        return this.getRolesForUser(sessID, SessionManager.getInstance().getUserForSession(sessID));
    }

    public Set<String> getAllUserNames(String sessID) throws SQLException, SessionExpiredException {
        HashSet<String> results = new HashSet<String>();
        ResultSet rs = ConnectionController.executePreparedQuery(sessID, "SELECT DISTINCT user FROM mysql.user", new Object[0]);
        while (rs.next()) {
            String user = rs.getString(1);
            results.add(user);
        }
        return results;
    }

    @Override
    public String[] getUserNames(String sessID) throws SQLException, SessionExpiredException {
        Map<String, String> validUsers = null;
        try {
            validUsers = SettingsManager.getInstance().getSettingsForKeyPrefix(sessID, DATABASE_USER_KEY_PREFIX);
        }
        catch (RemoteException re) {
            throw new SQLException("Unable to find valid users for this database ", re);
        }
        if (validUsers == null) {
            return new String[0];
        }
        Set<String> users = this.getAllUserNames(sessID);
        ArrayList<String> results = new ArrayList<String>();
        for (String user : users) {
            if (!validUsers.containsKey(user) || user.equalsIgnoreCase("root")) continue;
            results.add(user);
        }
        return results.toArray(new String[0]);
    }

    public boolean isUserOfThisDatabase(String sessID) throws SQLException, SessionExpiredException, RemoteException {
        String[] users;
        String thisUser = SessionManager.getInstance().getUserForSession(sessID);
        for (String user : users = this.getUserNames(sessID)) {
            if (!user.equalsIgnoreCase(thisUser)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean userExists(String sessID, String user) throws SQLException, SessionExpiredException {
        return ConnectionController.executePreparedQuery(sessID, "SELECT user FROM mysql.user WHERE user=?;", user).next();
    }

    @Override
    public synchronized void addUser(String sessID, String user, char[] pass, UserLevel level) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            if (user.startsWith(DATABASE_USER_KEY_PREFIX)) {
                throw new SQLException("Can't create user " + user + " -- illegal username");
            }
            conn.setAutoCommit(false);
            conn.executePreparedUpdate("CREATE USER ?@'localhost' IDENTIFIED BY ?", user, new String(pass));
            this.grantPrivileges(sessID, user, level);
            conn.commit();
        }
        catch (SQLException sqlx) {
            try {
                conn.rollback();
                throw sqlx;
            }
            catch (Throwable throwable) {
                for (int i = 0; i < pass.length; ++i) {
                    pass[i] = '\u0000';
                }
                conn.setAutoCommit(true);
                conn.close();
                throw throwable;
            }
        }
        for (int i = 0; i < pass.length; ++i) {
            pass[i] = '\u0000';
        }
        conn.setAutoCommit(true);
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void changePassword(String sessID, String userName, char[] oldPass, char[] newPass) throws SQLException, RemoteException, SessionExpiredException {
        int i;
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.setAutoCommit(true);
            ConnectionController.revalidate(userName, new String(oldPass), sessID);
            conn.executePreparedUpdate("SET PASSWORD FOR ?@'localhost' = PASSWORD(?)", userName, new String(newPass));
        }
        catch (Throwable throwable) {
            int i2;
            for (i2 = 0; i2 < oldPass.length; ++i2) {
                oldPass[i2] = '\u0000';
            }
            for (i2 = 0; i2 < newPass.length; ++i2) {
                newPass[i2] = '\u0000';
            }
            conn.close();
            throw throwable;
        }
        for (i = 0; i < oldPass.length; ++i) {
            oldPass[i] = '\u0000';
        }
        for (i = 0; i < newPass.length; ++i) {
            newPass[i] = '\u0000';
        }
        conn.close();
    }

    @Override
    public void grantPrivileges(String sessID, String name, UserLevel level) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            String dbName = ConnectionController.getDBName(sessID);
            LOG.info((Object)("Granting " + (Object)((Object)level) + " privileges to " + name + " on " + dbName + "..."));
            switch (level) {
                case ADMIN: {
                    conn.executePreparedUpdate("GRANT ALTER, RELOAD, CREATE, CREATE VIEW, CREATE TEMPORARY TABLES, CREATE USER, DELETE, DROP, FILE, GRANT OPTION, INSERT, SELECT, UPDATE ON *.* TO ?@'localhost'", name);
                    conn.executePreparedUpdate(String.format("GRANT GRANT OPTION ON %s.* TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate(String.format("GRANT ALTER, CREATE, CREATE VIEW, CREATE TEMPORARY TABLES, DELETE, DROP, INSERT, SELECT, UPDATE ON %s.* TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate("GRANT SELECT ON mysql.user TO ?@'localhost'", name);
                    conn.executePreparedUpdate("GRANT SELECT ON mysql.db TO ?@'localhost'", name);
                    break;
                }
                case USER: {
                    conn.executePreparedUpdate(String.format("GRANT CREATE TEMPORARY TABLES, SELECT ON %s.* TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate(String.format("GRANT SELECT,INSERT,UPDATE,DELETE ON %s.region_set TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate(String.format("GRANT SELECT,INSERT,UPDATE,DELETE ON %s.region_set_membership TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate(String.format("GRANT INSERT,SELECT,UPDATE,DELETE ON %s.cohort TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate(String.format("GRANT INSERT,SELECT,UPDATE,DELETE ON %s.cohort_membership TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate("GRANT SELECT (user, Create_user_priv) ON mysql.user TO ?@'localhost'", name);
                    conn.executePreparedUpdate("GRANT SELECT (user, Create_tmp_table_priv) ON mysql.db TO ?@'localhost'", name);
                    conn.executePreparedUpdate("GRANT FILE ON *.* TO ?@'localhost'", name);
                    break;
                }
                case GUEST: {
                    conn.executePreparedUpdate(String.format("GRANT SELECT ON %s.* TO ?@'localhost'", dbName), name);
                    conn.executePreparedUpdate("GRANT SELECT (user, Create_user_priv) ON mysql.user TO ?@'localhost'", name);
                    conn.executePreparedUpdate("GRANT SELECT (user, Create_tmp_table_priv) ON mysql.db TO ?@'localhost'", name);
                    conn.executePreparedUpdate("GRANT FILE ON *.* TO ?@'localhost'", name);
                }
            }
            SettingsManager.getInstance().addSetting(sessID, DATABASE_USER_KEY_PREFIX + name, level.name());
            LOG.info((Object)"... granted.");
        }
        catch (Exception ex) {
            LOG.error((Object)"Problem creating user", (Throwable)ex);
            throw new SQLException("Can't setup privileges for user " + name, ex);
        }
        finally {
            conn.executeQuery("FLUSH PRIVILEGES");
            conn.close();
        }
    }

    @Override
    public UserLevel getSessionUsersLevel(String sessID) throws SQLException, RemoteException, SessionExpiredException {
        String name = SessionManager.getInstance().getUserForSession(sessID);
        return this.getUserLevel(sessID, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserLevel getUserLevel(String sessID, String name) throws SQLException, SessionExpiredException {
        if (this.userExists(sessID, name)) {
            PooledConnection conn = ConnectionController.connectPooled(sessID);
            try {
                ResultSet rs = conn.executePreparedQuery("SELECT Create_user_priv FROM mysql.user WHERE user=?", name);
                if (rs.next() && rs.getString(1).equals("Y")) {
                    UserLevel userLevel = UserLevel.ADMIN;
                    return userLevel;
                }
                rs = conn.executePreparedQuery("SELECT Create_tmp_table_priv FROM mysql.db WHERE user=?", name);
                if (rs.next() && rs.getString(1).equals("Y")) {
                    UserLevel userLevel = UserLevel.USER;
                    return userLevel;
                }
            }
            finally {
                conn.close();
            }
            return UserLevel.GUEST;
        }
        return UserLevel.NONE;
    }

    @Override
    public void removeUser(String sid, String name) throws SQLException, SessionExpiredException, RemoteException {
        PooledConnection conn = ConnectionController.connectPooled(sid);
        conn.executePreparedUpdate("DROP USER ?@'localhost'", name);
        conn.executeQuery("FLUSH PRIVILEGES");
        SettingsManager.getInstance().removeSetting(sid, DATABASE_USER_KEY_PREFIX + name);
    }

    public boolean isAdmin(String sessionID) throws SQLException, RemoteException, SessionExpiredException {
        try {
            return this.isAdmin(sessionID, false);
        }
        catch (UnauthorizedException ex) {
            return false;
        }
    }

    public boolean isAdmin(String sessionID, boolean throwUnauthorizedExceptionIfNot) throws SQLException, RemoteException, SessionExpiredException, UnauthorizedException {
        boolean isAdmin;
        boolean bl = isAdmin = this.getSessionUsersLevel(sessionID) == UserLevel.ADMIN;
        if (isAdmin) {
            return true;
        }
        if (throwUnauthorizedExceptionIfNot) {
            throw new UnauthorizedException("You do not have administrative priviledges.");
        }
        return false;
    }
}

