/*
 * Decompiled with CFR 0.152.
 */
package csplugins.task;

import csplugins.task.BaseTask;

public class SampleTask
extends BaseTask {
    private static final int MIN_VALUE = 0;
    private int maxValue;
    private long initializationDelay;
    private long finalizationDelay;
    private long countDelay;

    public SampleTask(int n, long l, long l2, long l3) {
        super("Counting from 0.." + n);
        this.maxValue = n;
        this.initializationDelay = l;
        this.finalizationDelay = l2;
        this.countDelay = l3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeTask() throws Exception {
        this.setMaxProgressValue(this.maxValue);
        this.setProgressValue(0);
        try {
            try {
                this.setProgressMessage("Initializing Counter Task...");
                this.setIndeterminate(true);
                Thread.sleep(this.initializationDelay);
                this.setEstimatedTimeRemaining((long)(this.maxValue - 0) * this.countDelay);
                int n = 0;
                while (n++ < this.maxValue && !this.isInterrupted()) {
                    this.setProgressValue(n);
                    this.setProgressMessage("Counting:  " + n);
                    this.setEstimatedTimeRemaining((long)(this.maxValue - n) * this.countDelay);
                    Thread.sleep(this.countDelay);
                }
                Object var3_3 = null;
            }
            catch (InterruptedException interruptedException) {
                this.setHumanReadableErrorMessage("I was rudely interrupted!");
                throw interruptedException;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this.isInterrupted()) {
                this.setProgressMessage("Canceled by User.  Cleaning up...");
            } else {
                this.setProgressMessage("Finalizing Counter Task...");
            }
            this.setIndeterminate(true);
            Thread.sleep(this.finalizationDelay);
            throw throwable;
        }
        if (this.isInterrupted()) {
            this.setProgressMessage("Canceled by User.  Cleaning up...");
        } else {
            this.setProgressMessage("Finalizing Counter Task...");
        }
        this.setIndeterminate(true);
        Thread.sleep(this.finalizationDelay);
    }
}

