/*
 * Decompiled with CFR 0.152.
 */
package csplugins.task.ui;

import csplugins.task.Task;
import csplugins.task.TaskUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class TaskMonitorUI
extends JFrame
implements ActionListener {
    private Task task;
    private JProgressBar pBar;
    private static final int TIME_INTERVAL = 50;
    private JLabel statusValue;
    private JLabel titleValue;
    private JLabel timeRemainingValue;
    private JLabel timeElapsedValue;
    private Timer timer;
    private static final String ACTION_CANCEL = "CANCEL";
    private static final String ACTION_CLOSE = "CLOSE";
    private JButton cancelButton;
    private JButton closeButton;
    private boolean showTimeFields = true;
    private boolean showUserButtons = true;
    private boolean disposeWhenTaskCompletes = false;
    private int millisToDecideToPopup = 0;
    private Date startTime;
    private Component parentComponent;

    public TaskMonitorUI(Task task) {
        this.task = task;
        this.init();
    }

    public TaskMonitorUI(Task task, boolean bl, boolean bl2, boolean bl3) {
        this.showTimeFields = bl;
        this.showUserButtons = bl2;
        this.disposeWhenTaskCompletes = bl3;
        this.task = task;
        this.init();
    }

    public TaskMonitorUI(Task task, boolean bl, boolean bl2, boolean bl3, int n, Component component) {
        this.showTimeFields = bl;
        this.showUserButtons = bl2;
        this.disposeWhenTaskCompletes = bl3;
        this.task = task;
        this.millisToDecideToPopup = n;
        this.parentComponent = component;
        this.init();
    }

    private void init() {
        this.startTime = new Date();
        this.setTitle(this.task.getTaskTitle());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        int n = 0;
        this.addLabel("Description:  ", jPanel, 0, n, 13, true);
        this.titleValue = this.addLabel(TaskUtil.padString(this.task.getTaskTitle()), jPanel, 1, n, 17, true);
        this.addLabel("Status:  ", jPanel, 0, ++n, 13, true);
        this.statusValue = this.addLabel(TaskUtil.padString("Starting..."), jPanel, 1, n, 17, true);
        this.addLabel("Time Left:  ", jPanel, 0, ++n, 13, this.showTimeFields);
        this.timeRemainingValue = this.addLabel("", jPanel, 1, n, 17, this.showTimeFields);
        this.addLabel("Time Elapsed:  ", jPanel, 0, ++n, 13, this.showTimeFields);
        this.timeElapsedValue = this.addLabel("", jPanel, 1, n, 17, this.showTimeFields);
        this.addLabel("Progress:  ", jPanel, 0, ++n, 13, true);
        this.initProgressBar(jPanel, n);
        container.add((Component)jPanel, "Center");
        this.createFooter(container);
        this.initTimer();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (TaskMonitorUI.this.task.isDone()) {
                    TaskMonitorUI.this.timer.stop();
                    TaskMonitorUI.this.dispose();
                }
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.parentComponent);
        if (this.millisToDecideToPopup == 0) {
            this.show();
        }
    }

    private void createFooter(Container container) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        this.closeButton = new JButton("Close");
        this.closeButton.setEnabled(false);
        this.closeButton.setActionCommand(ACTION_CLOSE);
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(ACTION_CANCEL);
        this.cancelButton.addActionListener(this);
        if (this.showUserButtons) {
            jPanel.add(this.closeButton);
            jPanel.add(this.cancelButton);
        }
        container.add((Component)jPanel, "South");
    }

    private void initProgressBar(JPanel jPanel, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.pBar = new JProgressBar();
        this.pBar.setIndeterminate(true);
        this.pBar.setStringPainted(true);
        this.pBar.setMaximum(Integer.MAX_VALUE);
        this.pBar.setValue(0);
        this.pBar.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.pBar.setDoubleBuffered(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.pBar, gridBagConstraints);
    }

    private JLabel addLabel(String string, JPanel jPanel, int n, int n2, int n3, boolean bl) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(2);
        jLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jLabel.setFont(new Font(null, 0, 13));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = n3;
        if (bl) {
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        return jLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() != null) {
            if (actionEvent.getActionCommand().equals(ACTION_CANCEL)) {
                this.cancelButton.setEnabled(false);
                this.task.interrupt();
            } else if (actionEvent.getActionCommand().equals(ACTION_CLOSE)) {
                this.dispose();
            }
        }
        this.conditionallyPopUpComponent();
        this.updateProgress();
    }

    private void updateProgress() {
        this.setTitle(TaskUtil.padString(this.task.getTaskTitle()));
        this.titleValue.setText(TaskUtil.padString(this.task.getTaskTitle()));
        if (!this.task.isDone()) {
            if (this.task.isIndeterminate()) {
                this.pBar.setIndeterminate(true);
                this.pBar.setStringPainted(false);
                this.timeRemainingValue.setText(TaskUtil.getTimeString(-1L));
            } else {
                this.pBar.setIndeterminate(false);
                this.pBar.setStringPainted(true);
                this.pBar.setValue(this.task.getProgressValue());
                this.pBar.setMaximum(this.task.getMaxProgressValue());
                this.timeRemainingValue.setText(TaskUtil.getTimeString(this.task.getEstimatedTimeRemaining()));
            }
            this.statusValue.setText(TaskUtil.padString(this.task.getProgressMessage()));
        } else {
            this.taskIsFinished();
        }
        this.timeElapsedValue.setText(TaskUtil.getTimeString(this.task.getTimeElapsed()));
    }

    private void conditionallyPopUpComponent() {
        Date date;
        long l;
        if (!this.isShowing() && !this.task.isDone() && (l = (date = new Date()).getTime() - this.startTime.getTime()) > (long)this.millisToDecideToPopup) {
            this.show();
        }
    }

    private void taskIsFinished() {
        this.timer.stop();
        this.pBar.setIndeterminate(false);
        this.pBar.setValue(Integer.MAX_VALUE);
        if (this.task.isInterrupted()) {
            this.statusValue.setText("Task Canceled by User");
        } else {
            this.statusValue.setText("Done");
        }
        this.timeRemainingValue.setText(TaskUtil.getTimeString(0L));
        this.closeButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        if (this.disposeWhenTaskCompletes) {
            this.hide();
            this.dispose();
        }
    }

    private void initTimer() {
        this.timer = new Timer(50, this);
        this.timer.start();
    }
}

