/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import org.exolab.castor.builder.BindingComponent;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.binding.ClassType;
import org.exolab.castor.builder.binding.ComponentBindingType;
import org.exolab.castor.builder.binding.ComponentBindingTypeChoice;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.FieldType;
import org.exolab.castor.builder.binding.Interface;
import org.exolab.castor.builder.binding.NamingXMLType;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JClass;

public class XMLBindingComponent
implements BindingComponent {
    private ExtendedBinding _binding;
    private ComponentBindingType _compBinding;
    private Annotated _annotated;
    private String _prefix;
    private String _suffix;
    private short _type = (short)-1;
    private int _hashCode = -1;
    private String _javaClassName = null;
    private String _javaMemberName = null;
    private String _javaPackage = null;
    private FieldType _member = null;
    private ClassType _class = null;
    private Interface _interface = null;
    private Schema _schema = null;
    private static GroupNaming _groupNaming = null;

    public ExtendedBinding getBinding() {
        return this._binding;
    }

    public void setBinding(ExtendedBinding binding) {
        this._binding = binding;
    }

    public void setView(Annotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException("The XML Schema annotated structure is null.");
        }
        this._annotated = annotated;
        int _hashCode = -1;
        this._javaClassName = null;
        this._javaMemberName = null;
        this._javaPackage = null;
        this._schema = null;
        this._member = null;
        this._class = null;
        this._interface = null;
        this._type = (short)-1;
        this._prefix = null;
        this._suffix = null;
        if (this._binding != null) {
            this._compBinding = this._binding.getComponentBindingType(annotated);
            NamingXMLType naming = this._binding.getNamingXML();
            if (naming != null) {
                switch (annotated.getStructureType()) {
                    case 6: {
                        if (naming.getComplexTypeName() == null) break;
                        this._prefix = naming.getComplexTypeName().getPrefix();
                        this._suffix = naming.getComplexTypeName().getSuffix();
                        break;
                    }
                    case 8: {
                        if (naming.getElementName() == null) break;
                        this._prefix = naming.getElementName().getPrefix();
                        this._suffix = naming.getElementName().getSuffix();
                        break;
                    }
                    case 16: {
                        if (naming.getModelGroupName() == null) break;
                        this._prefix = naming.getModelGroupName().getPrefix();
                        this._suffix = naming.getModelGroupName().getSuffix();
                        break;
                    }
                }
            }
        }
        if (this._compBinding != null) {
            ComponentBindingTypeChoice choice = this._compBinding.getComponentBindingTypeChoice();
            if (choice.getInterface() != null) {
                this._type = 0;
                this._interface = choice.getInterface();
            } else if (choice.getJavaClass() != null) {
                this._type = 1;
                this._class = choice.getJavaClass();
            } else if (choice.getMember() != null) {
                this._type = (short)2;
                this._member = choice.getMember();
            } else {
                String err = "Illegal Binding component:";
                err = err + "it does not define a class, an interface or a member binding.";
                throw new IllegalStateException(err);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        boolean result = false;
        if (object instanceof XMLBindingComponent) {
            XMLBindingComponent temp = (XMLBindingComponent)object;
            result = this._annotated.equals(temp.getAnnotated());
            if (this._compBinding != null) {
                result = temp.getComponentBinding() != null ? result && this._compBinding.equals(temp.getComponentBinding()) : false;
            } else if (temp.getComponentBinding() != null) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int compBindingHash = 0;
            if (this._compBinding != null) {
                compBindingHash = this._compBinding.getName().hashCode();
            }
            this._hashCode = 37 * this._annotated.hashCode() + compBindingHash;
        }
        return this._hashCode;
    }

    protected ComponentBindingType getComponentBinding() {
        return this._compBinding;
    }

    public Annotated getAnnotated() {
        return this._annotated;
    }

    public boolean createGroupItem() {
        int maxOccurs = 0;
        boolean result = false;
        switch (this._annotated.getStructureType()) {
            case 8: {
                XMLType type = ((ElementDecl)this._annotated).getType();
                if (!type.isComplexType() || (maxOccurs = ((ComplexType)type).getMaxOccurs()) <= 1 && maxOccurs >= 0 || type.getName() != null) break;
                result = true;
                break;
            }
            case 6: {
                maxOccurs = ((ComplexType)this._annotated).getMaxOccurs();
                if (maxOccurs <= 1 && maxOccurs >= 0) break;
                result = true;
                break;
            }
            case 10: 
            case 16: {
                Group group = (Group)this._annotated;
                maxOccurs = group.getMaxOccurs();
                if (maxOccurs <= 1 && maxOccurs >= 0) break;
                result = true;
                break;
            }
        }
        return result;
    }

    public String getSchemaLocation() {
        String location = null;
        Schema schema = this.getSchema();
        if (schema != null) {
            location = schema.getSchemaLocation();
        }
        return location;
    }

    public String getTargetNamespace() {
        String result = null;
        Schema schema = null;
        Form form = null;
        switch (this._annotated.getStructureType()) {
            case 3: {
                AttributeDecl attribute = (AttributeDecl)this._annotated;
                if (attribute.isReference()) {
                    attribute = attribute.getReference();
                }
                schema = attribute.getSchema();
                if (attribute.getParent() == schema) break;
                form = attribute.getForm();
                if (form == null) {
                    form = schema.getAttributeFormDefault();
                }
                if (form != null && !form.isUnqualified()) break;
                return null;
            }
            case 8: {
                ElementDecl element = (ElementDecl)this._annotated;
                if (element.isReference()) {
                    element = element.getReference();
                }
                schema = element.getSchema();
                if (element.getParent() == schema) break;
                form = element.getForm();
                if (form == null) {
                    form = schema.getElementFormDefault();
                }
                if (form != null && !form.isUnqualified()) break;
                return null;
            }
        }
        if (schema == null) {
            schema = this.getSchema();
        }
        if (schema != null) {
            result = schema.getTargetNamespace();
        }
        return result;
    }

    public Schema getSchema() {
        if (this._schema == null) {
            switch (this._annotated.getStructureType()) {
                case 3: {
                    AttributeDecl attribute = (AttributeDecl)this._annotated;
                    if (attribute.isReference()) {
                        attribute = attribute.getReference();
                    }
                    this._schema = attribute.getSchema();
                    attribute = null;
                    break;
                }
                case 8: {
                    ElementDecl element = (ElementDecl)this._annotated;
                    if (element.isReference()) {
                        element = element.getReference();
                    }
                    this._schema = element.getSchema();
                    element = null;
                    break;
                }
                case 6: {
                    this._schema = ((ComplexType)this._annotated).getSchema();
                    break;
                }
                case 16: {
                    ModelGroup group = (ModelGroup)this._annotated;
                    if (group.isReference()) {
                        group = group.getReference();
                    }
                    this._schema = group.getSchema();
                    group = null;
                    break;
                }
                case 10: {
                    Structure parent = ((Group)this._annotated).getParent();
                    short structure = parent.getStructureType();
                    while (structure == 10) {
                        parent = ((Group)parent).getParent();
                        structure = parent.getStructureType();
                    }
                    if (structure == 6) {
                        this._schema = ((ComplexType)parent).getSchema();
                        break;
                    }
                    if (structure != 16) break;
                    this._schema = ((ModelGroup)parent).getSchema();
                    break;
                }
                case 21: 
                case 22: {
                    this._schema = ((SimpleType)this._annotated).getSchema();
                    break;
                }
            }
        }
        return this._schema;
    }

    public XMLType getXMLType() {
        XMLType result = null;
        switch (this._annotated.getStructureType()) {
            case 8: {
                result = ((ElementDecl)this._annotated).getType();
                break;
            }
            case 6: {
                result = (ComplexType)this._annotated;
                break;
            }
            case 3: {
                result = ((AttributeDecl)this._annotated).getSimpleType();
                break;
            }
        }
        return result;
    }

    public String getXMLName() {
        String result = null;
        switch (this._annotated.getStructureType()) {
            case 8: {
                result = ((ElementDecl)this._annotated).getName();
                break;
            }
            case 6: {
                result = ((ComplexType)this._annotated).getName();
                break;
            }
            case 3: {
                result = ((AttributeDecl)this._annotated).getName();
                break;
            }
            case 10: 
            case 16: {
                result = ((Group)this._annotated).getName();
                break;
            }
        }
        return result;
    }

    public String getValue() {
        String result = null;
        switch (this._annotated.getStructureType()) {
            case 8: {
                result = ((ElementDecl)this._annotated).getDefaultValue();
                if (result != null) break;
                result = ((ElementDecl)this._annotated).getFixedValue();
                break;
            }
            case 3: {
                result = ((AttributeDecl)this._annotated).getDefaultValue();
                if (result != null) break;
                result = ((AttributeDecl)this._annotated).getFixedValue();
                break;
            }
        }
        return result;
    }

    public String getJavaClassName() {
        if (this._javaClassName == null) {
            String result = null;
            if (this._compBinding != null) {
                switch (this.getType()) {
                    case 1: {
                        result = this._class.getName();
                        break;
                    }
                    case 0: {
                        result = this._interface.getName();
                        break;
                    }
                }
            }
            if (result == null || result.length() <= 0) {
                if (this._annotated.getStructureType() == 8) {
                    ElementDecl element = (ElementDecl)this._annotated;
                    if (element.isReference()) {
                        Annotated temp = this._annotated;
                        this.setView(element.getReference());
                        result = this.getJavaClassName();
                        this.setView(temp);
                        Object var3_3 = null;
                    }
                    element = null;
                }
                if (!(result != null && result.length() > 0 || (result = this.getXMLName()) != null || this._annotated.getStructureType() != 10 && this._annotated.getStructureType() != 16 || (result = _groupNaming.createClassName((Group)this._annotated)) != null)) {
                    String err = "Unable to create name for group.";
                    throw new IllegalStateException(err);
                }
            }
            if (this._prefix != null) {
                result = this._prefix + result;
            }
            if (this._suffix != null) {
                result = result + this._suffix;
            }
            this._javaClassName = JavaNaming.toJavaClassName(result);
        }
        return this._javaClassName;
    }

    public String getJavaMemberName() {
        if (this._javaMemberName == null) {
            String result = null;
            if (this._compBinding != null) {
                switch (this.getType()) {
                    case 1: {
                        result = this._class.getName();
                        break;
                    }
                    case 0: {
                        result = this._interface.getName();
                        break;
                    }
                    case 2: {
                        result = this._member.getName();
                        break;
                    }
                }
            }
            if (result == null || result.length() <= 0) {
                Annotated temp = null;
                if (this._annotated.getStructureType() == 3) {
                    AttributeDecl att = (AttributeDecl)this._annotated;
                    if (att.isReference()) {
                        temp = this._annotated;
                        this.setView(att.getReference());
                        result = this.getJavaMemberName();
                        this.setView(temp);
                    }
                    att = null;
                } else if (this._annotated.getStructureType() == 8) {
                    ElementDecl element = (ElementDecl)this._annotated;
                    if (element.isReference()) {
                        temp = this._annotated;
                        this.setView(element.getReference());
                        result = this.getJavaMemberName();
                        this.setView(temp);
                    }
                    element = null;
                }
                temp = null;
                if (!(result != null && result.length() > 0 || (result = this.getXMLName()) != null || this._annotated.getStructureType() != 10 && this._annotated.getStructureType() != 16 || (result = _groupNaming.createClassName((Group)this._annotated)) != null)) {
                    String err = "Unable to create name for group.";
                    throw new IllegalStateException(err);
                }
            }
            if (this._prefix != null) {
                result = this._prefix + result;
            }
            if (this._suffix != null) {
                result = result + this._suffix;
            }
            this._javaMemberName = JavaNaming.toJavaMemberName(result);
        }
        return this._javaMemberName;
    }

    public String getQualifiedName() {
        String result = this.getJavaClassName();
        String packageName = this.getJavaPackage();
        if (packageName != null && packageName.length() > 0) {
            packageName = packageName + '.';
            result = packageName + result;
        }
        return result;
    }

    public String getJavaPackage() {
        if (this._javaPackage == null) {
            String packageName = null;
            String schemaLocation = this.getSchemaLocation();
            String targetNamespace = this.getTargetNamespace();
            if (targetNamespace == null) {
                targetNamespace = "";
            }
            if (this._compBinding != null) {
                switch (this.getType()) {
                    case 1: {
                        packageName = this._class.getPackage();
                        break;
                    }
                }
            }
            if (packageName == null || packageName.length() == 0) {
                if (schemaLocation != null) {
                    packageName = SourceGenerator.lookupPackageLocation(schemaLocation);
                }
                if (packageName == null || packageName.length() == 0) {
                    packageName = SourceGenerator.lookupPackageNamespace(targetNamespace);
                }
            }
            this._javaPackage = packageName;
        }
        return this._javaPackage;
    }

    public int getUpperBound() {
        switch (this._annotated.getStructureType()) {
            case 8: {
                return ((ElementDecl)this._annotated).getMaxOccurs();
            }
            case 6: {
                return ((ComplexType)this._annotated).getMaxOccurs();
            }
            case 10: 
            case 16: {
                return ((Group)this._annotated).getMaxOccurs();
            }
        }
        return 1;
    }

    public int getLowerBound() {
        switch (this._annotated.getStructureType()) {
            case 8: {
                return ((ElementDecl)this._annotated).getMinOccurs();
            }
            case 6: {
                return ((ComplexType)this._annotated).getMinOccurs();
            }
            case 10: 
            case 16: {
                return ((Group)this._annotated).getMinOccurs();
            }
            case 3: {
                if (!((AttributeDecl)this._annotated).isRequired()) break;
                return 1;
            }
        }
        return 0;
    }

    public String getExtends() {
        if (this.getType() == 1) {
            return this._class.getExtends();
        }
        return SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
    }

    public String[] getImplements() {
        if (this.getType() == 1) {
            return this._class.getImplements();
        }
        return null;
    }

    public boolean hasBoundProperties() {
        if (this.getType() == 1 && this._class.hasBound()) {
            return this._class.getBound();
        }
        return SourceGenerator.boundPropertiesEnabled();
    }

    public boolean hasEquals() {
        if (this.getType() == 1 && this._class.hasEquals()) {
            return this._class.getEquals();
        }
        return SourceGenerator.equalsMethod();
    }

    public boolean isAbstract() {
        boolean result = false;
        if (this.getType() == 1 && this._class.hasAbstract()) {
            result = this._class.getAbstract();
        }
        if (!result) {
            result = this._annotated.getStructureType() == 6;
            result = result && SourceGenerator.mappingSchemaElement2Java();
        }
        return result;
    }

    public boolean isFinal() {
        if (this.getType() == 1) {
            return this._class.getFinal();
        }
        return false;
    }

    public boolean isFixed() {
        switch (this._annotated.getStructureType()) {
            case 8: {
                String fixed = ((ElementDecl)this._annotated).getFixedValue();
                return fixed != null;
            }
            case 3: {
                return ((AttributeDecl)this._annotated).isFixed();
            }
        }
        return false;
    }

    public boolean useWrapper() {
        boolean result = false;
        if (this._type == 2) {
            if (this._member.hasWrapper()) {
                result = this._member.getWrapper();
            }
        } else {
            result = SourceGenerator.usePrimitiveWrapper();
        }
        return result;
    }

    public XSType getJavaType() {
        String javaType;
        XSType result = null;
        boolean useWrapper = this.useWrapper();
        XMLType type = this.getXMLType();
        if (type.isComplexType()) {
            result = new XSClass(new JClass(this.getJavaClassName()));
        } else if (this._type == 2 && (javaType = this._member.getJavaType()) != null && javaType.length() > 0) {
            result = TypeConversion.convertType(javaType);
        }
        if (result == null && type.isSimpleType()) {
            String packageName = null;
            if (((SimpleType)type).getSchema() != this.getSchema()) {
                XMLBindingComponent comp = new XMLBindingComponent();
                comp.setBinding(this._binding);
                comp.setView(type);
                packageName = comp.getJavaPackage();
            } else {
                packageName = this.getJavaPackage();
            }
            if (packageName == null || packageName.length() == 0) {
                String ns = ((SimpleType)type).getSchema().getTargetNamespace();
                packageName = SourceGenerator.lookupPackageNamespace(ns);
            }
            result = TypeConversion.convertType((SimpleType)type, useWrapper, packageName);
        }
        return result;
    }

    public String getCollectionType() {
        String result = null;
        if (this._type == 2) {
            result = this._member.getCollection().toString();
        }
        return result;
    }

    public String getValidator() {
        if (this._type == 2) {
            return this._member.getValidator();
        }
        return null;
    }

    public String getXMLFieldHandler() {
        if (this._type == 2) {
            return this._member.getHandler();
        }
        return null;
    }

    public short getType() {
        return this._type;
    }

    static {
        _groupNaming = new GroupNaming();
    }
}

