/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class LRU {
    public static final int CACHE_NONE = 1;
    public static final int CACHE_COUNT_LIMITED = 2;
    public static final int CACHE_TIME_LIMITED = 3;
    public static final int CACHE_UNLIMITED = 4;
    public static final int DEFAULT_TYPE = 2;
    public static final int DEFAULT_PARAM = 30;

    public abstract Object put(Object var1, Object var2);

    public abstract Object get(Object var1);

    public abstract Object remove(Object var1);

    public abstract Enumeration elements();

    public static LRU create(int type, int param) {
        LRU cache;
        if (type == 0) {
            type = 2;
            param = 30;
        }
        switch (type) {
            case 2: {
                if (param > 0) {
                    cache = new CountLimited(param);
                    break;
                }
                cache = new NoCache();
                break;
            }
            case 3: {
                if (param > 0) {
                    cache = new TimeLimited(param);
                    break;
                }
                cache = new NoCache();
                break;
            }
            case 4: {
                cache = new Unlimited();
                break;
            }
            case 1: {
                cache = new NoCache();
                break;
            }
            default: {
                cache = new CountLimited(100);
            }
        }
        return cache;
    }

    public static int mapType(String type) {
        if (type == null || type.equals("")) {
            return 0;
        }
        if (type.toLowerCase().equals("none")) {
            return 1;
        }
        if (type.toLowerCase().equals("count-limited")) {
            return 2;
        }
        if (type.toLowerCase().equals("time-limited")) {
            return 3;
        }
        if (type.toLowerCase().equals("unlimited")) {
            return 4;
        }
        return 0;
    }

    public static class Unlimited
    extends LRU {
        private Hashtable map = new Hashtable();

        public Object put(Object key, Object value) {
            return this.map.put(key, value);
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public Object remove(Object key) {
            return this.map.remove(key);
        }

        public Enumeration elements() {
            return this.map.elements();
        }

        protected void dispose(Object o) {
        }
    }

    public static class TimeLimited
    extends LRU {
        public static final int DEFAULT_PRECISION = 1000;
        private static TimeThread ticker = new TimeThread(1000);
        private int interval;
        private int tailtime;
        private QueueItem head;
        private QueueItem tail;
        private Hashtable map = new Hashtable();

        public TimeLimited(int interval) {
            this.interval = interval + 1;
            ticker.addListener(this);
        }

        public synchronized Object put(Object key, Object value) {
            QueueItem oldItem = (QueueItem)this.map.get(key);
            if (oldItem != null) {
                Object oldObject = oldItem.item;
                oldItem.item = value;
                this.remove(oldItem);
                this.add(oldItem);
                return oldObject;
            }
            QueueItem newitem = new QueueItem(key, value);
            this.map.put(key, newitem);
            this.add(newitem);
            return null;
        }

        public synchronized Object get(Object key) {
            Object o = this.map.get(key);
            if (o == null) {
                return null;
            }
            return ((QueueItem)o).item;
        }

        public synchronized Object remove(Object key) {
            Object o = this.map.remove(key);
            if (o == null) {
                return null;
            }
            return ((QueueItem)o).item;
        }

        public synchronized Enumeration elements() {
            return new ValuesEnumeration(this.map.elements());
        }

        protected void dispose(Object o) {
        }

        private void remove(QueueItem item) {
            if (item == null) {
                throw new NullPointerException();
            }
            if (item == this.head) {
                QueueItem temp = item;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    this.head.prev = null;
                    this.head.time += temp.time;
                }
                temp.prev = null;
                temp.next = null;
                temp.time = 0;
            } else if (item == this.tail) {
                this.tail = this.tail.prev;
                this.tailtime = 0;
            } else {
                QueueItem temp = item;
                temp.prev.next = temp.next;
                temp.next.prev = temp.prev;
                temp.next.time += temp.time;
                temp.prev = null;
                temp.next = null;
                temp.time = 0;
            }
        }

        private void add(QueueItem item) {
            ticker.startTick();
            if (this.head == null) {
                this.head = this.tail = item;
                item.prev = null;
                item.next = null;
                item.time = this.interval;
                this.tailtime = this.interval;
            } else {
                this.tail.next = item;
                item.prev = this.tail;
                item.next = null;
                item.time = this.interval - this.tailtime;
                this.tailtime = this.interval;
                this.tail = item;
            }
        }

        private synchronized void tick() {
            if (this.head != null) {
                this.head.time--;
                --this.tailtime;
            }
            while (this.head != null && this.head.time <= 0) {
                QueueItem temp = this.head;
                Object o = this.head.item;
                this.remove(temp);
                this.map.remove(temp.key);
                this.dispose(o);
            }
        }

        private static class TimeThread
        extends Thread {
            private int[] listenerLock = new int[0];
            private LinkList listener;
            private int[] lock = new int[0];
            private int tick;
            private long lastTime;
            private boolean isStopped;
            private boolean isStarted;

            public TimeThread(int tick) {
                super("Time-limited cache daemon");
                this.tick = tick;
                this.setDaemon(true);
                this.setPriority(1);
                this.isStopped = true;
                this.start();
            }

            public void startTick() {
                if (this.isStarted && this.isStopped) {
                    int[] nArray = this.lock;
                    synchronized (nArray) {
                        this.lastTime = System.currentTimeMillis();
                        this.lock.notify();
                    }
                }
            }

            public void stopTick() {
                this.isStopped = true;
            }

            public void run() {
                this.isStarted = true;
                try {
                    block5: while (true) {
                        if (this.isStopped) {
                            int[] nArray = this.lock;
                            synchronized (nArray) {
                                this.lock.wait();
                            }
                            this.isStopped = false;
                        } else {
                            long time = System.currentTimeMillis();
                            if (time - this.lastTime < (long)this.tick) {
                                Thread.sleep((long)this.tick - (time - this.lastTime));
                            }
                            this.lastTime = System.currentTimeMillis();
                        }
                        LinkList temp = this.listener;
                        while (true) {
                            if (temp == null) continue block5;
                            temp.t.tick();
                            temp = temp.next;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            public void addListener(TimeLimited t) {
                int[] nArray = this.listenerLock;
                synchronized (nArray) {
                    this.listener = new LinkList(this.listener, t);
                }
            }

            private class LinkList {
                private LinkList next;
                private TimeLimited t;

                LinkList(LinkList next, TimeLimited t) {
                    this.next = next;
                    this.t = t;
                }
            }
        }

        private class QueueItem {
            private QueueItem next;
            private QueueItem prev;
            private Object key;
            private Object item;
            private int time;

            private QueueItem(Object key, Object item) {
                this.key = key;
                this.item = item;
            }
        }

        private class ValuesEnumeration
        implements Enumeration {
            private Vector v = new Vector();
            private int cur;

            private ValuesEnumeration(Enumeration e) {
                while (e.hasMoreElements()) {
                    this.v.add(e.nextElement());
                }
                this.v.trimToSize();
            }

            public boolean hasMoreElements() {
                return this.v.size() > this.cur;
            }

            public Object nextElement() throws NoSuchElementException {
                Object o;
                if (this.v.size() <= this.cur) {
                    throw new NoSuchElementException();
                }
                if ((o = this.v.get(this.cur++)) != null) {
                    return ((QueueItem)o).item;
                }
                return null;
            }
        }
    }

    public static class NoCache
    extends LRU {
        public synchronized Object put(Object key, Object object) {
            this.dispose(object);
            return null;
        }

        public synchronized Object get(Object key) {
            return null;
        }

        public synchronized Object remove(Object key) {
            return null;
        }

        public Enumeration elements() {
            return new EmptyEnumeration();
        }

        protected void dispose(Object o) {
        }

        private class EmptyEnumeration
        implements Enumeration {
            private EmptyEnumeration() {
            }

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        }
    }

    public static class CountLimited
    extends LRU {
        private static final int LRU_OLD = 0;
        private static final int LRU_NEW = 1;
        private Hashtable mapKeyPos;
        private Object[] keys;
        private Object[] values;
        private int[] status;
        private int cur;
        private int size;

        public CountLimited(int size) {
            this.keys = new Object[size];
            this.values = new Object[size];
            this.status = new int[size];
            this.mapKeyPos = new Hashtable(size);
            this.size = size;
        }

        public synchronized Object put(Object key, Object object) {
            Object oldPos = this.mapKeyPos.get(key);
            if (oldPos != null) {
                int pos = (Integer)oldPos;
                Object oldObject = this.values[pos];
                this.values[pos] = object;
                this.status[pos] = 1;
                this.dispose(oldObject);
                return oldObject;
            }
            while (this.walkStatus() != 0) {
            }
            Integer intvalue = this.keys[this.cur] != null ? this.mapKeyPos.remove(this.keys[this.cur]) : new Integer(this.cur);
            Object oldObject = this.values[this.cur];
            this.keys[this.cur] = key;
            this.values[this.cur] = object;
            this.status[this.cur] = 1;
            this.mapKeyPos.put(key, intvalue);
            ++this.cur;
            if (this.cur >= this.size) {
                this.cur = 0;
            }
            if (oldObject != null) {
                this.dispose(oldObject);
            }
            return oldObject;
        }

        public synchronized Object get(Object key) {
            Object intvalue = this.mapKeyPos.get(key);
            if (intvalue != null) {
                int pos = (Integer)intvalue;
                this.status[pos] = 1;
                return this.values[pos];
            }
            return null;
        }

        public synchronized Object remove(Object key) {
            Object intvalue = this.mapKeyPos.remove(key);
            if (intvalue != null) {
                int pos = (Integer)intvalue;
                Object temp = this.values[pos];
                this.keys[pos] = null;
                this.values[pos] = null;
                this.status[pos] = 0;
                return temp;
            }
            return null;
        }

        public Enumeration elements() {
            return new ValuesEnumeration(this.values);
        }

        protected void dispose(Object o) {
        }

        private int walkStatus() {
            int s = this.status[this.cur];
            if (this.status[this.cur] == 1) {
                this.status[this.cur] = 0;
                ++this.cur;
                if (this.cur >= this.size) {
                    this.cur = 0;
                }
                return 1;
            }
            return 0;
        }

        private class ValuesEnumeration
        implements Enumeration {
            private int cur;
            private Object[] values;

            private ValuesEnumeration(Object[] v) {
                Vector<Object> t = new Vector<Object>(v.length);
                int i = 0;
                while (i < v.length) {
                    if (v[i] != null) {
                        t.add(v[i]);
                    }
                    ++i;
                }
                this.values = t.toArray();
            }

            public boolean hasMoreElements() {
                return this.values != null && this.values.length > this.cur;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.values == null || this.values.length <= this.cur) {
                    throw new NoSuchElementException();
                }
                return this.values[this.cur++];
            }
        }
    }
}

