/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.live.interaction;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.live.DataServiceBase;
import org.mskcc.dataservices.mapper.MapPsiToInteractions;
import org.mskcc.dataservices.mapper.MapperException;
import org.mskcc.dataservices.util.ContentReader;

public class ReadPsiFromFileOrWeb
extends DataServiceBase {
    private ArrayList interactions;

    public ArrayList getInteractionsFromUrl(String string) throws DataServiceException {
        try {
            ContentReader contentReader = new ContentReader();
            String string2 = contentReader.retrieveContent(string);
            this.process(string2);
            return this.interactions;
        }
        catch (MapperException mapperException) {
            throw new DataServiceException(mapperException, mapperException.getHumanReadableErrorMessage());
        }
    }

    private void process(String string) throws MapperException, DataServiceException {
        Object object;
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            object = new StringReader(string);
            Document document = sAXBuilder.build((Reader)object);
            Element element = document.getRootElement();
            if (element.getName().equals("error")) {
                if (element.getChild("error_code").getText().equals("460")) {
                    this.interactions = new ArrayList();
                    return;
                }
                throw new DataServiceException("A PSI-MI document was found, but it contained the following error code: " + element.getChild("error_code").getText());
            }
            if (!element.getName().equals("entrySet")) {
                throw new DataServiceException("A PSI-MI document was expected but the returned document had a root element of type: " + element.getName() + " instead of: entrySet. Please check " + "the file/URL and try again.");
            }
        }
        catch (JDOMException jDOMException) {
            throw new DataServiceException("A PSI-MI document was expected but the returned document was not a well formed xml document. Please check the file/URL and try again.");
        }
        this.interactions = new ArrayList();
        object = new MapPsiToInteractions(string, this.interactions);
        ((MapPsiToInteractions)object).doMapping();
    }
}

