/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.action;

import csplugins.dataviewer.action.BaseAction;
import csplugins.dataviewer.task.LoadSoftTask;
import csplugins.task.ui.TaskMonitorUI;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CytoscapeDesktop;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JOptionPane;

public class LoadSoft
extends BaseAction {
    public static final String ACTION_IMPORT_SOFT_WEB = "load_soft_web";
    public static final String ACTION_IMPORT_SOFT_FILE = "load_soft_file";

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
            if (cyNetwork.getNodeCount() > 0) {
                if (string.equals(ACTION_IMPORT_SOFT_FILE)) {
                    this.importSoftFile();
                } else if (string.equals(ACTION_IMPORT_SOFT_WEB)) {
                    this.importSoftWeb();
                }
            } else {
                String string2 = "The SOFT PlugIn imports gene expression data into an existing Cytoscape Network.\nPlease load a Cytoscape network first, and then try again.";
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), string2, "Please Load Cytoscape Network", 1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void importSoftWeb() {
        URL uRL = this.getURL("Enter URL for GEO SOFT Document:  ");
        if (uRL != null) {
            LoadSoftTask loadSoftTask = new LoadSoftTask(uRL);
            this.startTask(loadSoftTask);
        }
    }

    private void importSoftFile() {
        String[] stringArray = new String[]{"soft"};
        String string = this.getFile(stringArray, "SOFT Files (*.soft)");
        if (string != null) {
            File file = new File(string);
            LoadSoftTask loadSoftTask = new LoadSoftTask(file);
            this.startTask(loadSoftTask);
        }
    }

    private void startTask(LoadSoftTask loadSoftTask) {
        CytoscapeDesktop cytoscapeDesktop = Cytoscape.getDesktop();
        loadSoftTask.setParentFrame((Component)cytoscapeDesktop);
        new TaskMonitorUI(loadSoftTask, true, true, true, 0, (Component)cytoscapeDesktop);
        loadSoftTask.start();
    }
}

