/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.mapper;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.data.GraphObjAttributes;
import java.util.ArrayList;
import java.util.List;
import org.mskcc.dataservices.bio.AttributeBag;
import org.mskcc.dataservices.bio.ExternalReference;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;
import org.mskcc.dataservices.bio.vocab.CommonVocab;
import org.mskcc.dataservices.mapper.Mapper;

public class MapGraphToInteractions
implements Mapper {
    private CyNetwork cyNetwork;
    private GraphObjAttributes nodeAttributes;
    private GraphObjAttributes edgeAttributes;
    private ArrayList interactions;

    public MapGraphToInteractions(CyNetwork cyNetwork) {
        this.cyNetwork = cyNetwork;
        this.nodeAttributes = cyNetwork.getNodeAttributes();
        this.edgeAttributes = cyNetwork.getEdgeAttributes();
    }

    public void doMapping() {
        this.interactions = new ArrayList();
        List list = this.cyNetwork.edgesList();
        for (int i = 0; i < list.size(); ++i) {
            Interaction interaction = new Interaction();
            CyEdge cyEdge = (CyEdge)list.get(i);
            if (cyEdge == null) continue;
            CyNode cyNode = cyEdge.getSourceNode();
            CyNode cyNode2 = cyEdge.getTargetNode();
            Interactor interactor = new Interactor();
            Interactor interactor2 = new Interactor();
            this.transferNodeAttributes(cyNode, interactor);
            this.transferNodeAttributes(cyNode2, interactor2);
            ArrayList<Interactor> arrayList = new ArrayList<Interactor>();
            arrayList.add(interactor);
            arrayList.add(interactor2);
            interaction.setInteractors(arrayList);
            this.transferEdgeAttributes(cyEdge, interaction);
            this.interactions.add(interaction);
        }
    }

    public ArrayList getInteractions() {
        return this.interactions;
    }

    private void transferEdgeAttributes(CyEdge cyEdge, Interaction interaction) {
        String string = this.edgeAttributes.getCanonicalName((Object)cyEdge);
        String[] stringArray = this.edgeAttributes.getAttributeNames();
        this.transferAllAttributes(stringArray, this.edgeAttributes, string, interaction);
    }

    private void transferNodeAttributes(CyNode cyNode, Interactor interactor) {
        String string = this.nodeAttributes.getCanonicalName((Object)cyNode);
        interactor.setName(string);
        String[] stringArray = this.nodeAttributes.getAttributeNames();
        this.transferAllAttributes(stringArray, this.nodeAttributes, string, interactor);
    }

    private void transferAllAttributes(String[] stringArray, GraphObjAttributes graphObjAttributes, String string, AttributeBag attributeBag) {
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals(CommonVocab.XREF_DB_NAME)) {
                stringArray2 = (String[])graphObjAttributes.get(string2, string);
                continue;
            }
            if (string2.equals(CommonVocab.XREF_DB_ID)) {
                stringArray3 = (String[])graphObjAttributes.get(string2, string);
                continue;
            }
            Object object = graphObjAttributes.get(string2, string);
            attributeBag.addAttribute(string2, object);
        }
        this.addExternalReferences(stringArray2, stringArray3, attributeBag);
    }

    private void addExternalReferences(String[] stringArray, String[] stringArray2, AttributeBag attributeBag) {
        if (stringArray != null & stringArray2 != null) {
            ExternalReference[] externalReferenceArray = new ExternalReference[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                ExternalReference externalReference;
                String string = stringArray[i];
                String string2 = stringArray2[i];
                externalReferenceArray[i] = externalReference = new ExternalReference(string, string2);
            }
            attributeBag.setExternalRefs(externalReferenceArray);
        }
    }
}

