/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.mapper;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.data.GraphObjAttributes;
import cytoscape.giny.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mskcc.dataservices.bio.Matrix;
import org.mskcc.dataservices.bio.StateInformation;
import org.mskcc.dataservices.mapper.Mapper;
import org.mskcc.dataservices.mapper.MapperException;

public class MapStateInformationToGraph
implements Mapper {
    private StateInformation stateInformation;
    private CyNetwork cyNetwork;
    private HashMap matchMap;

    public MapStateInformationToGraph(StateInformation stateInformation, CyNetwork cyNetwork) {
        this.stateInformation = stateInformation;
        this.cyNetwork = cyNetwork;
        this.matchMap = new HashMap();
    }

    public void doMapping() throws MapperException {
        try {
            HashMap hashMap = this.createNodeMap(this.cyNetwork);
            ArrayList arrayList = this.stateInformation.getMatrices();
            for (int i = 0; i < arrayList.size(); ++i) {
                Matrix matrix = (Matrix)arrayList.get(i);
                if (matrix.getNumRows() <= 0) continue;
                int n = matrix.getIdColumnNumber();
                this.mapData(matrix, n, hashMap);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new MapperException(arrayIndexOutOfBoundsException, "This File does not contain any SOFT entities.  Please check the file or URL, and try again.");
        }
    }

    public int getNumMatches() {
        return this.matchMap.size();
    }

    private void mapData(Matrix matrix, int n, HashMap hashMap) {
        GraphObjAttributes graphObjAttributes = this.cyNetwork.getNodeAttributes();
        for (int i = 0; i < matrix.getNumRows(); ++i) {
            String string = matrix.getId(i);
            Node node = (Node)hashMap.get(string);
            if (node == null) continue;
            this.matchMap.put(string, node);
            for (int j = n + 1; j < matrix.getNumColumns(); ++j) {
                String string2 = matrix.getDataHeaderName(j);
                if (matrix.isDouble(i, j)) {
                    double d = matrix.getDataDouble(i, j);
                    graphObjAttributes.set(string2, string, d);
                    continue;
                }
                String string3 = matrix.getDataString(i, j);
                graphObjAttributes.set(string2, string, (Object)string3);
            }
        }
    }

    private HashMap createNodeMap(CyNetwork cyNetwork) {
        HashMap<String, CyNode> hashMap = new HashMap<String, CyNode>();
        List list = cyNetwork.nodesList();
        for (int i = 0; i < list.size(); ++i) {
            CyNode cyNode = (CyNode)list.get(i);
            String string = cyNode.getIdentifier();
            hashMap.put(string, cyNode);
        }
        return hashMap;
    }
}

