/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.task;

import csplugins.dataviewer.mapper.MapStateInformationToGraph;
import csplugins.dataviewer.ui.ErrorDisplay;
import csplugins.task.BaseTask;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.mskcc.dataservices.bio.StateInformation;
import org.mskcc.dataservices.live.state.ReadSoftFromFileOrWeb;

public class LoadSoftTask
extends BaseTask {
    private URL url;
    private File file;
    private StringBuffer msg = new StringBuffer();
    private static final String TASK_TITLE = "Loading SOFT File";
    private Component parentFrame;

    public LoadSoftTask(URL uRL) {
        super(TASK_TITLE);
        this.url = uRL;
    }

    public LoadSoftTask(File file) {
        super(TASK_TITLE);
        this.file = file;
    }

    public void setParentFrame(Component component) {
        this.parentFrame = component;
    }

    public void executeTask() throws Exception {
        block2: {
            try {
                this.setTaskTitle(TASK_TITLE);
                this.setIndeterminate(true);
                ReadSoftFromFileOrWeb readSoftFromFileOrWeb = new ReadSoftFromFileOrWeb();
                StateInformation stateInformation = null;
                stateInformation = this.file != null ? readSoftFromFileOrWeb.getStateInformation(this.file.toString()) : readSoftFromFileOrWeb.getStateInformation(this.url.toString());
                MapStateInformationToGraph mapStateInformationToGraph = new MapStateInformationToGraph(stateInformation, Cytoscape.getCurrentNetwork());
                mapStateInformationToGraph.doMapping();
                this.setInformationMessage(stateInformation, mapStateInformationToGraph.getNumMatches());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.showError(throwable);
                if (!(throwable instanceof Exception)) break block2;
                throw (Exception)throwable;
            }
        }
    }

    private void setInformationMessage(StateInformation stateInformation, int n) {
        this.msg.append("Retrieved SOFT Data from:  ");
        if (this.file != null) {
            this.msg.append(this.file.toString());
        } else {
            this.msg.append(this.url.toString());
        }
        ArrayList arrayList = stateInformation.getMatrices();
        this.msg.append("\n\nNumber of SOFT Entities Read:  " + arrayList.size());
        CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
        this.msg.append("\nNumber of nodes in the current network:  " + cyNetwork.getNodeCount());
        this.msg.append("\nNumber of nodes which now contain expression data:  " + n);
        if (n == 0) {
            this.msg.append("\n\nError!  In order for the SOFT PlugIn to import data into an existing Cytoscape network,\nthe network data file and the SOFT data file must use common identifiers.\nCheck the README.txt file that accompanies this PlugIn for more details.");
        } else {
            this.msg.append("\n\nTo view expression data, first select a node.  Then select Data --> Display Attribute Browser.");
        }
        this.updateUser(this.msg.toString());
    }

    private void updateUser(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(LoadSoftTask.this.parentFrame, string, "SOFT PlugIn", 1);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void showError(final Throwable throwable) {
        Runnable runnable = new Runnable(){

            public void run() {
                ErrorDisplay errorDisplay = new ErrorDisplay((JFrame)LoadSoftTask.this.parentFrame);
                errorDisplay.displayError(throwable);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

