/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.ui;

import csplugins.dataviewer.action.DisplayDetails;
import csplugins.dataviewer.action.ExecuteQuery;
import csplugins.dataviewer.action.UpdateSearchRequest;
import csplugins.dataviewer.model.MaxHitsOption;
import csplugins.dataviewer.model.OrganismOption;
import csplugins.dataviewer.model.SearchBundle;
import csplugins.dataviewer.model.SearchBundleList;
import csplugins.dataviewer.model.SearchRequest;
import csplugins.dataviewer.model.SearchResponse;
import csplugins.dataviewer.model.UserSelection;
import csplugins.dataviewer.ui.AboutDialog;
import csplugins.dataviewer.ui.ConsolePanel;
import csplugins.dataviewer.ui.DetailsPanel;
import csplugins.dataviewer.ui.ErrorDisplay;
import csplugins.dataviewer.ui.QuickReferenceDialog;
import cytoscape.CyNetwork;
import cytoscape.data.FlagEventListener;
import cytoscape.data.FlagFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.mskcc.dataservices.core.EmptySetException;
import org.mskcc.dataservices.util.PropertyManager;

public class CPathDesktop
extends JFrame
implements Observer {
    private SearchRequest searchRequest;
    private static SearchBundleList searchList = new SearchBundleList();
    private ConsolePanel consolePanel;
    private UserSelection userSelection = new UserSelection();
    private HashMap cyMap = new HashMap();
    private JButton searchButton;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 400;

    public CPathDesktop(JFrame jFrame) {
        super("cPath PlugIn");
        this.searchRequest = new SearchRequest();
        searchList.addObserver(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.consolePanel = new ConsolePanel();
        PropertyManager propertyManager = PropertyManager.getInstance();
        String string = propertyManager.getProperty(PropertyManager.CPATH_READ_LOCATION);
        this.consolePanel.logMessage("PlugIn is currently set to retrieve data from:  " + string);
        DetailsPanel detailsPanel = new DetailsPanel(this.userSelection, this);
        JSplitPane jSplitPane = new JSplitPane(1, this.consolePanel, detailsPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setPreferredSize(new Dimension(400, 400));
        jSplitPane.setDividerLocation(300);
        container.add((Component)jSplitPane, "Center");
        JPanel jPanel = this.createPanelNorth();
        container.add((Component)jPanel, "North");
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private JPanel createPanelNorth() {
        int n = 5;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        TitledBorder titledBorder = new TitledBorder("Search cPath");
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.searchButton = new JButton("Search");
        this.searchButton.setAlignmentX(0.0f);
        ExecuteQuery executeQuery = new ExecuteQuery(this.cyMap, this.searchRequest, searchList, this.consolePanel, this.searchButton, this);
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        JTextField jTextField = new JTextField("", 8);
        Font font = jTextField.getFont();
        jTextField.setFont(new Font(font.getName(), 0, 11));
        jTextField.setToolTipText("Enter Search Term(s)");
        UpdateSearchRequest updateSearchRequest = new UpdateSearchRequest(this.searchRequest);
        jTextField.addFocusListener(updateSearchRequest);
        jTextField.addKeyListener(executeQuery);
        jTextField.setAlignmentY(1.0f);
        jTextField.setMinimumSize(new Dimension(100, 50));
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        jPanel2.add(jTextField);
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        JComboBox jComboBox = this.createOrganismComboBox();
        jComboBox.setFont(new Font(font.getName(), 0, 11));
        jComboBox.setToolTipText("Filter by Organism");
        jComboBox.setPrototypeDisplayValue(new String("Saccharomyces cerevisiae"));
        jComboBox.setAlignmentY(1.0f);
        jPanel2.add(jComboBox);
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        JComboBox jComboBox2 = this.createResultLimitComboBox();
        jComboBox2.setFont(new Font(font.getName(), 0, 11));
        jComboBox2.setToolTipText("Limit Result Set or Get All");
        jComboBox2.setAlignmentY(1.0f);
        jComboBox2.setPrototypeDisplayValue(new String("Get All --- Get All"));
        jPanel2.add(jComboBox2);
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        this.searchButton.setToolTipText("Execute Search Query");
        this.searchButton.setAlignmentY(1.0f);
        jPanel2.add(this.searchButton);
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        this.searchButton.addActionListener(executeQuery);
        JButton jButton = new JButton("Help");
        jButton.setToolTipText("View Quick Reference Manual");
        jButton.addActionListener(new QuickReferenceDialog(this));
        jButton.setAlignmentY(1.0f);
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(n, 0)));
        JButton jButton2 = new JButton("About");
        jButton2.setToolTipText("About the cPath PlugIn");
        jButton2.addActionListener(new AboutDialog(this));
        jButton2.setAlignmentY(1.0f);
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel("Examples:  dna repair   |   p53");
        jLabel.setBorder(new EmptyBorder(n, 10, 5, 5));
        jPanel.add(jLabel);
        return jPanel;
    }

    private JComboBox createResultLimitComboBox() {
        Vector vector = MaxHitsOption.getAllOptions();
        JComboBox jComboBox = new JComboBox(vector);
        UpdateSearchRequest updateSearchRequest = new UpdateSearchRequest(this.searchRequest);
        jComboBox.addActionListener(updateSearchRequest);
        return jComboBox;
    }

    private JComboBox createOrganismComboBox() {
        Vector vector = OrganismOption.getAllOptions();
        JComboBox jComboBox = new JComboBox(vector);
        UpdateSearchRequest updateSearchRequest = new UpdateSearchRequest(this.searchRequest);
        jComboBox.addActionListener(updateSearchRequest);
        return jComboBox;
    }

    public void update(Observable observable, Object object) {
        int n = searchList.getNumSearchBundles();
        SearchBundle searchBundle = searchList.getSearchBundleByIndex(n - 1);
        SearchResponse searchResponse = searchBundle.getResponse();
        Throwable throwable = searchResponse.getException();
        if (throwable != null) {
            if (throwable instanceof EmptySetException) {
                String string = "No Matching Results Found.  Please Try Again.";
                JOptionPane.showMessageDialog(this, string, "cPath PlugIn", 1);
            } else if (!(throwable instanceof InterruptedException)) {
                this.showError(throwable);
            }
        } else {
            CyNetwork cyNetwork = searchResponse.getCyNetwork();
            FlagFilter flagFilter = cyNetwork.getFlagger();
            DisplayDetails displayDetails = new DisplayDetails(this.cyMap, this.userSelection);
            flagFilter.addFlagEventListener((FlagEventListener)displayDetails);
            cyNetwork.putClientData("CPATH_LISTENER", (Object)displayDetails);
        }
        this.searchButton.setEnabled(true);
    }

    private void showError(Throwable throwable) {
        ErrorDisplay errorDisplay = new ErrorDisplay(this);
        errorDisplay.displayError(throwable, this.consolePanel);
    }
}

