/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.ui;

import csplugins.dataviewer.ui.ConsolePanel;
import java.awt.Frame;
import javax.swing.JOptionPane;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.mapper.MapperException;

public class ErrorDisplay {
    private Frame parent;
    private static final int WIDTH = 50;
    private static final char SPACE = ' ';
    private static final String NEW_LINE = "\n";

    public ErrorDisplay(Frame frame) {
        this.parent = frame;
    }

    public void displayError(Throwable throwable) {
        this.showError(throwable);
    }

    private String showError(Throwable throwable) {
        throwable.printStackTrace();
        String string = null;
        if (throwable instanceof DataServiceException) {
            DataServiceException dataServiceException = (DataServiceException)throwable;
            string = new String("An Error Has Occurred:  " + dataServiceException.getHumanReadableErrorMessage());
        } else if (throwable instanceof MapperException) {
            MapperException mapperException = (MapperException)throwable;
            string = new String("An Error Has Occurred:  " + mapperException.getHumanReadableErrorMessage());
        } else {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 == null) {
                throwable2 = throwable;
            }
            string = new String("An Error Has Occurred:  " + throwable.toString());
        }
        string = this.wrapText(string);
        JOptionPane.showMessageDialog(this.parent, string, "Error", 0);
        return string;
    }

    public void displayError(Throwable throwable, ConsolePanel consolePanel) {
        String string = this.showError(throwable);
        consolePanel.logMessage(string);
    }

    public void displayError(String string) {
        String string2 = this.wrapText(string);
        JOptionPane.showMessageDialog(this.parent, string2, "Error", 0);
    }

    public String wrapText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\s+");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + ' ');
            if ((n += stringArray[i].length()) <= 50) continue;
            stringBuffer.append(NEW_LINE);
            n = 0;
        }
        if (stringBuffer.length() > 500) {
            return stringBuffer.substring(0, 500) + "...";
        }
        return stringBuffer.toString();
    }
}

