/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.tools;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SourceGenerator;

public class XSDCompiler
extends Task {
    private File schema;
    private String pkgName;
    private String lineSep;
    private boolean force;
    private String typeFactory;
    private File destDir;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.schema == null || !this.schema.exists()) {
            throw new BuildException("Schema file is required");
        }
        if (this.lineSep != null) {
            if ("win".equals(this.lineSep) || "\r\n".equals(this.lineSep)) {
                this.project.log("Using Windows style line separation.", 3);
                this.lineSep = "\r\n";
            } else if ("unix".equals(this.lineSep) || "\n".equals(this.lineSep)) {
                this.project.log("Using UNIX style line separation.", 3);
                this.lineSep = "\n";
            } else {
                if (!"mac".equals(this.lineSep) && !"\r".equals(this.lineSep)) throw new BuildException("Invalid line-separator style.");
                this.project.log("Using Macintosh style line separation.", 3);
                this.lineSep = "\r";
            }
        } else {
            this.lineSep = "\n";
        }
        SourceGenerator sgen = null;
        if (this.typeFactory != null) {
            try {
                sgen = new SourceGenerator((FieldInfoFactory)Class.forName(this.typeFactory).newInstance());
            }
            catch (Exception ex) {
                this.project.log("Type factory " + this.typeFactory + " is invalid.", 2);
                throw new BuildException(ex);
            }
        } else {
            sgen = new SourceGenerator();
        }
        sgen.setLineSeparator(this.lineSep);
        sgen.setSuppressNonFatalWarnings(this.force);
        sgen.setDestDir(this.destDir.toString());
        if (this.force) {
            this.project.log("Suppressing non fatal warnings.", 3);
        }
        try {
            sgen.generateSource(this.schema.getAbsolutePath(), this.pkgName);
            return;
        }
        catch (IOException ex) {
            this.project.log("Failed to compile " + this.schema, 2);
            throw new BuildException(ex);
        }
    }

    public void setSchema(String schema) {
        this.schema = this.project.resolveFile(schema);
    }

    public void setPackage(String pkgName) {
        this.pkgName = pkgName;
    }

    public void setLineseperator(String lineSep) {
        this.lineSep = lineSep;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setTypefactory(String typeFactory) {
        this.typeFactory = typeFactory;
    }

    public void setDestdir(String dirName) {
        this.destDir = this.project.resolveFile(dirName);
    }
}

