/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.core;

import java.io.File;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.mskcc.dataservices.core.DataServiceDescription;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.services.DataService;
import org.mskcc.dataservices.util.PropertyManager;

public class ServiceLoader {
    private static final String DATA_SERVICE_DIR = "dataservices";
    private static final String XML_EXTENSION = ".xml";
    private static final String ID_ELEMENT = "id";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String VERSION_ELEMENT = "version";
    private static final String PROVIDER_ELEMENT = "provider";
    private static final String CLASS_ELEMENT = "class_name";
    private static final String DEFAULT_LOCATION_ELEMENT = "default_location";
    private ArrayList services;
    static /* synthetic */ Class class$org$mskcc$dataservices$live$interaction$ReadPsiFromCPath;
    static /* synthetic */ Class class$org$mskcc$dataservices$live$interaction$ReadPsiFromFileOrWeb;
    static /* synthetic */ Class class$org$mskcc$dataservices$live$interaction$ReadSifFromFileOrWeb;
    static /* synthetic */ Class class$org$mskcc$dataservices$live$mapper$LocalAliasToGiMapper;
    static /* synthetic */ Class class$org$mskcc$dataservices$live$state$ReadSoftFromFileOrWeb;
    static /* synthetic */ Class class$org$mskcc$dataservices$live$state$ReadExpressionFromFileOrWeb;
    static /* synthetic */ Class class$org$mskcc$dataservices$live$interaction$WritePsiToCPath;

    public ArrayList getAllServices() throws DataServiceException {
        this.services = new ArrayList();
        boolean bl = this.directoryExists();
        if (bl) {
            File file = new File(DATA_SERVICE_DIR);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!string.endsWith(XML_EXTENSION)) continue;
                this.parseManifestFile(string, this.services);
            }
        }
        this.bootStrapServices();
        return this.services;
    }

    private void bootStrapServices() {
        PropertyManager propertyManager = PropertyManager.getInstance();
        String string = propertyManager.getProperty(PropertyManager.CPATH_READ_LOCATION);
        String string2 = propertyManager.getProperty(PropertyManager.CPATH_WRITE_LOCATION);
        String string3 = propertyManager.getProperty(PropertyManager.NCBI_LOCATION);
        String string4 = propertyManager.getProperty(PropertyManager.SEQ_HOUND_LOCATION);
        String string5 = "1.0";
        String string6 = "MSKCC";
        String string7 = "Reads PSI-MI interaction data from the CPath Data Server.";
        DataServiceDescription dataServiceDescription = new DataServiceDescription("READ_PSI_FROM_CPATH", string7, string5, string6, class$org$mskcc$dataservices$live$interaction$ReadPsiFromCPath == null ? (class$org$mskcc$dataservices$live$interaction$ReadPsiFromCPath = ServiceLoader.class$("org.mskcc.dataservices.live.interaction.ReadPsiFromCPath")) : class$org$mskcc$dataservices$live$interaction$ReadPsiFromCPath, string);
        this.services.add(dataServiceDescription);
        string7 = "Reads PSI-MI Data from local file or web.";
        dataServiceDescription = new DataServiceDescription("READ_PSI_FROM_FILE_OR_WEB", string7, string5, string6, class$org$mskcc$dataservices$live$interaction$ReadPsiFromFileOrWeb == null ? (class$org$mskcc$dataservices$live$interaction$ReadPsiFromFileOrWeb = ServiceLoader.class$("org.mskcc.dataservices.live.interaction.ReadPsiFromFileOrWeb")) : class$org$mskcc$dataservices$live$interaction$ReadPsiFromFileOrWeb, "");
        this.services.add(dataServiceDescription);
        string7 = "Reads Interaction (Sif) Data from local file or web.";
        dataServiceDescription = new DataServiceDescription("READ_SIF_FROM_FILE_OR_WEB", string7, string5, string6, class$org$mskcc$dataservices$live$interaction$ReadSifFromFileOrWeb == null ? (class$org$mskcc$dataservices$live$interaction$ReadSifFromFileOrWeb = ServiceLoader.class$("org.mskcc.dataservices.live.interaction.ReadSifFromFileOrWeb")) : class$org$mskcc$dataservices$live$interaction$ReadSifFromFileOrWeb, "");
        this.services.add(dataServiceDescription);
        string7 = "Maps Yeast Aliases to GI Numbers.";
        dataServiceDescription = new DataServiceDescription("yeast_mapper", string7, string5, string6, class$org$mskcc$dataservices$live$mapper$LocalAliasToGiMapper == null ? (class$org$mskcc$dataservices$live$mapper$LocalAliasToGiMapper = ServiceLoader.class$("org.mskcc.dataservices.live.mapper.LocalAliasToGiMapper")) : class$org$mskcc$dataservices$live$mapper$LocalAliasToGiMapper, "data/idmap.txt");
        this.services.add(dataServiceDescription);
        string7 = "Reads SOFT Formatted Gene Expression Data from local file or web";
        dataServiceDescription = new DataServiceDescription("READ_SOFT_FROM_FILE_OR_WEB", string7, string5, string6, class$org$mskcc$dataservices$live$state$ReadSoftFromFileOrWeb == null ? (class$org$mskcc$dataservices$live$state$ReadSoftFromFileOrWeb = ServiceLoader.class$("org.mskcc.dataservices.live.state.ReadSoftFromFileOrWeb")) : class$org$mskcc$dataservices$live$state$ReadSoftFromFileOrWeb, "");
        this.services.add(dataServiceDescription);
        string7 = "Reads Gene Expression Data from local file or web";
        dataServiceDescription = new DataServiceDescription("READ_EXPRESSION_FROM_FILE_OR_WEB", string7, string5, string6, class$org$mskcc$dataservices$live$state$ReadExpressionFromFileOrWeb == null ? (class$org$mskcc$dataservices$live$state$ReadExpressionFromFileOrWeb = ServiceLoader.class$("org.mskcc.dataservices.live.state.ReadExpressionFromFileOrWeb")) : class$org$mskcc$dataservices$live$state$ReadExpressionFromFileOrWeb, "");
        this.services.add(dataServiceDescription);
        string7 = "Writes PSI-MI Interactions to CPath";
        dataServiceDescription = new DataServiceDescription("write_interactions_to_cpath", string7, string5, string6, class$org$mskcc$dataservices$live$interaction$WritePsiToCPath == null ? (class$org$mskcc$dataservices$live$interaction$WritePsiToCPath = ServiceLoader.class$("org.mskcc.dataservices.live.interaction.WritePsiToCPath")) : class$org$mskcc$dataservices$live$interaction$WritePsiToCPath, string2);
        this.services.add(dataServiceDescription);
    }

    private boolean directoryExists() {
        File file = new File(DATA_SERVICE_DIR);
        boolean bl = file.exists();
        return bl;
    }

    private void parseManifestFile(String string, ArrayList arrayList) throws DataServiceException {
        File file = new File(DATA_SERVICE_DIR, string);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        try {
            document = sAXBuilder.build(file);
            Element element = document.getRootElement();
            String string2 = element.getChildTextNormalize(ID_ELEMENT);
            String string3 = element.getChildTextNormalize(DESCRIPTION_ELEMENT);
            String string4 = element.getChildTextNormalize(VERSION_ELEMENT);
            String string5 = element.getChildTextNormalize(PROVIDER_ELEMENT);
            String string6 = element.getChildTextNormalize(CLASS_ELEMENT);
            String string7 = element.getChildTextNormalize(DEFAULT_LOCATION_ELEMENT);
            DataServiceDescription dataServiceDescription = new DataServiceDescription(string2, string3, string4, string5, string6, string7);
            boolean bl = this.classNameIsValid(dataServiceDescription);
            if (bl) {
                arrayList.add(dataServiceDescription);
            }
        }
        catch (JDOMException jDOMException) {
            throw new DataServiceException(jDOMException, "Could not parse the data service XML manifest file:  " + file);
        }
    }

    private boolean classNameIsValid(DataServiceDescription dataServiceDescription) {
        boolean bl = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(dataServiceDescription.getClassName());
            Object obj = clazz.newInstance();
            if (obj instanceof DataService) {
                bl = true;
            } else {
                this.warning(dataServiceDescription, "Service class does not implement DataService interface:  " + clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.warning(dataServiceDescription, "Service class not found:  " + clazz);
        }
        catch (InstantiationException instantiationException) {
            this.warning(dataServiceDescription, "Service class could not be instantiated:  " + clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.warning(dataServiceDescription, "Illegal Access when instantiating service class:  " + clazz);
        }
        return bl;
    }

    private void warning(DataServiceDescription dataServiceDescription, String string) {
        System.err.println("Warning:  An Error has occurred while trying to load a data services plugin.");
        System.err.println("Error occured while loading id:  " + dataServiceDescription.getId());
        System.err.println("Error Message:  " + string);
        System.err.println("Because of the error, this data service will not be available to your application.");
        System.err.println("To fix this error, check your data services plugin configuration file and/or your classpath.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

