/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.live;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.mskcc.dataservices.core.DataServiceDescription;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.core.ServiceLoader;
import org.mskcc.dataservices.core.UnknownDataServiceException;
import org.mskcc.dataservices.live.cached.CachedAliasToGiMapper;
import org.mskcc.dataservices.live.cached.CachedDataService;
import org.mskcc.dataservices.live.cached.CachedInteractionReader;
import org.mskcc.dataservices.live.cached.CachedInteractorReader;
import org.mskcc.dataservices.live.cached.CachedStateReader;
import org.mskcc.dataservices.services.AliasToGiMapper;
import org.mskcc.dataservices.services.DataService;
import org.mskcc.dataservices.services.ReadInteractions;
import org.mskcc.dataservices.services.ReadInteractors;
import org.mskcc.dataservices.services.ReadStateInformation;

public class DataServiceFactory {
    private HashMap services = new HashMap();
    private static DataServiceFactory factory;

    private DataServiceFactory() throws DataServiceException {
        this.initServices();
    }

    public static DataServiceFactory getInstance() throws DataServiceException {
        if (factory == null) {
            factory = new DataServiceFactory();
        }
        return factory;
    }

    public DataServiceDescription getServiceDescription(String string) throws UnknownDataServiceException {
        DataServiceDescription dataServiceDescription = (DataServiceDescription)this.services.get(string);
        if (dataServiceDescription == null) {
            throw new UnknownDataServiceException("Could not locate  service id:  " + string);
        }
        return dataServiceDescription;
    }

    public DataService getService(String string) throws UnknownDataServiceException {
        try {
            DataServiceDescription dataServiceDescription = this.getServiceDescription(string);
            DataService dataService = this.instantiateService(dataServiceDescription.getClassName());
            if (dataServiceDescription.getDefaultLocation() != null) {
                dataService.setLocation(dataServiceDescription.getDefaultLocation());
            }
            DataService dataService2 = this.wrapInCachedService(dataService);
            return dataService2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnknownDataServiceException(classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new UnknownDataServiceException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnknownDataServiceException(illegalAccessException.getMessage());
        }
    }

    private DataService wrapInCachedService(DataService dataService) {
        CachedDataService cachedDataService = null;
        if (dataService instanceof ReadInteractors) {
            cachedDataService = new CachedInteractorReader((ReadInteractors)dataService);
        } else if (dataService instanceof ReadInteractions) {
            cachedDataService = new CachedInteractionReader((ReadInteractions)dataService);
        } else if (dataService instanceof AliasToGiMapper) {
            cachedDataService = new CachedAliasToGiMapper((AliasToGiMapper)dataService);
        } else if (dataService instanceof ReadStateInformation) {
            cachedDataService = new CachedStateReader((ReadStateInformation)dataService);
        } else {
            return dataService;
        }
        return cachedDataService;
    }

    public void registerService(DataServiceDescription dataServiceDescription) throws DataServiceException {
        if (this.services.containsKey(dataServiceDescription.getId())) {
            throw new DataServiceException("The data service:  " + dataServiceDescription.getId() + " could not be registered " + "because a service with this ID already exists.");
        }
        this.services.put(dataServiceDescription.getId(), dataServiceDescription);
    }

    public void registerService(String string, String string2, String string3, String string4, String string5, String string6) throws DataServiceException {
        DataServiceDescription dataServiceDescription = new DataServiceDescription(string, string2, string3, string4, string5, string6);
        this.registerService(dataServiceDescription);
    }

    public ArrayList listServiceDescriptions() {
        ArrayList<DataServiceDescription> arrayList = new ArrayList<DataServiceDescription>();
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            DataServiceDescription dataServiceDescription = (DataServiceDescription)iterator.next();
            arrayList.add(dataServiceDescription);
        }
        return arrayList;
    }

    private DataService instantiateService(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(string);
        Object obj = clazz.newInstance();
        return (DataService)obj;
    }

    private void initServices() throws DataServiceException {
        ServiceLoader serviceLoader = new ServiceLoader();
        ArrayList arrayList = serviceLoader.getAllServices();
        for (int i = 0; i < arrayList.size(); ++i) {
            DataServiceDescription dataServiceDescription = (DataServiceDescription)arrayList.get(i);
            this.registerService(dataServiceDescription);
        }
    }
}

