/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mskcc.dataservices.core.DataServiceException;

public class ContentReader {
    private static final String HTTP = "http";
    private static final String FTP = "ftp";

    public String retrieveContent(String string) throws DataServiceException {
        String string2 = null;
        URL uRL = null;
        try {
            if (string.startsWith(HTTP) || string.startsWith(FTP)) {
                uRL = new URL(string);
                if (uRL.getProtocol().equalsIgnoreCase(HTTP)) {
                    string2 = this.retrieveContentFromWeb(uRL);
                }
                if (uRL.getProtocol().equalsIgnoreCase(FTP)) {
                    string2 = this.retrieveContentFromFtp(uRL);
                }
            } else {
                File file = new File(string);
                string2 = this.retrieveContentFromFile(file);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new DataServiceException(malformedURLException, "URL is malformed:  " + uRL + ".  Please try again.");
        }
        catch (UnknownHostException unknownHostException) {
            String string3 = "Network error occurred while tring to make network connection.  Could not find server:  " + unknownHostException.getMessage() + ". Please check your server and network settings, " + "and try again.";
            throw new DataServiceException(unknownHostException, string3);
        }
        catch (HttpException httpException) {
            String string4 = new String("Error Connecting to URL:  " + uRL + " (Details:  HTTP Status Code:  " + httpException.getReasonCode() + " --> " + httpException.getReason() + ")");
            throw new DataServiceException(string4);
        }
        catch (IOException iOException) {
            throw new DataServiceException(iOException, "Error occurred  while trying to retrieve data from:  " + string);
        }
        return string2;
    }

    private String retrieveContentFromWeb(URL uRL) throws IOException, HttpException, DataServiceException {
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(uRL.toString());
        httpClient.executeMethod(getMethod);
        if (getMethod.getStatusCode() == 200) {
            String string = getMethod.getResponseBodyAsString();
            return string;
        }
        String string = new String("Error Connecting to URL:  " + uRL + " (Details:  HTTP Status Code:  " + getMethod.getStatusCode() + " --> " + getMethod.getStatusLine().getReasonPhrase() + ")");
        throw new DataServiceException(string);
    }

    private URL addAuthorizationToUrl(URL uRL) throws MalformedURLException {
        String string = uRL.getProtocol();
        String string2 = uRL.getUserInfo();
        String string3 = uRL.getHost();
        int n = uRL.getPort();
        String string4 = uRL.getFile();
        if (string2 == null || string2.length() == 0) {
            string2 = "anonymous:anon@ftp.net";
        }
        return new URL(string + "://" + string2 + "@" + string3 + ":" + n + string4);
    }

    private String retrieveContentFromFtp(URL uRL) throws IOException {
        URL uRL2 = this.addAuthorizationToUrl(uRL);
        InputStreamReader inputStreamReader = new InputStreamReader(uRL2.openStream());
        char[] cArray = new char[65536];
        String string = "";
        int n = 0;
        while ((n = inputStreamReader.read(cArray, 0, 65536)) != -1) {
            String string2 = new String(cArray, 0, n);
            string = string + string2;
        }
        return string;
    }

    private String retrieveContentFromFile(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
            string = bufferedReader.readLine();
        }
        return stringBuffer.toString();
    }
}

