/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.ColorPanel;
import BiNGO.SettingsSavePanel;
import BiNGO.SignificantFigures;
import BiNGO.SpringEmbeddedLayouter;
import BiNGO.TestCalculator;
import BiNGO.TheVisualStyle;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.annotation.Ontology;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class DisplayBiNGOWindow {
    private HashMap testMap;
    private HashMap correctionMap;
    private HashMap mapSmallX;
    private HashMap mapSmallN;
    private Integer bigX;
    private Integer bigN;
    private String alpha;
    private String clusterName;
    private SettingsSavePanel dataPanel;
    private String categoriesString;
    private Ontology ontology;
    private final Double DEFAULT_SIZE = new Double(1.0);
    private final int MAX_SIZE = 50;
    private final String SIFFILENAME = "BiNGO.sif";
    private final String CATEGORY_ALL = "All categories";
    private final String CATEGORY_BEFORE_CORRECTION = "Overrepresented categories before correction";
    private final String CATEGORY_CORRECTION = "Overrepresented categories after correction";
    private static final int SCALE_RESULT = 100;
    private final String NONE = "---";

    public DisplayBiNGOWindow(HashMap testMap, HashMap correctionMap, HashMap mapSmallX, HashMap mapSmallN, int bigX, int bigN, String alpha, Ontology ontology, String clusterName, SettingsSavePanel dataPanel, String categoriesString) {
        this.testMap = testMap;
        this.correctionMap = correctionMap;
        this.mapSmallX = mapSmallX;
        this.mapSmallN = mapSmallN;
        this.bigX = new Integer(bigX);
        this.bigN = new Integer(bigN);
        this.alpha = alpha;
        this.ontology = ontology;
        this.clusterName = clusterName;
        this.dataPanel = dataPanel;
        this.categoriesString = categoriesString;
    }

    public void makeWindow() {
        CyNetwork network = this.buildNetwork();
        this.buildNodeAttributes(network);
        this.buildEdgeAttributes(network);
        CyNetworkView bingoCyNetworkView = Cytoscape.createNetworkView((CyNetwork)network, (String)this.clusterName);
        Iterator in = bingoCyNetworkView.getNodeViewsIterator();
        while (in.hasNext()) {
            NodeView nv = (NodeView)in.next();
            nv.setXPosition(nv.getXPosition() * Math.random());
            nv.setYPosition((nv.getYPosition() + 100.0) * Math.random());
        }
        SpringEmbeddedLayouter spring = new SpringEmbeddedLayouter((GraphView)bingoCyNetworkView);
        TestCalculator tc = new TestCalculator(spring);
        tc.run();
        Cytoscape.getDesktop().toFront();
        bingoCyNetworkView.fitContent();
        TheVisualStyle vs = new TheVisualStyle(this.clusterName, new Double(this.alpha));
        VisualStyle visualStyle = vs.createVisualStyle(network);
        CytoscapeDesktop cytoscapedesktop = Cytoscape.getDesktop();
        VisualMappingManager vmm = cytoscapedesktop.getVizMapManager();
        VisualStyle oldStyle = vmm.setVisualStyle(visualStyle);
        bingoCyNetworkView.applyVizmapper(visualStyle);
        JFrame window = new JFrame(this.clusterName + " Color Scale");
        String alpha1 = SignificantFigures.sci_format(this.alpha, 3);
        String tmp = new BigDecimal(this.alpha).divide(new BigDecimal("100000"), 100, 4).toString();
        String alpha2 = SignificantFigures.sci_format(tmp, 3);
        ColorPanel colPanel = new ColorPanel(alpha1, alpha2, new Color(255, 255, 0), new Color(255, 127, 0));
        window.getContentPane().add(colPanel);
        window.getContentPane().setBackground(Color.WHITE);
        window.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        window.pack();
        window.setLocation(screenSize.width - window.getWidth() - 10, screenSize.height - window.getHeight() - 30);
        window.setVisible(true);
        window.setResizable(false);
    }

    public CyNetwork buildNetwork() {
        HashSet set = this.testMap != null ? new HashSet(this.testMap.keySet()) : new HashSet(this.mapSmallX.keySet());
        Iterator iterator = set.iterator();
        HashSet<String> sifSet = new HashSet<String>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        CyNetwork network = Cytoscape.createNetwork((String)this.clusterName);
        while (iterator.hasNext()) {
            int termID = new Integer(iterator.next().toString());
            if (!this.categoriesString.equals("All categories") && (!this.categoriesString.equals("Overrepresented categories before correction") || new BigDecimal(this.testMap.get(new Integer(termID)).toString()).compareTo(new BigDecimal(this.alpha)) >= 0) && (!this.categoriesString.equals("Overrepresented categories after correction") || new BigDecimal(this.correctionMap.get(termID + "").toString()).compareTo(new BigDecimal(this.alpha)) >= 0)) continue;
            int[][] paths = this.ontology.getAllHierarchyPaths(termID);
            for (int i = 0; i < paths.length; ++i) {
                int previousNode = paths[i][0];
                if (paths.length == 1 && paths[i].length == 1) {
                    sifSet.add(previousNode + "\n");
                }
                nameMap.put(this.ontology.getTerm(previousNode).getName(), nameMap.get(this.ontology.getTerm(previousNode).getName()) + " " + previousNode);
                for (int j = 1; j < paths[i].length; ++j) {
                    nameMap.put(this.ontology.getTerm(paths[i][j]).getName(), nameMap.get(this.ontology.getTerm(paths[i][j]).getName()) + " " + paths[i][j]);
                    sifSet.add(previousNode + " pp " + paths[i][j] + "\n");
                    previousNode = paths[i][j];
                }
            }
        }
        HashMap termIdMap = this.makeTermIdMap(nameMap);
        Iterator sifIterator = sifSet.iterator();
        while (sifIterator.hasNext()) {
            String writeString = sifIterator.next().toString();
            StringTokenizer st = new StringTokenizer(writeString);
            String firstTermId = termIdMap.get(st.nextToken()).toString();
            if (st.hasMoreTokens()) {
                st.nextToken();
                String secondTermId = termIdMap.get(st.nextToken()).toString();
                CyNode node1 = Cytoscape.getCyNode((String)firstTermId, (boolean)true);
                CyNode node2 = Cytoscape.getCyNode((String)secondTermId, (boolean)true);
                CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node2, (String)"interaction", (Object)"pp", (boolean)true);
                network.addNode((Node)node1);
                network.addNode((Node)node2);
                network.addEdge((Edge)edge);
                continue;
            }
            CyNode node1 = Cytoscape.getCyNode((String)firstTermId, (boolean)true);
            network.addNode((Node)node1);
        }
        return network;
    }

    public HashMap makeTermIdMap(HashMap nameMap) {
        HashSet set = new HashSet(nameMap.keySet());
        Iterator iterator = set.iterator();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String valueIDs = nameMap.get(iterator.next().toString()).toString().substring(5);
            StringTokenizer st = new StringTokenizer(valueIDs);
            String termID = st.nextToken();
            resultMap.put(termID, termID);
            while (st.hasMoreTokens()) {
                resultMap.put(st.nextToken(), termID);
            }
        }
        return resultMap;
    }

    public void buildNodeAttributes(CyNetwork network) {
        Iterator i = network.nodesIterator();
        while (i.hasNext()) {
            Double size;
            Double color;
            String smallN;
            String smallX;
            String adj_pValue;
            String pValue;
            String description;
            Node node = (Node)i.next();
            String termID = node.getIdentifier();
            String shape = "ellipse";
            try {
                description = this.ontology.getTerm(Integer.parseInt(termID)).getName();
            }
            catch (Exception e) {
                description = "?";
            }
            try {
                pValue = this.testMap != null ? SignificantFigures.sci_format(this.testMap.get(new Integer(termID)).toString(), 5) : "N/A";
            }
            catch (Exception e) {
                pValue = "N/A";
            }
            try {
                adj_pValue = this.correctionMap != null ? SignificantFigures.sci_format(this.correctionMap.get(termID).toString(), 5) : "N/A";
            }
            catch (Exception e) {
                adj_pValue = "N/A";
            }
            try {
                smallX = this.mapSmallX.get(new Integer(termID)).toString();
            }
            catch (Exception e) {
                smallX = "N/A";
            }
            try {
                smallN = this.mapSmallN.get(new Integer(termID)).toString();
            }
            catch (Exception e) {
                smallN = "N/A";
            }
            try {
                if (this.testMap == null) {
                    color = new Double(0.0);
                } else if (this.correctionMap == null) {
                    double a = -(Math.log(new BigDecimal(this.testMap.get(new Integer(termID)).toString()).doubleValue()) / Math.log(10.0));
                    color = new Double(a);
                } else {
                    double a = -(Math.log(new BigDecimal(this.correctionMap.get(termID).toString()).doubleValue()) / Math.log(10.0));
                    color = new Double(a);
                }
            }
            catch (Exception e) {
                color = new Double(0.0);
            }
            try {
                double numberOfGenes = new Integer(this.mapSmallX.get(new Integer(termID)).toString()).doubleValue();
                numberOfGenes = Math.sqrt(numberOfGenes) * 2.0;
                size = new Double(numberOfGenes);
            }
            catch (Exception e) {
                size = this.DEFAULT_SIZE;
            }
            network.setNodeAttributeValue(node, "pValue_" + this.clusterName, (Object)pValue);
            network.setNodeAttributeValue(node, "adjustedPValue_" + this.clusterName, (Object)adj_pValue);
            network.setNodeAttributeValue(node, "x_" + this.clusterName, (Object)smallX);
            network.setNodeAttributeValue(node, "X_" + this.clusterName, (Object)this.bigX);
            network.setNodeAttributeValue(node, "n_" + this.clusterName, (Object)smallN);
            network.setNodeAttributeValue(node, "N_" + this.clusterName, (Object)this.bigN);
            network.setNodeAttributeValue(node, "description_" + this.clusterName, (Object)description);
            network.setNodeAttributeValue(node, "nodeFillColor_" + this.clusterName, (Object)color);
            network.setNodeAttributeValue(node, "nodeSize_" + this.clusterName, (Object)size);
            network.setNodeAttributeValue(node, "nodeType_" + this.clusterName, (Object)shape);
        }
    }

    public void buildEdgeAttributes(CyNetwork network) {
        Iterator i = network.edgesIterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            network.setEdgeAttributeValue(edge, "edgeType_" + this.clusterName, (Object)"black");
        }
    }
}

