/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.persist.spi.Complex;

public class SQLRelationLoader {
    private String tableName;
    private int[] leftType;
    private TypeConvertor[] leftTo;
    private TypeConvertor[] leftFrom;
    private String[] leftParam;
    private TypeConvertor[] rightTo;
    private TypeConvertor[] rightFrom;
    private String[] rightParam;
    private int[] rightType;
    private String[] left;
    private String[] right;
    private String select;
    private String insert;
    private String delete;
    private String deleteAll;

    public SQLRelationLoader(String table, String[] key, int[] keyType, TypeConvertor[] idTo, TypeConvertor[] idFrom, String[] idParam, String[] otherKey, int[] otherKeyType, TypeConvertor[] ridTo, TypeConvertor[] ridFrom, String[] ridParam) {
        this.leftTo = idTo;
        this.leftFrom = idFrom;
        this.leftParam = idParam;
        this.rightTo = ridTo;
        this.rightFrom = ridFrom;
        this.rightParam = ridParam;
        this.tableName = table;
        this.left = key;
        this.right = otherKey;
        this.leftType = keyType;
        this.rightType = otherKeyType;
        StringBuffer sb = new StringBuffer();
        int count = 0;
        sb.append("SELECT ");
        int i = 0;
        while (i < this.left.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.left[i]);
            ++count;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.right.length) {
            sb.append(",");
            sb.append(this.right[i2]);
            ++count;
            ++i2;
        }
        sb.append(" FROM ");
        sb.append(this.tableName);
        sb.append(" WHERE ");
        int i3 = 0;
        while (i3 < this.left.length) {
            if (i3 > 0) {
                sb.append(" AND ");
            }
            sb.append(this.left[i3]);
            sb.append("=?");
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.right.length) {
            sb.append(" AND ");
            sb.append(this.right[i4]);
            sb.append("=?");
            ++i4;
        }
        this.select = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("INSERT INTO ");
        sb.append(this.tableName);
        sb.append(" (");
        int i5 = 0;
        while (i5 < this.left.length) {
            if (i5 > 0) {
                sb.append(",");
            }
            sb.append(this.left[i5]);
            ++count;
            ++i5;
        }
        int i6 = 0;
        while (i6 < this.right.length) {
            sb.append(",");
            sb.append(this.right[i6]);
            ++count;
            ++i6;
        }
        sb.append(") VALUES (");
        int i7 = 0;
        while (i7 < count) {
            if (i7 > 0) {
                sb.append(",");
            }
            sb.append("?");
            ++i7;
        }
        sb.append(")");
        this.insert = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("DELETE FROM ");
        sb.append(this.tableName);
        sb.append(" WHERE ");
        int i8 = 0;
        while (i8 < this.left.length) {
            if (i8 > 0) {
                sb.append(" AND ");
            }
            sb.append(this.left[i8]);
            sb.append("=?");
            ++i8;
        }
        int i9 = 0;
        while (i9 < this.right.length) {
            sb.append(" AND ");
            sb.append(this.right[i9]);
            sb.append("=?");
            ++i9;
        }
        this.delete = sb.toString();
        sb = new StringBuffer();
        count = 0;
        sb.append("DELETE FROM ");
        sb.append(this.tableName);
        sb.append(" WHERE ");
        int i10 = 0;
        while (i10 < this.left.length) {
            if (i10 > 0) {
                sb.append(" AND ");
            }
            sb.append(this.left[i10]);
            sb.append("=?");
            ++i10;
        }
        this.deleteAll = sb.toString();
    }

    private Object idToSQL(int index, Object object) throws PersistenceException {
        if (object == null || this.leftFrom[index] == null) {
            return object;
        }
        return this.leftFrom[index].convert(object, this.leftParam[index]);
    }

    private Object ridToSQL(int index, Object object) throws PersistenceException {
        if (object == null || this.rightFrom[index] == null) {
            return object;
        }
        return this.rightFrom[index].convert(object, this.rightParam[index]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createRelation(Connection conn, Object leftValue, Object rightValue) throws PersistenceException {
        ResultSet rset = null;
        PreparedStatement selectStatement = null;
        Statement insertStatement = null;
        try {
            try {
                Complex right;
                int i;
                Complex left;
                int count = 1;
                selectStatement = conn.prepareStatement(this.select);
                if (this.leftType.length > 1) {
                    left = (Complex)leftValue;
                    i = 0;
                    while (i < left.size()) {
                        selectStatement.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                        ++count;
                        ++i;
                    }
                } else {
                    selectStatement.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
                    ++count;
                }
                if (this.rightType.length > 1) {
                    right = (Complex)rightValue;
                    i = 0;
                    while (i < right.size()) {
                        selectStatement.setObject(count, this.ridToSQL(i, right.get(i)), this.rightType[i]);
                        ++count;
                        ++i;
                    }
                } else {
                    selectStatement.setObject(count, this.ridToSQL(0, rightValue), this.rightType[0]);
                }
                count = 1;
                rset = selectStatement.executeQuery();
                insertStatement = conn.prepareStatement(this.insert);
                if (!rset.next()) {
                    if (this.leftType.length > 1) {
                        left = (Complex)leftValue;
                        i = 0;
                        while (i < left.size()) {
                            insertStatement.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                            ++count;
                            ++i;
                        }
                    } else {
                        insertStatement.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
                        ++count;
                    }
                    if (this.rightType.length > 1) {
                        right = (Complex)rightValue;
                        i = 0;
                        while (i < right.size()) {
                            insertStatement.setObject(count, this.ridToSQL(i, right.get(i)), this.rightType[i]);
                            ++count;
                            ++i;
                        }
                    } else {
                        insertStatement.setObject(count, this.ridToSQL(0, rightValue), this.rightType[0]);
                    }
                    int r = insertStatement.executeUpdate();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (rset != null) {
                    rset.close();
                }
                if (selectStatement != null) {
                    selectStatement.close();
                }
                if (insertStatement == null) throw throwable;
                insertStatement.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ex) {}
        if (rset != null) {
            rset.close();
        }
        if (selectStatement != null) {
            selectStatement.close();
        }
        if (insertStatement == null) return;
        insertStatement.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteRelation(Connection conn, Object leftValue) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            try {
                int count = 1;
                stmt = conn.prepareStatement(this.deleteAll);
                if (this.leftType.length > 1) {
                    Complex left = (Complex)leftValue;
                    int i = 0;
                    while (i < left.size()) {
                        stmt.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                        ++count;
                        ++i;
                    }
                } else {
                    stmt.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
                }
                int i = stmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sqle) {}
        if (stmt == null) return;
        stmt.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteRelation(Connection conn, Object leftValue, Object rightValue) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            try {
                int i;
                int count = 1;
                stmt = conn.prepareStatement(this.delete);
                if (this.leftType.length > 1) {
                    Complex left = (Complex)leftValue;
                    i = 0;
                    while (i < left.size()) {
                        stmt.setObject(count, this.idToSQL(i, left.get(i)), this.leftType[i]);
                        ++count;
                        ++i;
                    }
                } else {
                    stmt.setObject(count, this.idToSQL(0, leftValue), this.leftType[0]);
                    ++count;
                }
                if (this.rightType.length > 1) {
                    Complex right = (Complex)rightValue;
                    i = 0;
                    while (i < right.size()) {
                        stmt.setObject(count, this.ridToSQL(i, right.get(i)), this.rightType[i]);
                        ++count;
                        ++i;
                    }
                } else {
                    stmt.setObject(count, this.ridToSQL(0, rightValue), this.rightType[0]);
                }
                int i2 = stmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new PersistenceException(e.toString());
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sqle) {}
        if (stmt == null) return;
        stmt.close();
        return;
    }
}

