/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.test.mapper;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;
import org.mskcc.dataservices.mapper.MapInteractionsToPsi;
import org.mskcc.dataservices.mapper.MapPsiToInteractions;
import org.mskcc.dataservices.schemas.psi.BibrefType;
import org.mskcc.dataservices.schemas.psi.CvType;
import org.mskcc.dataservices.schemas.psi.DbReferenceType;
import org.mskcc.dataservices.schemas.psi.EntrySet;
import org.mskcc.dataservices.schemas.psi.ExperimentList;
import org.mskcc.dataservices.schemas.psi.ExperimentListItem;
import org.mskcc.dataservices.schemas.psi.ExperimentType;
import org.mskcc.dataservices.schemas.psi.InteractionElementType;
import org.mskcc.dataservices.schemas.psi.InteractionList;
import org.mskcc.dataservices.schemas.psi.InteractorList;
import org.mskcc.dataservices.schemas.psi.NamesType;
import org.mskcc.dataservices.schemas.psi.Organism;
import org.mskcc.dataservices.schemas.psi.ParticipantList;
import org.mskcc.dataservices.schemas.psi.ProteinInteractorType;
import org.mskcc.dataservices.schemas.psi.ProteinParticipantType;
import org.mskcc.dataservices.schemas.psi.ProteinParticipantTypeChoice;
import org.mskcc.dataservices.schemas.psi.RefType;
import org.mskcc.dataservices.schemas.psi.XrefType;
import org.mskcc.dataservices.util.ContentReader;

public class TestMapInteractionsToPsi
extends TestCase {
    public void testMapper() throws Exception {
        File file = new File("testData/psi_sample1.xml");
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent(file.toString());
        ArrayList arrayList = new ArrayList();
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        MapInteractionsToPsi mapInteractionsToPsi = new MapInteractionsToPsi(arrayList);
        mapInteractionsToPsi.doMapping();
        EntrySet entrySet = mapInteractionsToPsi.getPsiXml();
        this.validateInteractors(entrySet.getEntry(0).getInteractorList());
        this.validateInteractions(entrySet.getEntry(0).getInteractionList());
        StringWriter stringWriter = new StringWriter();
        entrySet.marshal(stringWriter);
        String string2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<entrySet level=\"1\" version=\"1\" xmlns=\"net:sf:psidev:mi\">\n    <entry>\n        <interactorList>\n";
        TestMapInteractionsToPsi.assertTrue((String)"XML Indentation Test has failed.  This test probably failed because you updated to a new version of Castor.  If so, you need to unjar the castor.jar file, modify the castor.properties file to turn indentation on, and then rejar it.", (boolean)stringWriter.toString().startsWith(string2));
    }

    public void testMapperWithBareBonesData() throws Exception {
        ArrayList<Interaction> arrayList = new ArrayList<Interaction>();
        Interaction interaction = new Interaction();
        Interactor interactor = new Interactor();
        interactor.setName("A");
        Interactor interactor2 = new Interactor();
        interactor2.setName("B");
        ArrayList<Interactor> arrayList2 = new ArrayList<Interactor>();
        arrayList2.add(interactor);
        arrayList2.add(interactor2);
        interaction.setInteractors(arrayList2);
        arrayList.add(interaction);
        MapInteractionsToPsi mapInteractionsToPsi = new MapInteractionsToPsi(arrayList);
        mapInteractionsToPsi.doMapping();
        EntrySet entrySet = mapInteractionsToPsi.getPsiXml();
        StringWriter stringWriter = new StringWriter();
        entrySet.marshal(stringWriter);
        TestMapInteractionsToPsi.assertEquals((boolean)true, (boolean)entrySet.isValid());
    }

    private void validateInteractors(InteractorList interactorList) {
        ProteinInteractorType proteinInteractorType = interactorList.getProteinInteractor(0);
        NamesType namesType = proteinInteractorType.getNames();
        TestMapInteractionsToPsi.assertEquals((String)"YHR119W", (String)namesType.getShortLabel());
        TestMapInteractionsToPsi.assertTrue((boolean)namesType.getFullName().startsWith("Gene has a SET or TROMO"));
        Organism organism = proteinInteractorType.getOrganism();
        TestMapInteractionsToPsi.assertEquals((int)4932, (int)organism.getNcbiTaxId());
        TestMapInteractionsToPsi.assertEquals((String)"baker's yeast", (String)organism.getNames().getShortLabel());
        TestMapInteractionsToPsi.assertEquals((String)"Saccharomyces cerevisiae", (String)organism.getNames().getFullName());
        TestMapInteractionsToPsi.assertEquals((String)"YHR119W", (String)proteinInteractorType.getId());
        XrefType xrefType = proteinInteractorType.getXref();
        DbReferenceType dbReferenceType = xrefType.getPrimaryRef();
        TestMapInteractionsToPsi.assertEquals((String)"Entrez GI", (String)dbReferenceType.getDb());
        TestMapInteractionsToPsi.assertEquals((String)"529135", (String)dbReferenceType.getId());
        dbReferenceType = xrefType.getSecondaryRef(0);
        TestMapInteractionsToPsi.assertEquals((String)"RefSeq GI", (String)dbReferenceType.getDb());
        TestMapInteractionsToPsi.assertEquals((String)"6321911", (String)dbReferenceType.getId());
        String string = proteinInteractorType.getSequence();
        TestMapInteractionsToPsi.assertTrue((boolean)string.startsWith("MNTYAQESKLRLKTKIGAD"));
    }

    private void validateInteractions(InteractionList interactionList) {
        InteractionElementType interactionElementType = interactionList.getInteraction(0);
        ExperimentList experimentList = interactionElementType.getExperimentList();
        ExperimentListItem experimentListItem = experimentList.getExperimentListItem(0);
        ExperimentType experimentType = experimentListItem.getExperimentDescription();
        BibrefType bibrefType = experimentType.getBibref();
        XrefType xrefType = bibrefType.getXref();
        DbReferenceType dbReferenceType = xrefType.getPrimaryRef();
        TestMapInteractionsToPsi.assertEquals((String)"pubmed", (String)dbReferenceType.getDb());
        TestMapInteractionsToPsi.assertEquals((String)"11283351", (String)dbReferenceType.getId());
        CvType cvType = experimentType.getInteractionDetection();
        NamesType namesType = cvType.getNames();
        TestMapInteractionsToPsi.assertEquals((String)"classical two hybrid", (String)namesType.getShortLabel());
        xrefType = cvType.getXref();
        dbReferenceType = xrefType.getPrimaryRef();
        TestMapInteractionsToPsi.assertEquals((String)"PSI-MI", (String)dbReferenceType.getDb());
        TestMapInteractionsToPsi.assertEquals((String)"MI:0018", (String)dbReferenceType.getId());
        ParticipantList participantList = interactionElementType.getParticipantList();
        ProteinParticipantType proteinParticipantType = participantList.getProteinParticipant(0);
        ProteinParticipantTypeChoice proteinParticipantTypeChoice = proteinParticipantType.getProteinParticipantTypeChoice();
        RefType refType = proteinParticipantTypeChoice.getProteinInteractorRef();
        String string = refType.getRef();
        TestMapInteractionsToPsi.assertEquals((String)"YCR038C", (String)string);
        xrefType = interactionElementType.getXref();
        dbReferenceType = xrefType.getPrimaryRef();
        String string2 = dbReferenceType.getDb();
        String string3 = dbReferenceType.getId();
        TestMapInteractionsToPsi.assertEquals((String)"CPATH", (String)string2);
        TestMapInteractionsToPsi.assertEquals((String)"1", (String)string3);
    }
}

