/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.test.mapper;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.mskcc.dataservices.bio.ExternalReference;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;
import org.mskcc.dataservices.mapper.MapPsiToInteractions;
import org.mskcc.dataservices.schemas.psi.types.RoleType;
import org.mskcc.dataservices.util.ContentReader;

public class TestMapPsiToInteractions
extends TestCase {
    public void testPsiMapper1() throws Exception {
        File file = new File("testData/psi_sample1.xml");
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent(file.toString());
        ArrayList arrayList = new ArrayList();
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        Interaction interaction = (Interaction)arrayList.get(1);
        this.validateInteractionFirstSample(interaction);
    }

    public void testPsiMapper2() throws Exception {
        File file = new File("testData/psi_sample2.xml");
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent(file.toString());
        ArrayList arrayList = new ArrayList();
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        Interaction interaction = (Interaction)arrayList.get(0);
        this.validateInteractionSecondSample(interaction);
    }

    public void testPsiMapper3() throws Exception {
        File file = new File("testData/yeast_normalised.xml");
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent(file.toString());
        ArrayList arrayList = new ArrayList();
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        Interaction interaction = (Interaction)arrayList.get(0);
        this.validateInteractionThirdSample(interaction);
    }

    public void testPsiMapper4() throws Exception {
        File file = new File("testData/yeast_denormalised.xml");
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent(file.toString());
        ArrayList arrayList = new ArrayList();
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        Interaction interaction = (Interaction)arrayList.get(0);
        this.validateInteractionFourthSample(interaction);
    }

    public void testDipData1() throws Exception {
        File file = new File("testData/dip_sample.xml");
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent(file.toString());
        ArrayList arrayList = new ArrayList();
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        Interaction interaction = (Interaction)arrayList.get(0);
        ArrayList arrayList2 = interaction.getInteractors();
        Interactor interactor = (Interactor)arrayList2.get(0);
        String string2 = interactor.getName();
        TestMapPsiToInteractions.assertEquals((String)"P06139", (String)string2);
        interactor = (Interactor)arrayList2.get(1);
        string2 = interactor.getName();
        TestMapPsiToInteractions.assertEquals((String)"major prion PrP-Sc protein precursor", (String)string2);
        ExternalReference[] externalReferenceArray = interaction.getExternalRefs();
        TestMapPsiToInteractions.assertEquals((int)1, (int)externalReferenceArray.length);
        TestMapPsiToInteractions.assertEquals((String)"DIP", (String)externalReferenceArray[0].getDatabase());
        TestMapPsiToInteractions.assertEquals((String)"61E", (String)externalReferenceArray[0].getId());
    }

    public void testDipData2() throws Exception {
        File file = new File("testData/dip_sample.xml");
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent(file.toString());
        ArrayList arrayList = new ArrayList();
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        TestMapPsiToInteractions.assertEquals((int)5, (int)arrayList.size());
        Interaction interaction = (Interaction)arrayList.get(0);
        this.validateDipInteractions(interaction, "11821039", "Genetic", "PSI", "MI:0045");
        interaction = (Interaction)arrayList.get(1);
        this.validateDipInteractions(interaction, "9174345", "x-ray crystallography", "PSI", "MI:0114");
        interaction = (Interaction)arrayList.get(4);
        this.validateDipInteractions(interaction, "10089390", "x-ray crystallography", "PSI", "MI:0114");
    }

    private void validateDipInteractions(Interaction interaction, String string, String string2, String string3, String string4) {
        String string5 = (String)interaction.getAttribute("PUB_MED_ID");
        String string6 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        String string7 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_XREF_DB");
        String string8 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_XREF_ID");
        TestMapPsiToInteractions.assertEquals((String)string, (String)string5);
        TestMapPsiToInteractions.assertEquals((String)string2, (String)string6);
        TestMapPsiToInteractions.assertEquals((String)string3, (String)string7);
        TestMapPsiToInteractions.assertEquals((String)string4, (String)string8);
        ArrayList arrayList = interaction.getInteractors();
        TestMapPsiToInteractions.assertEquals((int)2, (int)arrayList.size());
        Interactor interactor = (Interactor)arrayList.get(0);
        TestMapPsiToInteractions.assertEquals((String)"P06139", (String)interactor.getName());
        interactor = (Interactor)arrayList.get(1);
        TestMapPsiToInteractions.assertEquals((String)"major prion PrP-Sc protein precursor", (String)interactor.getName());
    }

    private void validateInteractionFirstSample(Interaction interaction) {
        String string = (String)interaction.getAttribute("PUB_MED_ID");
        String string2 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        TestMapPsiToInteractions.assertEquals((String)"11283351", (String)string);
        TestMapPsiToInteractions.assertEquals((String)"classical two hybrid", (String)string2);
        ArrayList arrayList = interaction.getInteractors();
        Interactor interactor = (Interactor)arrayList.get(0);
        TestMapPsiToInteractions.assertEquals((String)"YCR038C", (String)interactor.getName());
        TestMapPsiToInteractions.assertEquals((Object)"GTP/GDP exchange factor for Rsr1 protein", (Object)interactor.getAttribute("FULL_NAME"));
        Interactor interactor2 = (Interactor)arrayList.get(1);
        TestMapPsiToInteractions.assertEquals((String)"YDL065C", (String)interactor2.getName());
        TestMapPsiToInteractions.assertEquals((Object)"40 kDa farnesylated protein associated with peroxisomes", (Object)interactor2.getAttribute("FULL_NAME"));
        ExternalReference[] externalReferenceArray = interactor2.getExternalRefs();
        TestMapPsiToInteractions.assertEquals((String)"Entrez GI", (String)externalReferenceArray[0].getDatabase());
        TestMapPsiToInteractions.assertEquals((String)"1431072", (String)externalReferenceArray[0].getId());
        HashMap hashMap = (HashMap)interaction.getAttribute("BAIT_MAP");
        RoleType roleType = (RoleType)hashMap.get("YCR038C");
        RoleType roleType2 = (RoleType)hashMap.get("YDL065C");
        TestMapPsiToInteractions.assertEquals((Object)RoleType.BAIT, (Object)roleType);
        TestMapPsiToInteractions.assertTrue((roleType2 == null ? 1 : 0) != 0);
        TestMapPsiToInteractions.assertEquals((Object)"Sample ShortLabel", (Object)interaction.getAttribute("INTERACTION_SHORT_NAME"));
        TestMapPsiToInteractions.assertEquals((Object)"Sample FullName", (Object)interaction.getAttribute("INTERACTION_FULL_NAME"));
    }

    private void validateInteractionSecondSample(Interaction interaction) {
        String string = (String)interaction.getAttribute("PUB_MED_ID");
        String string2 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        TestMapPsiToInteractions.assertEquals((String)"1549776", (String)string);
        TestMapPsiToInteractions.assertEquals((String)"X-Ray", (String)string2);
        ArrayList arrayList = interaction.getInteractors();
        Interactor interactor = (Interactor)arrayList.get(0);
        TestMapPsiToInteractions.assertEquals((String)"hGHR", (String)interactor.getName());
        TestMapPsiToInteractions.assertEquals((Object)"Human growth hormone receptor", (Object)interactor.getAttribute("FULL_NAME"));
        Interactor interactor2 = (Interactor)arrayList.get(1);
        TestMapPsiToInteractions.assertEquals((String)"hGHR", (String)interactor2.getName());
        TestMapPsiToInteractions.assertEquals((Object)"Human growth hormone receptor", (Object)interactor2.getAttribute("FULL_NAME"));
        Interactor interactor3 = (Interactor)arrayList.get(2);
        TestMapPsiToInteractions.assertEquals((String)"hGH", (String)interactor3.getName());
        TestMapPsiToInteractions.assertEquals((Object)"Human growth hormone, somatotropin", (Object)interactor3.getAttribute("FULL_NAME"));
        ExternalReference[] externalReferenceArray = interactor.getExternalRefs();
        TestMapPsiToInteractions.assertEquals((String)"Swiss-Prot", (String)externalReferenceArray[0].getDatabase());
        TestMapPsiToInteractions.assertEquals((String)"P10912", (String)externalReferenceArray[0].getId());
        externalReferenceArray = interactor3.getExternalRefs();
        TestMapPsiToInteractions.assertEquals((String)"Swiss-Prot", (String)externalReferenceArray[0].getDatabase());
        TestMapPsiToInteractions.assertEquals((String)"P01241", (String)externalReferenceArray[0].getId());
    }

    private void validateInteractionThirdSample(Interaction interaction) {
        ArrayList arrayList = interaction.getInteractors();
        Interactor interactor = (Interactor)arrayList.get(0);
        TestMapPsiToInteractions.assertEquals((String)"MAK10", (String)interactor.getName());
        Interactor interactor2 = (Interactor)arrayList.get(1);
        TestMapPsiToInteractions.assertEquals((String)"MAK3", (String)interactor2.getName());
    }

    private void validateInteractionFourthSample(Interaction interaction) {
        ArrayList arrayList = interaction.getInteractors();
        Interactor interactor = (Interactor)arrayList.get(0);
        TestMapPsiToInteractions.assertEquals((String)"MAK10", (String)interactor.getName());
        Interactor interactor2 = (Interactor)arrayList.get(1);
        TestMapPsiToInteractions.assertEquals((String)"MAK3", (String)interactor2.getName());
    }

    private void outputInteraction(Interaction interaction) {
        System.out.println("Interaction:");
        String string = (String)interaction.getAttribute("PUB_MED_ID");
        String string2 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        System.out.println(".. PubMedID:  " + string);
        System.out.println(".. Experimental System:  " + string2);
        ArrayList arrayList = interaction.getInteractors();
        for (int i = 0; i < arrayList.size(); ++i) {
            Interactor interactor = (Interactor)arrayList.get(i);
            this.outputInteractor(interactor);
        }
    }

    private void outputInteractor(Interactor interactor) {
        System.out.println(".. Interactor:  " + interactor.getName());
        System.out.println("..... Description:  " + interactor.getDescription());
    }
}

