/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import junit.framework.TestCase;
import mt.Matrix;
import mt.util.Matrices;

/**
 * Orthogonal matrix decomposition tests
 */
public abstract class OrthogonalTest extends TestCase {

	/**
	 * Initial work-matrix
	 */
	protected Matrix A;

	/**
	 * Maximum matrix size, to avoid too slow tests
	 */
	private final int max = 100;

	public OrthogonalTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		int n = Utilities.getInt(max);
		A = Matrices.random(n, n);
	}

	protected void tearDown() throws Exception {
		A = null;
	}

	protected void assertEquals(Matrix A, Matrix B) {
		for (int i = 0; i < A.numRows(); ++i)
			for (int j = 0; j < A.numColumns(); ++j)
				assertEquals(A.get(i, j), B.get(i, j), 1e-12);
	}

}
