/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.BandMatrix;
import mt.DenseMatrix;
import mt.Matrix;
import mt.fact.BandLU;
import junit.framework.TestCase;

/**
 * Tests the banded LU decomposition
 */
public class BandLUTest extends TestCase {

	/**
	 * Matrix to decompose
	 */
	private BandMatrix A;

	private final int max = 100, bmax = 10;

	public BandLUTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		int n = Utilities.getInt(max),
			kl = Math.min(n, Utilities.getInt(bmax)),
			ku = Math.min(n, Utilities.getInt(bmax));
		A = new BandMatrix(n, kl, ku);
		Utilities.bandPopulate(A, kl, ku);
		A.addDiagonal(1);
		while (Utilities.singular(A))
			A.addDiagonal(1);
	}

	protected void tearDown() throws Exception {
		A = null;
	}

	public void testBandLU() {
		BandLU lu = new BandLU(A);

		int n = A.numRows();

		DenseMatrix I = new DenseMatrix(n, n);
		for (int i = 0; i < n; ++i)
			I.set(i, i, 1);
		lu.solve(I);

		Matrix J = I.mult(A, new DenseMatrix(n, n));
		for (int i = 0; i < n; ++i)
			for (int j = 0; j < n; ++j)
				if (i != j)
					assertEquals(J.get(i, j), 0, 1e-10);
				else
					assertEquals(J.get(i, j), 1, 1e-10);
	}

}
