/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.brainplugin.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.MultiSequenceSearchResultSet;
import org.baderlab.csplugins.brainplugin.CytoscapeUtil;

public class ProfileSearchTask
implements Task {
    private TaskMonitor taskMonitor = null;
    BrainAlgorithm alg = new BrainAlgorithm();

    public void run() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        this.alg.setTaskMonitor(this.taskMonitor);
        MultiSequenceSearchResultSet searchResults = this.alg.runProfileSearch();
        int oldViewThreshold = CytoscapeInit.getViewThreshold();
        CytoscapeInit.setViewThreshold((int)0);
        CyNetwork net = CytoscapeUtil.addProfileSearchResultsToCytoscape(searchResults, this.alg.getParams());
        CytoscapeInit.setViewThreshold((int)oldViewThreshold);
        Cytoscape.createNetworkView((CyNetwork)net);
        if (searchResults != null) {
            searchResults.clear();
        }
    }

    public void halt() {
        this.alg.cancel();
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Profile Search");
    }
}

