/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.brainplugin.dialogs;

import cytoscape.util.FileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.baderlab.brain.BrainCurrentParameters;
import org.baderlab.brain.BrainParameterSet;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.util.JMultiLineToolTip;

public class BrainParameterChangeDialog
extends JDialog {
    BrainParameterSet currentParamsCopy;
    JTextField databaseFileNameTextField;
    JComboBox databaseFormatComboBox;
    JComboBox terminusComboBox;
    boolean wholeSequenceSearchSet = false;
    JFormattedTextField lengthFormattedTextField;
    JCheckBox multipleHitsCheckBox;
    JTextField profileFileNameTextField;
    JCheckBox normalizedCheckBox;
    JFormattedTextField scoreThresholdFormattedTextField;
    JFormattedTextField topHitsFormattedTextField;
    JFormattedTextField fuzzFactorFormattedTextField;
    JTextField biasFileNameTextField;
    JCheckBox uniquePeptidesCheckBox;
    JCheckBox groupProteinDomains;
    JComboBox nodeRepComboBox;

    public BrainParameterChangeDialog(Frame parentFrame) {
        super(parentFrame, "Parameters", false);
        this.setResizable(true);
        this.currentParamsCopy = BrainCurrentParameters.getInstance().getParamsCopy();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setSize(500, 800);
        Box databaseBox = Box.createVerticalBox();
        JPanel databaseChooserSubPanel = new JPanel(new BorderLayout());
        databaseChooserSubPanel.setBorder(BorderFactory.createTitledBorder("Database to Search"));
        JPanel chooserPanel = new JPanel();
        this.databaseFileNameTextField = new JTextField();
        this.databaseFileNameTextField.setToolTipText("The file name of the database to search.");
        if (this.currentParamsCopy.getDatabaseFileName() != null) {
            this.databaseFileNameTextField.setText(this.currentParamsCopy.getDatabaseFileName().toString());
        }
        this.databaseFileNameTextField.setColumns(20);
        this.databaseFileNameTextField.addActionListener(new databaseFileNameAction());
        this.databaseFileNameTextField.getDocument().addDocumentListener(new databaseFileNameAction());
        chooserPanel.add(this.databaseFileNameTextField);
        JButton chooseFileButton = new JButton("Browse...");
        chooseFileButton.addActionListener(new chooseDatabaseAction());
        chooserPanel.add(chooseFileButton);
        databaseChooserSubPanel.add((Component)chooserPanel, "North");
        JLabel formatLabel = new JLabel("Format");
        JPanel formatLabelFieldPanel = new JPanel();
        String tipText = "Select the format of the database file.";
        formatLabelFieldPanel.setToolTipText(tipText);
        formatLabelFieldPanel.add(formatLabel);
        String[] formatChoices = new String[]{"FASTA", "SwissProt", "GenPept", "EMBL"};
        this.databaseFormatComboBox = new JComboBox<String>(formatChoices);
        this.databaseFormatComboBox.setToolTipText(tipText);
        if (this.currentParamsCopy.getDatabaseFormat() != null) {
            String currentFormat = this.currentParamsCopy.getDatabaseFormat();
            for (int i = 0; i < formatChoices.length; ++i) {
                String formatChoice = formatChoices[i];
                if (!formatChoice.equalsIgnoreCase(currentFormat)) continue;
                this.databaseFormatComboBox.setSelectedIndex(i);
                break;
            }
        } else {
            this.currentParamsCopy.setDatabaseFormat(formatChoices[0]);
        }
        formatLabelFieldPanel.add(this.databaseFormatComboBox);
        this.databaseFormatComboBox.addActionListener(new selectFormatAction());
        databaseChooserSubPanel.add((Component)formatLabelFieldPanel, "South");
        JPanel searchOptionsSubPanel = new JPanel(new BorderLayout());
        searchOptionsSubPanel.setBorder(BorderFactory.createTitledBorder("Sequence Filtering"));
        DecimalFormat decFormatInteger = new DecimalFormat();
        decFormatInteger.setParseIntegerOnly(true);
        this.lengthFormattedTextField = new JFormattedTextField(decFormatInteger){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.lengthFormattedTextField.setColumns(3);
        this.lengthFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String lengthTipText = "Search only this many residues from either\nN or C terminal end of each protein in the database.\nIf not set, will use the length of the search pattern.";
        this.lengthFormattedTextField.setToolTipText(lengthTipText);
        if (this.currentParamsCopy.getSearchParams() != null) {
            int length = this.currentParamsCopy.getSearchParams().getLength();
            if (length > 0) {
                this.lengthFormattedTextField.setText(Integer.toString(length));
            } else {
                this.lengthFormattedTextField.setText("5");
                this.currentParamsCopy.getSearchParams().setLength(Integer.valueOf(5));
            }
        }
        JLabel lengthLabel = new JLabel("Search Length");
        JPanel labelFieldPanel = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        labelFieldPanel.setToolTipText(lengthTipText);
        labelFieldPanel.add(lengthLabel);
        labelFieldPanel.add(this.lengthFormattedTextField);
        searchOptionsSubPanel.add((Component)labelFieldPanel, "West");
        JLabel searchLabel = new JLabel("Search");
        JPanel searchLabelFieldPanel = new JPanel();
        String searchTipText = "Optionally choose a subset of the sequence to search.";
        searchLabelFieldPanel.setToolTipText(searchTipText);
        searchLabelFieldPanel.add(searchLabel);
        String[] terminiChoices = new String[]{"Whole sequence", "N-terminus", "C-terminus"};
        ProteinTerminus[] terminiList = new ProteinTerminus[]{ProteinTerminus.NONE, ProteinTerminus.N, ProteinTerminus.C};
        this.terminusComboBox = new JComboBox<String>(terminiChoices);
        this.terminusComboBox.setToolTipText(searchTipText);
        this.lengthFormattedTextField.setEnabled(false);
        if (this.currentParamsCopy.getSearchParams() != null) {
            ProteinTerminus currentTerminus = this.currentParamsCopy.getSearchParams().getTerminus();
            for (int i = 0; i < terminiList.length; ++i) {
                ProteinTerminus terminus = terminiList[i];
                if (!terminus.equals((Object)currentTerminus)) continue;
                this.terminusComboBox.setSelectedIndex(i);
                break;
            }
            if (!currentTerminus.equals((Object)ProteinTerminus.NONE)) {
                if (this.currentParamsCopy.getSearchParams() != null && this.currentParamsCopy.getSearchParams().isMultipleHits()) {
                    this.lengthFormattedTextField.setEnabled(true);
                }
                this.wholeSequenceSearchSet = false;
            } else {
                this.wholeSequenceSearchSet = true;
            }
        }
        this.terminusComboBox.addActionListener(new selectTerminiAction());
        searchLabelFieldPanel.add(this.terminusComboBox);
        searchOptionsSubPanel.add((Component)searchLabelFieldPanel, "North");
        this.multipleHitsCheckBox = new JCheckBox("Multiple Hits?", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.multipleHitsCheckBox.addItemListener(new multipleHitsCheckBoxAction());
        this.multipleHitsCheckBox.setToolTipText("If checked, search will return multiple hits,\notherwise only the first hit will be returned.");
        if (this.currentParamsCopy.getSearchParams() != null) {
            this.multipleHitsCheckBox.setSelected(this.currentParamsCopy.getSearchParams().isMultipleHits());
        }
        searchOptionsSubPanel.add((Component)this.multipleHitsCheckBox, "East");
        databaseBox.add(databaseChooserSubPanel);
        databaseBox.add(searchOptionsSubPanel);
        databaseBox.add(Box.createRigidArea(new Dimension(0, 50)));
        JPanel profileParamsPanel = new JPanel(new BorderLayout());
        JPanel profileChooserSubPanel = new JPanel(new BorderLayout());
        profileChooserSubPanel.setBorder(BorderFactory.createTitledBorder("Profile selection"));
        JPanel profileChooserPanel = new JPanel();
        this.profileFileNameTextField = new JTextField();
        this.profileFileNameTextField.setToolTipText("The file name of the profile or list of profiles to search using.");
        if (this.currentParamsCopy.getProfileFile() != null) {
            this.profileFileNameTextField.setText(this.currentParamsCopy.getProfileFile().toString());
        }
        this.profileFileNameTextField.setColumns(20);
        this.profileFileNameTextField.addActionListener(new profileFileNameAction());
        this.profileFileNameTextField.getDocument().addDocumentListener(new profileFileNameAction());
        profileChooserPanel.add(this.profileFileNameTextField);
        JButton profileChooseFileButton = new JButton("Browse...");
        profileChooseFileButton.addActionListener(new chooseProfileAction());
        profileChooserPanel.add(profileChooseFileButton);
        profileChooserSubPanel.add((Component)profileChooserPanel, "North");
        JPanel profileChooserSubSubPanel = new JPanel();
        this.uniquePeptidesCheckBox = new JCheckBox("Unique peptides", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.uniquePeptidesCheckBox.addItemListener(new uniquePeptidesCheckBoxAction());
        this.uniquePeptidesCheckBox.setToolTipText("If checked, only unique peptide sequences will be loaded from the profile.");
        this.uniquePeptidesCheckBox.setSelected(this.currentParamsCopy.getUniquePeptides());
        profileChooserSubSubPanel.add(this.uniquePeptidesCheckBox);
        profileChooserSubPanel.add((Component)profileChooserSubSubPanel, "South");
        JPanel profileOptionsSubPanel = new JPanel(new BorderLayout());
        profileOptionsSubPanel.setBorder(BorderFactory.createTitledBorder("Profile search options"));
        JPanel profileOptionsSubSubPanel = new JPanel(new FlowLayout());
        JPanel scoreTypeSubPanel = new JPanel(new BorderLayout());
        scoreTypeSubPanel.setBorder(BorderFactory.createTitledBorder("Score Threshold"));
        profileOptionsSubSubPanel.add(scoreTypeSubPanel);
        profileOptionsSubPanel.add((Component)profileOptionsSubSubPanel, "North");
        Box scoreTypeInputBox = new Box(1);
        DecimalFormat decFormatDouble = new DecimalFormat();
        decFormatDouble.setMaximumIntegerDigits(3);
        this.scoreThresholdFormattedTextField = new JFormattedTextField(decFormatDouble){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.scoreThresholdFormattedTextField.setColumns(5);
        this.scoreThresholdFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String scoreTipText = "Sets the score threshold for the search.\nMatches below this score will be added to Cytoscape.\nE.g. 10 means only return matches to the profile lower than p=1E-10\nThe lower this number, the less matches will result\nThis number must be 0 or higher where 0 (p=1.0) is the most stringent threshold\nwhere the score of the match must be equal to p=1.0 (perfect match).";
        this.scoreThresholdFormattedTextField.setToolTipText(scoreTipText);
        this.scoreThresholdFormattedTextField.setText(Double.toString(this.currentParamsCopy.getScoreThreshold()));
        JLabel scoreThresholdLabel = new JLabel("Score threshold");
        JPanel labelFieldPanel1 = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        labelFieldPanel1.setToolTipText(scoreTipText);
        labelFieldPanel1.add(scoreThresholdLabel);
        labelFieldPanel1.add(this.scoreThresholdFormattedTextField);
        scoreTypeInputBox.add(labelFieldPanel1);
        this.topHitsFormattedTextField = new JFormattedTextField(decFormatInteger){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.topHitsFormattedTextField.setColumns(5);
        this.topHitsFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String topHistTipText = "Sets the score threshold for the search\nin terms of number of top hits. More hits than this\nmay result if many hits have the same score.\n";
        this.topHitsFormattedTextField.setToolTipText(topHistTipText);
        this.topHitsFormattedTextField.setText(Double.toString(this.currentParamsCopy.getNumberTopHits()));
        JLabel topHistThresholdLabel = new JLabel("Number top hits");
        JPanel labelFieldPanel2 = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        labelFieldPanel2.setToolTipText(topHistTipText);
        labelFieldPanel2.add(topHistThresholdLabel);
        labelFieldPanel2.add(this.topHitsFormattedTextField);
        scoreTypeInputBox.add(labelFieldPanel2);
        scoreTypeSubPanel.add((Component)scoreTypeInputBox, "South");
        JPanel profileOptionsSubPanelBottomPanel = new JPanel(new FlowLayout());
        this.fuzzFactorFormattedTextField = new JFormattedTextField(decFormatDouble){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.fuzzFactorFormattedTextField.setColumns(5);
        this.fuzzFactorFormattedTextField.addPropertyChangeListener("value", new formattedTextFieldAction());
        String fuzzFactorTipText = "Sets the fuzz factor for the profile.\nThe higher this number, the fuzzier the profile\nwill be and the more hits will result.\n(This is the pseudocount number for the profile)";
        this.fuzzFactorFormattedTextField.setToolTipText(fuzzFactorTipText);
        this.fuzzFactorFormattedTextField.setText(Double.toString(this.currentParamsCopy.getFuzzFactor()));
        JLabel fuzzFactorLabel = new JLabel("Fuzz Factor");
        JPanel fuzzFactorLabelFieldPanel = new JPanel(){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        fuzzFactorLabelFieldPanel.setToolTipText(fuzzFactorTipText);
        fuzzFactorLabelFieldPanel.add(fuzzFactorLabel);
        fuzzFactorLabelFieldPanel.add(this.fuzzFactorFormattedTextField);
        profileOptionsSubPanelBottomPanel.add((Component)fuzzFactorLabelFieldPanel, "South");
        this.normalizedCheckBox = new JCheckBox("Normalized", false){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.normalizedCheckBox.addItemListener(new normalizedCheckBoxAction());
        this.normalizedCheckBox.setToolTipText("If checked, match scores will be normalized to the profile.\n(To the range of possible p-values that the profile can produce)");
        if (!this.currentParamsCopy.getSearchParams().isNormalizedSet()) {
            this.currentParamsCopy.getSearchParams().setNormalized(true);
            this.currentParamsCopy.getSearchParams().setScoreType(2);
        }
        this.normalizedCheckBox.setSelected(this.currentParamsCopy.getSearchParams().isNormalized());
        profileOptionsSubPanelBottomPanel.add(this.normalizedCheckBox);
        profileOptionsSubPanel.add((Component)profileOptionsSubPanelBottomPanel, "South");
        JPanel biasFileSubPanel = new JPanel(new BorderLayout());
        biasFileSubPanel.setBorder(BorderFactory.createTitledBorder("Codon Bias File"));
        JPanel biasFileChooserPanel = new JPanel();
        this.biasFileNameTextField = new JTextField();
        this.biasFileNameTextField.setToolTipText("The file name of the codon bias file specification.");
        if (this.currentParamsCopy.getCodonBiasFile() != null) {
            this.biasFileNameTextField.setText(this.currentParamsCopy.getCodonBiasFile().toString());
        }
        this.biasFileNameTextField.setColumns(20);
        this.biasFileNameTextField.addActionListener(new codonBiasFileNameAction());
        biasFileChooserPanel.add(this.biasFileNameTextField);
        JButton biasFileChooseFileButton = new JButton("Browse...");
        biasFileChooseFileButton.addActionListener(new chooseCodonBiasAction());
        biasFileChooserPanel.add(biasFileChooseFileButton);
        biasFileSubPanel.add((Component)biasFileChooserPanel, "North");
        JPanel tab2Panel = new JPanel(new BorderLayout());
        tab2Panel.add((Component)profileChooserSubPanel, "North");
        tab2Panel.add((Component)profileOptionsSubPanel, "South");
        tab2Panel.add(biasFileSubPanel);
        profileParamsPanel.add((Component)tab2Panel, "North");
        Box advancedBox = Box.createVerticalBox();
        JPanel networkSubPanel = new JPanel(new BorderLayout());
        networkSubPanel.setBorder(BorderFactory.createTitledBorder("Network Options"));
        JLabel nodeRepLabel = new JLabel("Nodes represent");
        JPanel nodeRepLabelFieldPanel = new JPanel();
        tipText = "A node in the network can represent a single domain, or a protein with one or more instances of a domain";
        nodeRepLabelFieldPanel.setToolTipText(tipText);
        nodeRepLabelFieldPanel.add(nodeRepLabel);
        String[] nodeRepChoices = new String[]{"Proteins", "Domains"};
        this.nodeRepComboBox = new JComboBox<String>(nodeRepChoices);
        this.nodeRepComboBox.setToolTipText(tipText);
        if (this.currentParamsCopy.getUniqueQueryProteinNodes()) {
            this.nodeRepComboBox.setSelectedIndex(0);
        } else {
            this.nodeRepComboBox.setSelectedIndex(1);
        }
        nodeRepLabelFieldPanel.add(this.nodeRepComboBox);
        this.nodeRepComboBox.addActionListener(new selectNodeRepAction());
        networkSubPanel.add((Component)nodeRepLabelFieldPanel, "Center");
        advancedBox.add(networkSubPanel);
        advancedBox.add(Box.createRigidArea(new Dimension(0, 225)));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Sequence Database", null, databaseBox, "Choose the protein sequence database to search.");
        tabbedPane.addTab("Profile Search", null, profileParamsPanel, "Set parameters for profile search.");
        tabbedPane.addTab("Advanced Options", null, advancedBox, "Set advanced options.");
        panel.add((Component)tabbedPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        JButton OKButton = new JButton("OK");
        OKButton.addActionListener(new OKAction(this));
        bottomPanel.add(OKButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new cancelAction(this));
        bottomPanel.add(cancelButton);
        panel.add((Component)bottomPanel, "South");
        this.setContentPane(panel);
    }

    private void saveParams() {
        BrainCurrentParameters.getInstance().setParams(this.currentParamsCopy);
    }

    private class selectNodeRepAction
    extends AbstractAction {
        selectNodeRepAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String nodeRepName = (String)cb.getSelectedItem();
                if ("proteins".equalsIgnoreCase(nodeRepName)) {
                    BrainParameterChangeDialog.this.currentParamsCopy.setUniqueQueryProteinNodes(true);
                } else if ("domains".equalsIgnoreCase(nodeRepName)) {
                    BrainParameterChangeDialog.this.currentParamsCopy.setUniqueQueryProteinNodes(false);
                }
            }
        }
    }

    private class formattedTextFieldAction
    implements PropertyChangeListener {
        private formattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Number value;
            Object source = e.getSource();
            if (source == BrainParameterChangeDialog.this.lengthFormattedTextField) {
                ProteinDatabaseSearchParams params;
                Number value2 = (Number)BrainParameterChangeDialog.this.lengthFormattedTextField.getValue();
                if (value2 != null && value2.intValue() > 0 && (params = BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams()) != null) {
                    params.setLength(Integer.valueOf(value2.intValue()));
                }
            } else if (source == BrainParameterChangeDialog.this.scoreThresholdFormattedTextField) {
                Number value3 = (Number)BrainParameterChangeDialog.this.scoreThresholdFormattedTextField.getValue();
                if (value3 != null && value3.doubleValue() >= 0.0) {
                    BrainParameterChangeDialog.this.currentParamsCopy.setScoreThreshold(value3.doubleValue());
                }
            } else if (source == BrainParameterChangeDialog.this.topHitsFormattedTextField) {
                Number value4 = (Number)BrainParameterChangeDialog.this.topHitsFormattedTextField.getValue();
                if (value4 != null && value4.intValue() > 0) {
                    BrainParameterChangeDialog.this.currentParamsCopy.setNumberTopHits(value4.intValue());
                }
            } else if (source == BrainParameterChangeDialog.this.fuzzFactorFormattedTextField && (value = (Number)BrainParameterChangeDialog.this.fuzzFactorFormattedTextField.getValue()) != null && value.doubleValue() >= 0.0) {
                BrainParameterChangeDialog.this.currentParamsCopy.setFuzzFactor(value.doubleValue());
            }
        }
    }

    private class codonBiasFileNameAction
    extends AbstractAction
    implements DocumentListener {
        codonBiasFileNameAction() {
        }

        private void handleChange() {
            String value = BrainParameterChangeDialog.this.biasFileNameTextField.getText();
            if (value != null) {
                File file = new File(value);
                BrainParameterChangeDialog.this.currentParamsCopy.setCodonBiasFileName(file);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class profileFileNameAction
    extends AbstractAction
    implements DocumentListener {
        profileFileNameAction() {
        }

        private void handleChange() {
            String value = BrainParameterChangeDialog.this.profileFileNameTextField.getText();
            if (value != null) {
                File file = new File(value);
                BrainParameterChangeDialog.this.currentParamsCopy.setProfileFileName(file);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class databaseFileNameAction
    extends AbstractAction
    implements DocumentListener {
        databaseFileNameAction() {
        }

        private void handleChange() {
            String value = BrainParameterChangeDialog.this.databaseFileNameTextField.getText();
            if (value != null) {
                File file = new File(value);
                BrainParameterChangeDialog.this.currentParamsCopy.setDatabaseFileName(file);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class normalizedCheckBoxAction
    implements ItemListener {
        private normalizedCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent e) {
            ProteinDatabaseSearchParams params = null;
            if (BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams() != null) {
                params = BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams();
            }
            if (e.getStateChange() == 2) {
                if (params != null) {
                    params.setNormalized(false);
                    BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams().setScoreType(1);
                }
            } else if (params != null) {
                params.setNormalized(true);
                BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams().setScoreType(2);
            }
        }
    }

    private class uniquePeptidesCheckBoxAction
    implements ItemListener {
        private uniquePeptidesCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                BrainParameterChangeDialog.this.currentParamsCopy.setUniquePeptides(false);
            } else if (e.getStateChange() == 1) {
                BrainParameterChangeDialog.this.currentParamsCopy.setUniquePeptides(true);
            }
        }
    }

    private class chooseCodonBiasAction
    extends AbstractAction {
        chooseCodonBiasAction() {
        }

        public void actionPerformed(ActionEvent e) {
            File chosenFile = FileUtil.getFile((String)"Select Codon Bias Specification...", (int)FileUtil.LOAD);
            if (chosenFile != null) {
                BrainParameterChangeDialog.this.currentParamsCopy.setCodonBiasFileName(chosenFile);
                BrainParameterChangeDialog.this.biasFileNameTextField.setText(chosenFile.toString());
            }
        }
    }

    private class chooseProfileAction
    extends AbstractAction {
        chooseProfileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            File chosenFile = FileUtil.getFile((String)"Select profiles...", (int)FileUtil.LOAD);
            if (chosenFile != null) {
                BrainParameterChangeDialog.this.currentParamsCopy.setProfileFileName(chosenFile);
                BrainParameterChangeDialog.this.profileFileNameTextField.setText(chosenFile.toString());
            }
        }
    }

    private class multipleHitsCheckBoxAction
    implements ItemListener {
        private multipleHitsCheckBoxAction() {
        }

        public void itemStateChanged(ItemEvent e) {
            ProteinDatabaseSearchParams params = null;
            if (BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams() != null) {
                params = BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams();
            }
            if (e.getStateChange() == 2) {
                if (params != null) {
                    params.setMultipleHits(false);
                    if (BrainParameterChangeDialog.this.lengthFormattedTextField.isEnabled()) {
                        BrainParameterChangeDialog.this.lengthFormattedTextField.setEnabled(false);
                    }
                }
            } else if (params != null) {
                params.setMultipleHits(true);
                if (!BrainParameterChangeDialog.this.wholeSequenceSearchSet) {
                    BrainParameterChangeDialog.this.lengthFormattedTextField.setEnabled(true);
                }
            }
        }
    }

    private class selectTerminiAction
    extends AbstractAction {
        String[] terminiChoices = new String[]{"Whole sequence", "N-terminus", "C-terminus"};
        ProteinTerminus[] terminiList = new ProteinTerminus[]{ProteinTerminus.NONE, ProteinTerminus.N, ProteinTerminus.C};

        selectTerminiAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String terminiSelection = (String)cb.getSelectedItem();
                if (!terminiSelection.equals(this.terminiChoices[0])) {
                    if (BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams() != null && BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams().isMultipleHits()) {
                        BrainParameterChangeDialog.this.lengthFormattedTextField.setEnabled(true);
                    }
                    BrainParameterChangeDialog.this.wholeSequenceSearchSet = false;
                } else {
                    BrainParameterChangeDialog.this.lengthFormattedTextField.setEnabled(false);
                    BrainParameterChangeDialog.this.wholeSequenceSearchSet = true;
                }
                for (int i = 0; i < this.terminiChoices.length; ++i) {
                    String terminiChoice = this.terminiChoices[i];
                    if (!terminiChoice.equals(terminiSelection)) continue;
                    if (BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams() == null) break;
                    BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams().setTerminus(this.terminiList[i]);
                    break;
                }
            }
        }
    }

    private class selectFormatAction
    extends AbstractAction {
        selectFormatAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String formatName = (String)cb.getSelectedItem();
                BrainParameterChangeDialog.this.currentParamsCopy.setDatabaseFormat(formatName);
            }
        }
    }

    private class chooseDatabaseAction
    extends AbstractAction {
        chooseDatabaseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            File chosenFile = FileUtil.getFile((String)"Select protein database...", (int)FileUtil.LOAD);
            if (chosenFile != null) {
                BrainParameterChangeDialog.this.currentParamsCopy.setDatabaseFileName(chosenFile);
                BrainParameterChangeDialog.this.databaseFileNameTextField.setText(chosenFile.toString());
            }
        }
    }

    private class cancelAction
    extends AbstractAction {
        private JDialog dialog;

        cancelAction(JDialog popup) {
            this.dialog = popup;
        }

        public void actionPerformed(ActionEvent e) {
            this.dialog.dispose();
        }
    }

    private class OKAction
    extends AbstractAction {
        private JDialog dialog;

        OKAction(JDialog popup) {
            this.dialog = popup;
        }

        public void actionPerformed(ActionEvent e) {
            if (!BrainParameterChangeDialog.this.currentParamsCopy.validateDBOptions()) {
                JOptionPane.showMessageDialog(this.dialog, "Please set the database name.");
                return;
            }
            if (!BrainParameterChangeDialog.this.lengthFormattedTextField.isEnabled() && BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams() != null) {
                BrainParameterChangeDialog.this.currentParamsCopy.getSearchParams().setLength(null);
            }
            BrainParameterChangeDialog.this.saveParams();
            this.dialog.dispose();
        }
    }
}

