/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import org.baderlab.brain.DistanceMetric;

public class AlignedProteinSequenceIdentityDistance
extends DistanceMetric {
    public double calc(Object object1, Object object2) {
        if (!(object1 instanceof String) || !(object2 instanceof String)) {
            throw new RuntimeException("Non string passed to AlignedProteinSequenceIdentityDistance");
        }
        double distance = 0.0;
        String sequenceA = (String)object1;
        String sequenceB = (String)object2;
        int count = 0;
        int numGaps = 0;
        for (int i = 0; i < sequenceA.length(); ++i) {
            String aaA = sequenceA.substring(i, i + 1);
            String aaB = sequenceB.substring(i, i + 1);
            if (aaA.equals("-") || aaB.equals("-")) {
                ++numGaps;
                continue;
            }
            if (!aaA.equals(aaB)) continue;
            ++count;
        }
        distance = (double)count / (double)(sequenceA.length() - numGaps);
        distance = 1.0 - distance;
        return distance;
    }
}

