/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import BiNGO.BiNGOAnnotationDefaultReader;
import BiNGO.BiNGOOntologyFlatFileReader;
import BiNGO.HypergeometricTestCalculate;
import BiNGO.MultipleTestingCorrection;
import BiNGO.SettingsPanel;
import BiNGO.SignificantFigures;
import cytoscape.CyNetwork;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.baderlab.brain.AlignedProteinSequenceIdentityDistance;
import org.baderlab.brain.AminoAcidGrouping;
import org.baderlab.brain.AvgLinkHierarchicalClustering;
import org.baderlab.brain.BrainCurrentParameters;
import org.baderlab.brain.BrainParameterSet;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.DistanceMatrix;
import org.baderlab.brain.DistanceMetric;
import org.baderlab.brain.GenPeptUtil;
import org.baderlab.brain.Hit;
import org.baderlab.brain.LogoTreeDraw;
import org.baderlab.brain.MultiSequenceSearchResultSet;
import org.baderlab.brain.PeptideChipDesign;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinDatabaseSearch;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinProfileDistance;
import org.baderlab.brain.ProteinSequenceLogo;
import org.baderlab.brain.ProteinSequenceUtil;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.SequenceSearchResultSet;
import org.baderlab.brain.util.FileReaderUtil;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;

public class BrainAlgorithm {
    private BrainParameterSet params = BrainCurrentParameters.getInstance().getParamsCopy();
    private ProteinDatabaseSearch search = null;
    private TaskMonitor taskMonitor = null;

    public MultiSequenceSearchResultSet runProfileSearch() {
        return this.runProfileSearch(null, null, null);
    }

    public MultiSequenceSearchResultSet runProfileSearch(List profileList, List scoreThresholdList, BrainParameterSet internalParams) {
        MultiSequenceSearchResultSet searchResults = null;
        if (internalParams == null) {
            internalParams = this.params;
        }
        File codonBiasFile = this.params.getCodonBiasFile();
        boolean uniquePeptides = this.params.getUniquePeptides();
        if (profileList == null) {
            profileList = PeptideToProfileReader.readPeptidesAsProfiles(internalParams.getProfileFile(), internalParams.getFuzzFactor(), codonBiasFile, uniquePeptides);
        }
        if (scoreThresholdList == null) {
            scoreThresholdList = new ArrayList<Double>(profileList.size());
            for (int i = 0; i < profileList.size(); ++i) {
                scoreThresholdList.add(new Double(internalParams.getScoreThreshold()));
            }
        }
        try {
            if (internalParams.getDatabaseFileName() == null || internalParams.getDatabaseFormat() == null) {
                System.err.println("Database filename or format not specified. Can't continue.");
                return null;
            }
            this.search = new ProteinDatabaseSearch(this.params.getDatabaseFileName().toString(), internalParams.getDatabaseFormat());
            this.search.setTaskMonitor(this.taskMonitor);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        try {
            searchResults = this.search.multiProfileSearchDB(profileList, scoreThresholdList, internalParams.getSearchParams());
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        try {
            this.search.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return searchResults;
    }

    public void runAllVsAllProfileDistance(String profileListFileName) {
        String separatorString = "\t";
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), this.params.getFuzzFactor());
        for (int i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile1 = (ProteinProfile)profileList.get(i);
            System.out.print(proteinProfile1.getName() + "\t");
            for (int j = 0; j < profileList.size(); ++j) {
                ProteinProfile proteinProfile2 = (ProteinProfile)profileList.get(j);
                System.out.print(ProteinProfileDistance.calculateDistributionDistance(proteinProfile1, proteinProfile2));
                if (j >= profileList.size()) continue;
                System.out.print("\t");
            }
            System.out.println("");
        }
    }

    public void runPeptideAAByPositionHistogramAnalysis(String profileListFileName, int peptideLength) {
        int i;
        String aaList = "ACDEFGHIKLMNPQRSTVWYX-";
        long[][] histogram = new long["ACDEFGHIKLMNPQRSTVWYX-".length()][peptideLength];
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), -1, null, 0.0, null, true);
        for (i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            Collection peptideList = proteinProfile.getSequenceMap();
            for (Sequence sequence : peptideList) {
                String seqString = sequence.seqString();
                int k = 0;
                while (k < seqString.length()) {
                    long[] lArray = histogram["ACDEFGHIKLMNPQRSTVWYX-".indexOf(seqString.charAt(k))];
                    int n = k++;
                    lArray[n] = lArray[n] + 1L;
                }
            }
        }
        System.out.print("\n");
        for (i = 0; i < histogram.length; ++i) {
            System.out.print("ACDEFGHIKLMNPQRSTVWYX-".charAt(i) + "\t");
            for (int j = 0; j < histogram[i].length; ++j) {
                System.out.print(histogram[i][j]);
                if (j >= histogram.length - 1) continue;
                System.out.print("\t");
            }
            System.out.print("\n");
        }
    }

    public void runPeptideAAByPositionPairHistogramAnalysis(String profileListFileName, int peptideLength, int position1, int position2) {
        int i;
        String aaList = "ACDEFGHIKLMNPQRSTVWYX-";
        long[][] histogram = new long["ACDEFGHIKLMNPQRSTVWYX-".length()]["ACDEFGHIKLMNPQRSTVWYX-".length()];
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), this.params.getFuzzFactor());
        for (i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            Collection peptideList = proteinProfile.getSequenceMap();
            for (Sequence sequence : peptideList) {
                String seqString = sequence.seqString();
                long[] lArray = histogram["ACDEFGHIKLMNPQRSTVWYX-".indexOf(seqString.charAt(position1))];
                int n = "ACDEFGHIKLMNPQRSTVWYX-".indexOf(seqString.charAt(position2));
                lArray[n] = lArray[n] + 1L;
            }
        }
        System.out.print("\n");
        for (i = 0; i < histogram.length; ++i) {
            System.out.print("ACDEFGHIKLMNPQRSTVWYX-".charAt(i) + "\t");
            for (int j = 0; j < histogram[i].length; ++j) {
                System.out.print(histogram[i][j]);
                if (j >= histogram.length - 1) continue;
                System.out.print("\t");
            }
            System.out.print("\n");
        }
    }

    public void runProfileCluster(String profileListFileName, String logoTreeTitle, File logoTreeOutput) {
        this.runProfileCluster(profileListFileName, -1, null, logoTreeTitle, logoTreeOutput, null, null);
    }

    public void runProfileCluster(String profileListFileName, int profileLength, ProteinTerminus terminus, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile) {
        ArrayList<ProteinProfile> originalProfileList;
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> cutProfileList = null;
        clusterProfileList = originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), 0, null, this.params.getFuzzFactor(), codonBiasFile, true);
        if (profileLength > 0) {
            cutProfileList = new ArrayList<ProteinProfile>();
            for (int i = 0; i < originalProfileList.size(); ++i) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
                cutProfileList.add(proteinProfile.getTruncatedProfileCopy(profileLength, terminus));
            }
            clusterProfileList = cutProfileList;
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
        distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                String groupingByPosition = AminoAcidGrouping.getPolarChargedHydrophobeGrouping();
                return ProteinProfileDistance.calculateAAGroupedDistributionDistance(proteinProfile1, proteinProfile2, groupingByPosition);
            }
        });
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        for (int i = 0; i < clusterProfileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(i);
            al.add(i, proteinProfile.getName());
        }
        distanceMatrix.setLabels(al);
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.setOptimalLeafOrdering(true);
        cluster.run();
        LogoTreeDraw ltd = new LogoTreeDraw(cluster, originalProfileList);
        ltd.setTrimNodeLogo(true, 0.2);
        ltd.setNodeLogoSubset(profileLength, terminus);
        ltd.setTitle(logoTreeTitle);
        if (leafLabelHighlightFile != null) {
            ArrayList list = null;
            try {
                list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
        }
        ltd.setSequenceLogoStartIndex(-9);
        ltd.outputToPDF(logoTreeOutput);
    }

    public void runProfileClusterPositionRange(String profileListFileName, int profileStartColumn, int profileEndColumn, int profileLength, ProteinTerminus terminus, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> singleColumnProfileList = null;
        int maxProfileLength = 0;
        List originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), 0, null, this.params.getFuzzFactor(), codonBiasFile, true);
        for (int i = profileStartColumn; i <= profileEndColumn; ++i) {
            singleColumnProfileList = new ArrayList<ProteinProfile>();
            for (int j = 0; j < originalProfileList.size(); ++j) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(j);
                singleColumnProfileList.add(proteinProfile.getProfileSubsetCopy(Integer.toString(i)));
                maxProfileLength = Math.max(maxProfileLength, proteinProfile.getNumColumns());
            }
            clusterProfileList = singleColumnProfileList;
            DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
            distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

                public double calc(Object object1, Object object2) {
                    ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                    ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                    return ProteinProfileDistance.calculateDistributionDistance(proteinProfile1, proteinProfile2);
                }
            });
            ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
            for (int j = 0; j < clusterProfileList.size(); ++j) {
                ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(j);
                al.add(j, proteinProfile.getName());
            }
            distanceMatrix.setLabels(al);
            AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
            cluster.setOptimalLeafOrdering(true);
            cluster.run();
            LogoTreeDraw ltd = new LogoTreeDraw(cluster, originalProfileList);
            ltd.setTrimNodeLogo(true, 0.2);
            ltd.setNodeLogoSubset(profileLength, terminus);
            ltd.setTitle(logoTreeTitle + "- Position " + (i - maxProfileLength + 1));
            if (leafLabelHighlightFile != null) {
                ArrayList list = null;
                try {
                    list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
            }
            ltd.setSequenceLogoStartIndex(-9);
            ltd.outputToPDF(new File(logoTreeOutput.toString() + "_pos" + (i - maxProfileLength + 1) + ".pdf"));
        }
    }

    public void runProfileClusterPosition(String profileListFileName, String filter, int profileLength, ProteinTerminus terminus, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> filteredColumnProfileList = null;
        List originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), 0, null, this.params.getFuzzFactor(), codonBiasFile, true);
        filteredColumnProfileList = new ArrayList<ProteinProfile>();
        for (int j = 0; j < originalProfileList.size(); ++j) {
            ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(j);
            filteredColumnProfileList.add(proteinProfile.getProfileSubsetCopy(filter));
        }
        clusterProfileList = filteredColumnProfileList;
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
        distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                return ProteinProfileDistance.calculateDistributionDistance(proteinProfile1, proteinProfile2);
            }
        });
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        for (int j = 0; j < clusterProfileList.size(); ++j) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(j);
            al.add(j, proteinProfile.getName());
        }
        distanceMatrix.setLabels(al);
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.setOptimalLeafOrdering(true);
        cluster.run();
        LogoTreeDraw ltd = new LogoTreeDraw(cluster, originalProfileList);
        ltd.setNodeLogoSubset(profileLength, terminus);
        ltd.setTitle(logoTreeTitle + "- Position " + filter);
        if (leafLabelHighlightFile != null) {
            ArrayList list = null;
            try {
                list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
        }
        ltd.setSequenceLogoStartIndex(-9);
        ltd.outputToPDF(new File(logoTreeOutput.toString() + "_pos" + filter));
    }

    private void writeProfileListToCytoscapeNodeAttributesFile(List originalProfileList, File nodeAttributeFileName) throws IOException {
        BufferedWriter brNA = new BufferedWriter(new FileWriter(nodeAttributeFileName));
        brNA.write("NumberOfPeptides");
        brNA.newLine();
        for (int i = 0; i < originalProfileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
            brNA.write(proteinProfile.getName() + " = " + proteinProfile.getNumSequences());
            brNA.newLine();
        }
        brNA.close();
    }

    public void runAllVsAllProfileDistancePairOutput(String profileListFileName) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), this.params.getFuzzFactor());
        for (int i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile1 = (ProteinProfile)profileList.get(i);
            for (int j = 0; j < profileList.size(); ++j) {
                ProteinProfile proteinProfile2 = (ProteinProfile)profileList.get(j);
                System.out.print(proteinProfile1.getName() + "_" + proteinProfile2.getName() + "\t");
                System.out.println(ProteinProfileDistance.calculateAAGroupedDistributionDistance(proteinProfile1, proteinProfile2, "STQN, KRH, DE, FLAMPWIVCY, G"));
            }
        }
    }

    public void runHistogramScoreAnalysis(String profileListFileName, String databaseName, String dbFileFormat, ProteinTerminus term) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(1.0);
        this.params.setDatabaseFileName(new File(databaseName));
        this.params.setDatabaseFormat(dbFileFormat);
        this.params.setScoreThreshold(25.0);
        ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(term);
        dbparams.setNormalized(true);
        dbparams.setDontSaveSequences(true);
        this.params.setSearchParams(dbparams);
        MultiSequenceSearchResultSet searchResults = this.runProfileSearch();
        Collection results = searchResults.getAllResultSets();
        HashMap<String, int[]> histMap = new HashMap<String, int[]>();
        for (SequenceSearchResultSet sequenceSearchResultSet : results) {
            int[] histogram = sequenceSearchResultSet.getScoreHistogram(25);
            histMap.put(sequenceSearchResultSet.getProfile().getName(), histogram);
        }
        Set keys = histMap.keySet();
        for (String name : keys) {
            System.out.print(name);
            int[] histogram = (int[])histMap.get(name);
            for (int i = 0; i < histogram.length; ++i) {
                int val = histogram[i];
                System.out.print("\t" + val);
            }
            System.out.println("");
        }
    }

    public List findAutoScoreThreshold(BrainParameterSet inputParams) {
        int maxScoreThreshold = 100;
        BrainParameterSet internalParams = new BrainParameterSet();
        internalParams.setDatabaseFileName(inputParams.getDatabaseFileName());
        internalParams.setDatabaseFormat(inputParams.getDatabaseFormat());
        internalParams.setScoreThreshold(100.0);
        internalParams.setFuzzFactor(inputParams.getFuzzFactor());
        ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(inputParams.getSearchParams().getTerminus());
        dbparams.setNormalized(inputParams.getSearchParams().isNormalized());
        dbparams.setDontSaveSequences(true);
        internalParams.setSearchParams(dbparams);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(inputParams.getProfileFile(), inputParams.getFuzzFactor());
        Double[] scoreThresholdArray = new Double[profileList.size()];
        MultiSequenceSearchResultSet searchResults = this.runProfileSearch(profileList, null, internalParams);
        Collection results = searchResults.getAllResultSets();
        for (SequenceSearchResultSet sequenceSearchResultSet : results) {
            int[] histogram = sequenceSearchResultSet.getScoreHistogram(100);
            int cumulativeHitCount = 0;
            for (int i = 0; i < histogram.length; ++i) {
                int j = histogram[i];
                if (cumulativeHitCount > 1 && j > cumulativeHitCount) {
                    scoreThresholdArray[profileList.indexOf((Object)sequenceSearchResultSet.getProfile())] = new Double(i - 1);
                    break;
                }
                cumulativeHitCount += j;
            }
            if (scoreThresholdArray[profileList.indexOf(sequenceSearchResultSet.getProfile())] != null) continue;
            scoreThresholdArray[profileList.indexOf((Object)sequenceSearchResultSet.getProfile())] = new Double(0.0);
        }
        return Arrays.asList(scoreThresholdArray);
    }

    public void runProteinSequenceSpaceCoverageAnalysis(File proteinsToCluster, File proteinsOfInterest, File failedProteins, String limitToColumns, int numberOfTrials) throws FileNotFoundException, BioException {
        int j;
        int j2;
        boolean report = true;
        BufferedReader brCluster = new BufferedReader(new FileReader(proteinsToCluster));
        SequenceIterator clusterProteins = (SequenceIterator)SeqIOTools.fileToBiojava((String)"fasta", (String)"PROTEIN", (BufferedReader)brCluster);
        ArrayList<String> clusterProteinSequenceStringList = new ArrayList<String>();
        ArrayList<String> clusterProteinNameList = new ArrayList<String>();
        ArrayList<Sequence> clusterProteinSequenceList = new ArrayList<Sequence>();
        while (clusterProteins.hasNext()) {
            Sequence sequence = clusterProteins.nextSequence();
            clusterProteinSequenceList.add(sequence);
            if (limitToColumns != null) {
                clusterProteinSequenceStringList.add(ProteinSequenceUtil.filterSequenceByColumns(sequence, limitToColumns));
            } else {
                clusterProteinSequenceStringList.add(sequence.seqString());
            }
            clusterProteinNameList.add(sequence.getName());
        }
        BufferedReader brInterest = new BufferedReader(new FileReader(proteinsOfInterest));
        SequenceIterator interestProteins = (SequenceIterator)SeqIOTools.fileToBiojava((String)"fasta", (String)"PROTEIN", (BufferedReader)brInterest);
        ArrayList<String> interestProteinNameList = new ArrayList<String>();
        while (interestProteins.hasNext()) {
            Sequence sequence = interestProteins.nextSequence();
            interestProteinNameList.add(sequence.getName());
        }
        BufferedReader brFailed = new BufferedReader(new FileReader(failedProteins));
        SequenceIterator failedProteinSequences = (SequenceIterator)SeqIOTools.fileToBiojava((String)"fasta", (String)"PROTEIN", (BufferedReader)brFailed);
        ArrayList<String> failedProteinNameList = new ArrayList<String>();
        while (failedProteinSequences.hasNext()) {
            Sequence sequence = failedProteinSequences.nextSequence();
            failedProteinNameList.add(sequence.getName());
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProteinSequenceStringList.size());
        distanceMatrix.setLabels(clusterProteinNameList);
        distanceMatrix.calcDistances(clusterProteinSequenceStringList, new AlignedProteinSequenceIdentityDistance());
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.run();
        if (report) {
            System.out.print(cluster.writeResultsToGTRFormat());
            System.out.println();
            cluster.setLabelHighlightInCDTOutput(interestProteinNameList, "#FFFF00");
            cluster.setLabelHighlightInCDTOutput(failedProteinNameList, "#FF0000");
            System.out.print(cluster.toCDTString());
            System.out.println();
        }
        if (report) {
            System.out.println("Number of Clusters\t% Sequences Covered\tLargest Cluster Size\tSmallest Cluster Size");
        }
        double[] sequenceSpaceCoverage = new double[distanceMatrix.getMatrixDimension()];
        int[] mostBiasedClusterAssignment = null;
        int mostBiasedClusterAssignmentLargestCluster = -1;
        for (int i = 1; i <= distanceMatrix.getMatrixDimension(); ++i) {
            int[] clusterAssignment = cluster.cutTree(i);
            int[] clusterSize = new int[i];
            int[] numberInterestingElementsInCluster = new int[i];
            int largestClusterSize = 0;
            int smallestClusterSize = Integer.MAX_VALUE;
            for (j2 = 0; j2 < clusterAssignment.length; ++j2) {
                int clusterID;
                int n = clusterID = clusterAssignment[j2];
                clusterSize[n] = clusterSize[n] + 1;
                if (!interestProteinNameList.contains(distanceMatrix.getLabels().get(j2))) continue;
                int n2 = clusterID;
                numberInterestingElementsInCluster[n2] = numberInterestingElementsInCluster[n2] + 1;
            }
            int totalSequencesCovered = 0;
            for (int j3 = 0; j3 < numberInterestingElementsInCluster.length; ++j3) {
                int numElements = numberInterestingElementsInCluster[j3];
                if (numElements <= 0) continue;
                totalSequencesCovered += clusterSize[j3];
            }
            int indexOfLargestCluster = -1;
            for (int j4 = 0; j4 < clusterSize.length; ++j4) {
                int size = clusterSize[j4];
                if (largestClusterSize < size) {
                    largestClusterSize = size;
                    indexOfLargestCluster = j4;
                }
                smallestClusterSize = Math.min(smallestClusterSize, size);
            }
            if (largestClusterSize <= interestProteinNameList.size() && mostBiasedClusterAssignment == null) {
                mostBiasedClusterAssignment = new int[clusterAssignment.length];
                System.arraycopy(clusterAssignment, 0, mostBiasedClusterAssignment, 0, clusterAssignment.length);
                mostBiasedClusterAssignmentLargestCluster = indexOfLargestCluster;
            }
            sequenceSpaceCoverage[i - 1] = (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension();
            if (!report) continue;
            System.out.println(i + "\t" + (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension() + "\t" + largestClusterSize + "\t" + smallestClusterSize);
        }
        if (report) {
            System.out.println();
        }
        ArrayList mostBiasedNameList = new ArrayList();
        for (int i = 0; i < mostBiasedClusterAssignment.length; ++i) {
            void clusterIndex = mostBiasedClusterAssignment[i];
            if (clusterIndex != mostBiasedClusterAssignmentLargestCluster) continue;
            mostBiasedNameList.add(clusterProteinNameList.get(i));
        }
        for (int k = 1; k <= distanceMatrix.getMatrixDimension(); ++k) {
            int[] clusterAssignment = cluster.cutTree(k);
            int[] clusterSize = new int[k];
            int[] numberInterestingElementsInCluster = new int[k];
            for (j = 0; j < clusterAssignment.length; ++j) {
                int clusterID;
                int n = clusterID = clusterAssignment[j];
                clusterSize[n] = clusterSize[n] + 1;
                if (!mostBiasedNameList.contains(distanceMatrix.getLabels().get(j))) continue;
                int n3 = clusterID;
                numberInterestingElementsInCluster[n3] = numberInterestingElementsInCluster[n3] + 1;
            }
            int totalSequencesCovered = 0;
            for (j2 = 0; j2 < numberInterestingElementsInCluster.length; ++j2) {
                int numElements = numberInterestingElementsInCluster[j2];
                if (numElements <= 0) continue;
                totalSequencesCovered += clusterSize[j2];
            }
            sequenceSpaceCoverage[k - 1] = (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension();
        }
        if (report) {
            for (int v = 0; v < sequenceSpaceCoverage.length; ++v) {
                System.out.println(v + 1 + "\t" + sequenceSpaceCoverage[v]);
            }
        }
        double[] sequenceSpaceCoverageSum = null;
        for (int i = 0; i < numberOfTrials; ++i) {
            ArrayList randomSequencelist = this.createRandomSamplingWithoutReplacement(clusterProteinSequenceList, interestProteinNameList.size());
            ArrayList<String> randomSequenceNameList = new ArrayList<String>();
            for (j = 0; j < randomSequencelist.size(); ++j) {
                Sequence sequence = (Sequence)randomSequencelist.get(j);
                randomSequenceNameList.add(sequence.getName());
            }
            for (int k = 1; k <= distanceMatrix.getMatrixDimension(); ++k) {
                int[] clusterAssignment = cluster.cutTree(k);
                int[] clusterSize = new int[k];
                int[] numberInterestingElementsInCluster = new int[k];
                for (int j5 = 0; j5 < clusterAssignment.length; ++j5) {
                    int clusterID;
                    int n = clusterID = clusterAssignment[j5];
                    clusterSize[n] = clusterSize[n] + 1;
                    if (!randomSequenceNameList.contains(distanceMatrix.getLabels().get(j5))) continue;
                    int n4 = clusterID;
                    numberInterestingElementsInCluster[n4] = numberInterestingElementsInCluster[n4] + 1;
                }
                int totalSequencesCovered = 0;
                for (int j6 = 0; j6 < numberInterestingElementsInCluster.length; ++j6) {
                    int numElements = numberInterestingElementsInCluster[j6];
                    if (numElements <= 0) continue;
                    totalSequencesCovered += clusterSize[j6];
                }
                sequenceSpaceCoverage[k - 1] = (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension();
            }
            if (sequenceSpaceCoverageSum == null) {
                sequenceSpaceCoverageSum = new double[sequenceSpaceCoverage.length];
            }
            if (!report) {
                for (int v = 0; v < sequenceSpaceCoverage.length; ++v) {
                    System.out.println(v + 1 + "\t" + sequenceSpaceCoverage[v]);
                }
            }
            for (j = 0; j < sequenceSpaceCoverage.length; ++j) {
                int n = j;
                sequenceSpaceCoverageSum[n] = sequenceSpaceCoverageSum[n] + sequenceSpaceCoverage[j];
            }
        }
        if (report) {
            double[] sequenceSpaceCoverageAverage = new double[sequenceSpaceCoverageSum.length];
            for (int i = 0; i < sequenceSpaceCoverageSum.length; ++i) {
                sequenceSpaceCoverageAverage[i] = sequenceSpaceCoverageSum[i] / (double)numberOfTrials;
                System.out.println(i + 1 + "\t" + sequenceSpaceCoverageAverage[i]);
            }
        }
    }

    private ArrayList createRandomSamplingWithoutReplacement(ArrayList itemsToSample, int numberOfSamples) {
        if (numberOfSamples > itemsToSample.size()) {
            throw new RuntimeException("Number of samples must be smaller than the size of the list given to sample.");
        }
        if (numberOfSamples == itemsToSample.size()) {
            return itemsToSample;
        }
        ArrayList randomSampling = new ArrayList();
        ArrayList sampleCopy = (ArrayList)itemsToSample.clone();
        for (int i = 0; i < numberOfSamples; ++i) {
            int randomIndex = (int)Math.round((double)(sampleCopy.size() - 1) * Math.random());
            randomSampling.add(sampleCopy.remove(randomIndex));
        }
        return randomSampling;
    }

    public void clusterProteinSequences(File proteinsToCluster) throws FileNotFoundException, BioException {
        BufferedReader brCluster = new BufferedReader(new FileReader(proteinsToCluster));
        SequenceIterator clusterProteins = (SequenceIterator)SeqIOTools.fileToBiojava((String)"fasta", (String)"PROTEIN", (BufferedReader)brCluster);
        ArrayList<String> clusterProteinSequenceStringList = new ArrayList<String>();
        ArrayList<String> clusterProteinNameList = new ArrayList<String>();
        ArrayList<Sequence> clusterProteinSequenceList = new ArrayList<Sequence>();
        while (clusterProteins.hasNext()) {
            Sequence sequence = clusterProteins.nextSequence();
            clusterProteinSequenceList.add(sequence);
            clusterProteinSequenceStringList.add(sequence.seqString());
            clusterProteinNameList.add(sequence.getName());
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProteinSequenceStringList.size());
        distanceMatrix.setLabels(clusterProteinNameList);
        distanceMatrix.calcDistances(clusterProteinSequenceStringList, new AlignedProteinSequenceIdentityDistance());
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.run();
        System.out.print(cluster.writeResultsToGTRFormat());
        System.out.println();
        System.out.print(cluster.toCDTString());
        System.out.println();
    }

    public void runFullRegexSearchToCytoscape(String proteinName, String queryDatabaseFileName, ProteinTerminus searchTerminus, int motifLength, String[] regexList, CyNetwork net) {
        ProteinDatabaseSearch search = null;
        try {
            search = new ProteinDatabaseSearch(queryDatabaseFileName, "FASTA"){

                public String getIdentifier(Sequence sequence) {
                    return null;
                }
            };
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        SequenceSearchResultSet results = null;
        for (int i = 0; i < regexList.length; ++i) {
            try {
                ProteinDatabaseSearchParams params = new ProteinDatabaseSearchParams(searchTerminus, motifLength);
                results = search.regexSearchDB(regexList[i], params);
            }
            catch (BioException e) {
                e.printStackTrace();
            }
            DatabaseReference protein = new DatabaseReference("SwissProt", proteinName);
            System.out.println("Found " + results.getNumberSequencesHit() + " matching sequences out of " + results.getNumberOfSequencesSearched() + " for regular expression " + regexList[i] + ".");
            try {
                search.reset();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (BioException e) {
                e.printStackTrace();
            }
        }
        SequenceSearchResultSet uniqueResults = results.getUniqueResultsBySequence();
        System.out.println("Found " + uniqueResults.getNumberSequencesHit() + " unique results.");
        System.out.println(uniqueResults);
        System.out.println("\n\n\n");
        PeptideChipDesign chip = null;
        try {
            chip = new PeptideChipDesign("D:\\Gbader\\Code\\PDZ\\data\\PDZ\\Protein chip design\\ecoli_preferredCodons.txt", uniqueResults);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        chip.setDescription("Worm chip");
        System.out.println(chip);
    }

    public BrainParameterSet getParams() {
        return this.params;
    }

    public void setParams(BrainParameterSet params) {
        this.params = params;
    }

    public void cancel() {
        this.search.setCancelled(true);
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    public void writeSequenceLogos(String profileListFileName, String outputDirectory, String codonBiasFileName, double fuzzFactor) {
        File codonBiasFile = null;
        if (codonBiasFileName != null) {
            codonBiasFile = new File(codonBiasFileName);
        }
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(new File(profileListFileName), 0, null, fuzzFactor, codonBiasFile, true);
        String outFileName = null;
        for (int i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            outFileName = new String(outputDirectory + File.separator + proteinProfile.getName() + ".png");
            ProteinSequenceLogo logo = new ProteinSequenceLogo(proteinProfile, 240);
            try {
                logo.sequenceLogoSetStartIndex(-9);
                ImageIO.write((RenderedImage)logo.drawSequenceLogo(), "png", new File(outFileName));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void findOverrepresentedGOTermsForAllPredictedPPIsForAllPossibleProfileClusters(AvgLinkHierarchicalClustering cluster, MultiSequenceSearchResultSet inputSearchResults) {
        HashMap profileLabelStringToEntrezGeneIDStringListMap = new HashMap();
        HashMap<String, String> entrezGeneIDToGeneName = new HashMap<String, String>();
        HashMap<String, String> entrezGeneIDToMotifAndScoreString = new HashMap<String, String>();
        Collection searchResults = inputSearchResults.getAllResultSets();
        for (SequenceSearchResultSet sequenceSearchResultSet : searchResults) {
            Set sequences = sequenceSearchResultSet.getSequences();
            ArrayList<String> entrezGeneIDs = new ArrayList<String>();
            for (Sequence sequence : sequences) {
                Sequence originalDBSequence = sequenceSearchResultSet.getOriginalSequence(sequence);
                DatabaseReference dbRef = GenPeptUtil.getEntrezGeneID(originalDBSequence);
                if (dbRef != null) {
                    String entrezGeneID = dbRef.getDbid();
                    entrezGeneIDs.add(entrezGeneID);
                    if (!entrezGeneIDToGeneName.containsKey(entrezGeneID)) {
                        entrezGeneIDToGeneName.put(entrezGeneID, GenPeptUtil.getGeneName(originalDBSequence));
                    }
                    if (entrezGeneIDToMotifAndScoreString.containsKey(entrezGeneID)) continue;
                    double bestScore = Double.MAX_VALUE;
                    String bestMotif = null;
                    List hits = sequenceSearchResultSet.getHits(sequence);
                    for (int i = 0; i < hits.size(); ++i) {
                        Hit hit = (Hit)hits.get(i);
                        if (!(hit.getScore() < bestScore)) continue;
                        bestScore = hit.getScore();
                        bestMotif = hit.getMatchString();
                    }
                    bestScore = BrainAlgorithm.truncateDouble(bestScore, 3);
                    entrezGeneIDToMotifAndScoreString.put(entrezGeneID, bestMotif + ":" + bestScore);
                    continue;
                }
                System.out.println("Couldn't find a database reference for " + sequence.getName());
            }
            profileLabelStringToEntrezGeneIDStringListMap.put(sequenceSearchResultSet.getProfile().getName(), entrezGeneIDs);
        }
        for (int i = 1; i <= cluster.getNelements(); ++i) {
            int j;
            int j2;
            int[] clusterAssignment = cluster.cutTree(i);
            ArrayList[] clusterIDToProfileLabelStringListArray = new ArrayList[i];
            for (j2 = 0; j2 < i; ++j2) {
                clusterIDToProfileLabelStringListArray[j2] = new ArrayList();
            }
            for (j2 = 0; j2 < clusterAssignment.length; ++j2) {
                int clusterID = clusterAssignment[j2];
                clusterIDToProfileLabelStringListArray[clusterID].add(cluster.getLabel(j2));
            }
            Vector[] clusterIDToEntrezGeneIDStringVectorArray = new Vector[i];
            for (j = 0; j < i; ++j) {
                clusterIDToEntrezGeneIDStringVectorArray[j] = new Vector();
            }
            for (j = 0; j < i; ++j) {
                ArrayList profileLabelList = clusterIDToProfileLabelStringListArray[j];
                for (int k = 0; k < profileLabelList.size(); ++k) {
                    String profileLabel = (String)profileLabelList.get(k);
                    ArrayList entrezGeneIDs = (ArrayList)profileLabelStringToEntrezGeneIDStringListMap.get(profileLabel);
                    for (int l = 0; l < entrezGeneIDs.size(); ++l) {
                        String entrezGeneID = (String)entrezGeneIDs.get(l);
                        if (clusterIDToEntrezGeneIDStringVectorArray[j].contains(entrezGeneID)) continue;
                        clusterIDToEntrezGeneIDStringVectorArray[j].add(entrezGeneID);
                    }
                }
            }
            String clusterCutDirName = "D:\\Gbader\\Code\\PDZ\\data\\PDZ\\PPI Prediction\\ORA\\ClusterBiNGO\\ClusterCutInto" + i + "\\";
            File newDir = new File(clusterCutDirName);
            newDir.mkdirs();
            for (int j3 = 0; j3 < i; ++j3) {
                Vector entrezGeneIDList = clusterIDToEntrezGeneIDStringVectorArray[j3];
                String bingoDir = "D:\\Gbader\\Code\\PDZ\\data\\DBs\\BiNGO-data-v1_1_nov2005";
                SettingsPanel settingsPanel = new SettingsPanel(bingoDir);
                BiNGOOntologyFlatFileReader readerOntology = null;
                String ontologyFile = "D:\\Gbader\\Code\\PDZ\\data\\DBs\\BiNGO-data-v1_1_nov2005\\GO_Biological_Process";
                try {
                    readerOntology = new BiNGOOntologyFlatFileReader(new File(ontologyFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Ontology ontology = readerOntology.getOntology();
                HashMap synonymHash = readerOntology.getSynonymHash();
                BiNGOAnnotationDefaultReader readerAnnotation = null;
                String annotationFile = "D:\\Gbader\\Code\\PDZ\\data\\DBs\\BiNGO-data-v1_1_nov2005\\H_sapiens_default";
                try {
                    String idString = "Entrez GeneID";
                    readerAnnotation = new BiNGOAnnotationDefaultReader(new File(annotationFile), synonymHash, (Component)settingsPanel, idString, "Homo Sapiens", "GO Biological Process", "GO");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Annotation annotation = readerAnnotation.getAnnotation();
                Vector selectedNodes = entrezGeneIDList;
                String[] nodes = annotation.getNames();
                Vector<String> allNodes = new Vector<String>();
                for (int n = 0; n < nodes.length; ++n) {
                    if (nodes[n] == null || nodes[n].length() == 0) continue;
                    allNodes.add(nodes[n].toUpperCase());
                }
                HypergeometricTestCalculate test = new HypergeometricTestCalculate(selectedNodes, allNodes, annotation, ontology);
                test.calculate();
                HashMap testMap = test.getTestMap();
                HashMap mapSmallX = test.getMapSmallX();
                HashMap mapSmallN = test.getMapSmallN();
                int bigX = test.getBigX();
                int bigN = test.getBigN();
                String alphaString = "0.05";
                String correctionString = "Benjamini & Hochberg False Discovery Rate (FDR) correction";
                MultipleTestingCorrection mtc = new MultipleTestingCorrection(alphaString, testMap, correctionString);
                mtc.calculate();
                HashMap correctionMap = mtc.getCorrectionMap();
                try {
                    String testString = "Hypergeometric";
                    String overUnderString = "Over-representation";
                    String dirName = clusterCutDirName;
                    String fileName = "Node" + Integer.toString(j3) + ".txt";
                    String clusterVsString = "Vs. genome";
                    String catString = "Over-represented categories after correction";
                    Vector selectedCanonicalNameVector = selectedNodes;
                    HashMap annotatedGenes = new HashMap();
                    String dateString = DateFormat.getDateInstance().format(new Date());
                    String timeString = DateFormat.getTimeInstance().format(new Date());
                    String NONE = "---";
                    String CATEGORY_BEFORE_CORRECTION = "Overrepresented categories before correction";
                    String CATEGORY_CORRECTION = "Overrepresented categories after correction";
                    File results = new File(dirName, fileName);
                    BufferedWriter output = new BufferedWriter(new FileWriter(results));
                    System.out.println("BiNGO results file: " + results.getPath());
                    output.write("File created with BiNGO (c) on " + dateString + " at " + timeString);
                    output.newLine();
                    output.write(ontology.toString());
                    output.newLine();
                    output.write("Selected ontology file: " + ontologyFile);
                    output.newLine();
                    output.write("Selected annotation file: " + annotationFile);
                    output.newLine();
                    output.write(overUnderString);
                    output.newLine();
                    output.write("Selected statistical test: " + testString);
                    output.newLine();
                    output.write("Selected correction: " + correctionString);
                    output.newLine();
                    output.write("Selected significance level: " + alphaString);
                    output.newLine();
                    output.write("Testing option: " + clusterVsString);
                    output.newLine();
                    output.write("The selected profiles: ");
                    ArrayList arrayList = clusterIDToProfileLabelStringListArray[j3];
                    for (int l = 0; l < arrayList.size(); ++l) {
                        String s = (String)arrayList.get(l);
                        output.write(s);
                        if (l >= arrayList.size() - 1) continue;
                        output.write(", ");
                    }
                    output.newLine();
                    output.write("The selected predicted binders: ");
                    for (int n = 0; n < selectedCanonicalNameVector.size(); ++n) {
                        int[] nodeClassifications = annotation.getClassifications(selectedCanonicalNameVector.get(n).toString());
                        for (int k = 0; k < nodeClassifications.length; ++k) {
                            String cat = new Integer(nodeClassifications[k]).toString();
                            if (!annotatedGenes.containsKey(cat)) {
                                HashSet catset = new HashSet();
                                annotatedGenes.put(cat, catset);
                            }
                            ((HashSet)annotatedGenes.get(cat)).add(selectedCanonicalNameVector.get(n).toString());
                        }
                        output.write(entrezGeneIDToGeneName.get(selectedCanonicalNameVector.get(n).toString()) + " (" + entrezGeneIDToMotifAndScoreString.get(selectedCanonicalNameVector.get(n).toString()) + ")");
                        if (n >= selectedCanonicalNameVector.size() - 1) continue;
                        output.write(", ");
                    }
                    output.newLine();
                    output.newLine();
                    output.write("Number of genes selected: " + bigX);
                    output.newLine();
                    output.write("Total number of genes in annotation: " + bigN);
                    output.newLine();
                    output.newLine();
                    if (testString.equals(NONE)) {
                        output.write("GO-ID\t# selected\t# total\tDescription\tGenes in test set");
                        output.newLine();
                    } else if (correctionString.equals(NONE)) {
                        output.write("GO-ID\tp-value\t# selected\t# total\tDescription\tGenes in test set");
                        output.newLine();
                    } else {
                        output.write("GO-ID\tp-value\tcorr p-value# selected\t# total\tDescription\tGenes in test set");
                        output.newLine();
                    }
                    HashSet keySet = !testString.equals(NONE) ? new HashSet(testMap.keySet()) : new HashSet(mapSmallX.keySet());
                    Iterator it = keySet.iterator();
                    String[] keyLabels = new String[keySet.size()];
                    int n = 0;
                    while (it.hasNext()) {
                        keyLabels[n] = it.next().toString();
                        ++n;
                    }
                    String[] ordenedKeySet = !testString.equals(NONE) ? this.orderKeysByPvalues(keyLabels, testMap) : this.orderKeysBySmallX(keyLabels, mapSmallX);
                    boolean ok = true;
                    for (int n2 = 0; n2 < ordenedKeySet.length && ok; ++n2) {
                        Iterator k;
                        String description;
                        String smallN;
                        String smallX;
                        String termID = ordenedKeySet[n2];
                        String pvalue = "";
                        String correctedPvalue = "";
                        if (!testString.equals(NONE)) {
                            try {
                                pvalue = SignificantFigures.sci_format((String)testMap.get(new Integer(termID)).toString(), (int)5);
                            }
                            catch (Exception e) {
                                pvalue = "N/A";
                            }
                        } else {
                            pvalue = "N/A";
                        }
                        if (!correctionString.equals(NONE)) {
                            try {
                                correctedPvalue = SignificantFigures.sci_format((String)correctionMap.get(termID).toString(), (int)5);
                            }
                            catch (Exception e) {
                                correctedPvalue = "N/A";
                            }
                        } else {
                            correctedPvalue = "N/A";
                        }
                        try {
                            smallX = mapSmallX.get(new Integer(termID)).toString();
                        }
                        catch (Exception e) {
                            smallX = "N/A";
                        }
                        try {
                            smallN = mapSmallN.get(new Integer(termID)).toString();
                        }
                        catch (Exception e) {
                            smallN = "N/A";
                        }
                        try {
                            description = ontology.getTerm(Integer.parseInt(termID)).getName();
                        }
                        catch (Exception e) {
                            description = "?";
                        }
                        if (testString.equals(NONE)) {
                            output.write(termID + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                            if (annotatedGenes.containsKey(termID)) {
                                k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                while (k.hasNext()) {
                                    output.write(k.next().toString());
                                    if (!k.hasNext()) continue;
                                    output.write(124);
                                }
                            }
                            output.write("\n");
                            continue;
                        }
                        if (correctionString.equals(NONE)) {
                            if (catString.equals(CATEGORY_BEFORE_CORRECTION)) {
                                if (new BigDecimal(testMap.get(new Integer(ordenedKeySet[n2])).toString()).compareTo(new BigDecimal(alphaString)) < 0) {
                                    output.write(termID + "\t" + pvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                                    if (annotatedGenes.containsKey(termID)) {
                                        k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                        while (k.hasNext()) {
                                            output.write(k.next().toString());
                                            if (!k.hasNext()) continue;
                                            output.write(124);
                                        }
                                    }
                                    output.newLine();
                                    continue;
                                }
                                ok = false;
                                continue;
                            }
                            output.write(termID + "\t" + pvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                            if (annotatedGenes.containsKey(termID)) {
                                k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                while (k.hasNext()) {
                                    output.write(k.next().toString());
                                    if (!k.hasNext()) continue;
                                    output.write(124);
                                }
                            }
                            output.write("\n");
                            continue;
                        }
                        if (catString.equals(CATEGORY_CORRECTION)) {
                            if (new BigDecimal(correctionMap.get(ordenedKeySet[n2]).toString()).compareTo(new BigDecimal(alphaString)) < 0) {
                                output.write(termID + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                                if (annotatedGenes.containsKey(termID)) {
                                    k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                    while (k.hasNext()) {
                                        output.write((String)entrezGeneIDToGeneName.get(k.next().toString()));
                                        if (!k.hasNext()) continue;
                                        output.write(124);
                                    }
                                }
                                output.newLine();
                                continue;
                            }
                            ok = false;
                            continue;
                        }
                        if (catString.equals(CATEGORY_BEFORE_CORRECTION)) {
                            if (new BigDecimal(testMap.get(new Integer(ordenedKeySet[n2])).toString()).compareTo(new BigDecimal(alphaString)) < 0) {
                                output.write(termID + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                                if (annotatedGenes.containsKey(termID)) {
                                    k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                    while (k.hasNext()) {
                                        output.write(k.next().toString());
                                        if (!k.hasNext()) continue;
                                        output.write(124);
                                    }
                                }
                                output.newLine();
                                continue;
                            }
                            ok = false;
                            continue;
                        }
                        output.write(termID + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                        if (annotatedGenes.containsKey(termID)) {
                            k = ((HashSet)annotatedGenes.get(termID)).iterator();
                            while (k.hasNext()) {
                                output.write((String)entrezGeneIDToGeneName.get(k.next().toString()));
                                if (!k.hasNext()) continue;
                                output.write(124);
                            }
                        }
                        output.newLine();
                    }
                    output.close();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Error: " + e);
                }
            }
        }
    }

    private static double truncateDouble(double inputDouble, int numberSignificantDigits) {
        double returnDouble = inputDouble * Math.pow(10.0, numberSignificantDigits);
        returnDouble = Math.rint(returnDouble);
        return returnDouble / Math.pow(10.0, numberSignificantDigits);
    }

    public String[] orderKeysByPvalues(String[] labels, HashMap testMap) {
        for (int i = 1; i < labels.length; ++i) {
            String insert_label = labels[i];
            BigDecimal val = new BigDecimal(testMap.get(new Integer(labels[i])).toString());
            for (int j = i; j > 0 && val.compareTo(new BigDecimal(testMap.get(new Integer(labels[j - 1])).toString())) < 0; --j) {
                labels[j] = labels[j - 1];
            }
            labels[j] = insert_label;
        }
        return labels;
    }

    public String[] orderKeysBySmallX(String[] labels, HashMap mapSmallX) {
        for (int i = 1; i < labels.length; ++i) {
            String insert_label = labels[i];
            BigDecimal val = new BigDecimal(mapSmallX.get(new Integer(labels[i])).toString());
            for (int j = i; j > 0 && val.compareTo(new BigDecimal(mapSmallX.get(new Integer(labels[j - 1])).toString())) > 0; --j) {
                labels[j] = labels[j - 1];
            }
            labels[j] = insert_label;
        }
        return labels;
    }

    public double calculateSpecificityScoreCorrectionFactor(String codonBiasFileName) {
        int i;
        File codonBiasFile = null;
        if (codonBiasFileName != null) {
            codonBiasFile = new File(codonBiasFileName);
        }
        String aaList = "ACDEFGHIKLMNPQRSTVWYX";
        double[] codonBias = new double["ACDEFGHIKLMNPQRSTVWYX".length()];
        try {
            BufferedReader br = new BufferedReader(new FileReader(codonBiasFile));
            String fileLine = null;
            while ((fileLine = br.readLine()) != null) {
                String[] aaBiasString = fileLine.split("\\t");
                if (aaBiasString.length == 2) {
                    String residue = aaBiasString[0];
                    codonBias["ACDEFGHIKLMNPQRSTVWYX".indexOf((String)residue)] = Double.parseDouble(aaBiasString[1]);
                    continue;
                }
                System.out.println("Codon bias file is malformed.  Expecting two tab-delimited columns, but found " + fileLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double sum = 0.0;
        for (i = 0; i < codonBias.length; ++i) {
            double bias = codonBias[i];
            sum += bias;
        }
        for (i = 0; i < codonBias.length; ++i) {
            codonBias[i] = codonBias[i] / sum;
        }
        double information = Math.log(20.0) / Math.log(2.0);
        for (int i2 = 0; i2 < codonBias.length; ++i2) {
            double p = codonBias[i2];
            if (p == 0.0) continue;
            double lp = Math.log(p);
            information -= -p * lp / Math.log(2.0);
        }
        return Math.pow(2.0, information);
    }

    public void calculateSpecificityScoreForAllProfiles(String profileListFileName, String codonBiasFileName, int profileLength, ProteinTerminus terminus) {
        double specificityScoreCorrectionFactor = this.calculateSpecificityScoreCorrectionFactor(codonBiasFileName);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(new File(profileListFileName), profileLength, terminus, 0.0, null, true);
        System.out.println(specificityScoreCorrectionFactor);
        System.out.println("PDZ\t-9\t-8\t-7\t-6\t-5\t-4\t-3\t-2\t-1\tFull Profile\tEffective Specificity Residues\tNumber of Peptides");
        for (int i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            System.out.print(proteinProfile.getName() + "\t");
            double profileSpecificityScore = 1.0;
            for (int j = 0; j < proteinProfile.getNumColumns(); ++j) {
                ProteinProfile subsetPosition = proteinProfile.getProfileSubsetCopy(Integer.toString(j));
                double correctedPositionSpecificityScore = subsetPosition.calculateSpecificityScore() - specificityScoreCorrectionFactor;
                if (correctedPositionSpecificityScore < 1.0) {
                    correctedPositionSpecificityScore = 1.0;
                }
                profileSpecificityScore *= correctedPositionSpecificityScore;
                System.out.print(correctedPositionSpecificityScore + "\t");
            }
            System.out.println(profileSpecificityScore + "\t" + Math.log(profileSpecificityScore) / Math.log(20.0) + "\t" + proteinProfile.getNumSequences());
        }
    }

    public static void main(String[] args) {
        BrainAlgorithm alg = new BrainAlgorithm();
    }

    private static void GoORAAnalysis(BrainAlgorithm alg) {
        ArrayList<ProteinProfile> originalProfileList;
        BrainParameterSet params = new BrainParameterSet();
        params.setProfileFileName(new File("D:\\Gbader\\Code\\PDZ\\data\\PDZ\\BindingProfiles\\Human\\ProfileDataSets-ProjectFiles\\ProjectFile.txt"));
        params.setFuzzFactor(1.0);
        params.setDatabaseFileName(new File("D:\\Gbader\\Code\\PDZ\\data\\DBs\\refseq_May16_2005_human.protein.gpff"));
        params.setDatabaseFormat("genpept");
        ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(ProteinTerminus.C);
        dbparams.setNormalized(true);
        params.setSearchParams(dbparams);
        alg.setParams(params);
        System.out.println("Searching...");
        MultiSequenceSearchResultSet searchResults = alg.runProfileSearch(null, alg.findAutoScoreThreshold(params), params);
        System.out.println("Clustering...");
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> cutProfileList = null;
        params.setFuzzFactor(0.0);
        clusterProfileList = originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(params.getProfileFile(), 0, null, params.getFuzzFactor(), new File("D:\\Gbader\\Code\\PDZ\\data\\PDZ\\BindingProfiles\\Human\\PhageCodonBias\\phageLibraryNNKTheoreticalCodonBias.txt"), true);
        int profileLength = 4;
        if (profileLength > 0) {
            cutProfileList = new ArrayList<ProteinProfile>();
            for (int i = 0; i < originalProfileList.size(); ++i) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
                cutProfileList.add(proteinProfile.getTruncatedProfileCopy(profileLength, ProteinTerminus.C));
            }
            clusterProfileList = cutProfileList;
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
        distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                String groupingByPosition = AminoAcidGrouping.getPolarChargedHydrophobeGrouping();
                return ProteinProfileDistance.calculateAAGroupedDistributionDistance(proteinProfile1, proteinProfile2, groupingByPosition);
            }
        });
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        for (int i = 0; i < clusterProfileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(i);
            al.add(i, proteinProfile.getName());
        }
        distanceMatrix.setLabels(al);
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.setOptimalLeafOrdering(false);
        cluster.run();
        System.out.println("Running ORA...");
        alg.findOverrepresentedGOTermsForAllPredictedPPIsForAllPossibleProfileClusters(cluster, searchResults);
    }
}

