/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinSequenceLogo;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dp.SimpleWeightMatrix;

public class LogoSizeSpecification {
    public double columnWidth;
    public double columnHeight;
    public double padLeft;
    public double padBottom;
    public double logoWidth;
    public double logoHeight;
    public double yAxisTickLength;
    public double fontSize;
    public int minColumnIndex;
    public int maxColumnIndex;
    public int numberOfColumns;
    public int sequenceAlphabetSize;

    public LogoSizeSpecification(ProteinSequenceLogo proteinSequenceLogo, ProteinProfile profile, int logoHeight) {
        double columnAspectHeight = 10.0;
        double columnAspectWidth = 3.0;
        double leftPadAspect = 2.0;
        double bottomPadAspect = 2.0;
        double yAxisTickLengthAspect = 0.5;
        double fontAspect = 0.75;
        double unit = 0.0;
        SimpleWeightMatrix wm = profile.getWeightMatrix();
        this.minColumnIndex = Integer.MAX_VALUE;
        this.maxColumnIndex = Integer.MIN_VALUE;
        double bits = Math.log(20.0) / Math.log(2.0);
        if (proteinSequenceLogo.isTrimLogo()) {
            for (int pos = 0; pos < wm.columns(); ++pos) {
                Distribution dist = wm.getColumn(pos);
                double informationBits = DistributionTools.bitsOfInformation((Distribution)dist);
                double informationPercentage = informationBits / bits;
                if (!(proteinSequenceLogo.getTrimLogoPercentage() < informationPercentage)) continue;
                this.minColumnIndex = Math.min(this.minColumnIndex, pos);
                this.maxColumnIndex = Math.max(this.maxColumnIndex, pos);
            }
        } else {
            this.minColumnIndex = 0;
            this.maxColumnIndex = wm.columns() - 1;
        }
        this.numberOfColumns = this.maxColumnIndex - this.minColumnIndex + 1;
        this.columnHeight = (double)logoHeight / (columnAspectHeight + bottomPadAspect) * columnAspectHeight;
        unit = this.columnHeight / columnAspectHeight;
        this.columnWidth = unit * columnAspectWidth;
        this.padLeft = unit * leftPadAspect;
        this.padBottom = unit * bottomPadAspect;
        this.logoWidth = this.columnWidth * (double)this.numberOfColumns + this.padLeft;
        this.logoHeight = logoHeight;
        this.yAxisTickLength = unit * yAxisTickLengthAspect;
        this.fontSize = unit * fontAspect;
        this.sequenceAlphabetSize = 20;
    }
}

