/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.BinomialCoefficients;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BinomialDistribution {
    private static int x;
    private static int bigX;
    private static int n;
    private static int bigN;
    private static final int SCALE_RESULT = 100;

    public BinomialDistribution(int x, int bigX, int n, int bigN) {
        BinomialDistribution.x = x;
        BinomialDistribution.bigX = bigX;
        BinomialDistribution.n = n;
        BinomialDistribution.bigN = bigN;
    }

    public String calculateBinomialDistribution() {
        BigDecimal sum = new BigDecimal("0");
        BinomialCoefficients bi = new BinomialCoefficients();
        BigDecimal nByN = new BigDecimal((double)n).divide(new BigDecimal((double)bigN), 100, 4);
        BigDecimal oneMin_nByN = nByN.negate().add(new BigDecimal("1"));
        for (int i = 0; i < x; ++i) {
            BigInteger c_X_i = bi.calculateBinomialCoefficients(bigX, i);
            BigDecimal n_pow_i = new BigDecimal(new BigInteger(new String(n + "")).pow(i));
            BigDecimal N_pow_i = new BigDecimal(new BigInteger(new String(bigN + "")).pow(i));
            BigDecimal N_min_n_pow_X_min_i = new BigDecimal(new BigInteger(new String(bigN - n + "")).pow(bigX - i));
            BigDecimal N_pow_X_min_i = new BigDecimal(new BigInteger(new String(bigN + "")).pow(bigX - i));
            BigDecimal n_div_N_i = n_pow_i.divide(N_pow_i, 100, 4);
            BigDecimal one_min_n_div_N_pow_X_min_i = N_min_n_pow_X_min_i.divide(N_pow_X_min_i, 100, 4);
            BigDecimal product = new BigDecimal(c_X_i).setScale(100, 4);
            product = product.multiply(n_div_N_i).setScale(100, 4);
            product = product.multiply(one_min_n_div_N_pow_X_min_i).setScale(100, 4);
            sum = sum.add(product).setScale(100, 4);
        }
        sum = sum.negate();
        BigDecimal result = sum.add(new BigDecimal("1"));
        return result.toString();
    }

    BigDecimal decimalPow(BigDecimal x, BigInteger pow) {
        if (pow.equals(new BigInteger("0"))) {
            return new BigDecimal("1");
        }
        BigDecimal product = x;
        BigInteger i = new BigInteger("1");
        while (!i.equals(pow)) {
            product = product.multiply(x);
            i = i.add(new BigInteger("1"));
        }
        return product.setScale(100, 4);
    }
}

